/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker.CastSpellGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker.SmashGoal;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WealdWalker
extends AgeableMob
implements GeoEntity,
IAnimationListener,
RangedAttackMob,
IWandable,
ITooltipProvider {
    public static final EntityDataAccessor<Boolean> SMASHING = SynchedEntityData.defineId(WealdWalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CASTING = SynchedEntityData.defineId(WealdWalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.defineId(WealdWalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(WealdWalker.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public int smashCooldown;
    public int castCooldown;
    public Spell spell = new Spell();
    public ParticleColor color = ParticleColor.defaultParticleColor();
    AnimationController attackController;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WealdWalker(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 20L == 0L && !this.isDeadOrDying()) {
            this.heal(1.0f);
        }
    }

    public InteractionResult mobInteract(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.getItemInHand(p_230254_2_);
        if (itemstack.getItem() instanceof BoneMealItem && this.isBaby()) {
            int i = this.getAge();
            if (this.isBaby()) {
                this.usePlayerItem(p_230254_1_, itemstack);
                this.ageUp((int)((float)(-i / 20) * 0.1f), true);
                return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            if (this.level.isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(p_230254_1_, p_230254_2_);
    }

    protected void usePlayerItem(Player p_175505_1_, ItemStack p_175505_2_) {
        if (!p_175505_1_.getAbilities().instabuild) {
            p_175505_2_.shrink(1);
        }
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.setHome(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.home_set"));
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pPose) {
        return this.isBaby() ? EntityDimensions.fixed((float)1.0f, (float)1.0f) : super.getDefaultDimensions(pPose);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public void die(DamageSource source) {
        if (!this.isBaby() && !this.level.isClientSide) {
            this.setBaby(true);
            this.refreshDimensions();
            this.setHealth(60.0f);
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition().above());
            if (source.getEntity() != null && source.getEntity() instanceof Mob) {
                ((Mob)source.getEntity()).setTarget(null);
            }
            return;
        }
        super.die(source);
    }

    public void setBaby(boolean baby) {
        super.setBaby(baby);
        this.entityData.set(BABY, (Object)baby);
    }

    public void setAge(int age) {
        this.age = age;
        if (this.age >= 0 && !this.level.isClientSide) {
            this.ageBoundaryReached();
        }
    }

    public void setHome(BlockPos home) {
        this.entityData.set(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.level.isClientSide) {
            this.entityData.set(BABY, (Object)false);
        }
    }

    public boolean isBaby() {
        return (Boolean)this.entityData.get(BABY);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_184206_1_) {
        if (BABY.equals(p_184206_1_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_184206_1_);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 10, () -> this.getTarget() == null || this.isBaby()));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, entity -> {
            TamableAnimal tamableAnimal;
            if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
                return false;
            }
            return entity instanceof Enemy;
        }));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SmashGoal(this, true, () -> this.smashCooldown <= 0 && (Boolean)this.entityData.get(BABY) == false, Animations.SMASH.ordinal(), 25, 5));
        this.goalSelector.addGoal(2, (Goal)new CastSpellGoal(this, 1.2, 15.0f, () -> this.castCooldown <= 0 && (Boolean)this.entityData.get(BABY) == false, Animations.CAST.ordinal(), 20));
    }

    public boolean isAlliedTo(Entity pEntity) {
        TamableAnimal tamableAnimal;
        return !(pEntity instanceof Enemy) || pEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pEntity).isTame() || super.isAlliedTo(pEntity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SMASHING, (Object)false);
        pBuilder.define(CASTING, (Object)false);
        pBuilder.define(BABY, (Object)false);
        pBuilder.define(HOME, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("isBaby", ((Boolean)this.entityData.get(BABY)).booleanValue());
        NBTUtil.storeBlockPos(tag, "home", this.getHome());
        tag.putInt("smash", this.smashCooldown);
        tag.putInt("cast", this.castCooldown);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(BABY, (Object)tag.getBoolean("isBaby"));
        if (NBTUtil.hasBlockPos(tag, "home")) {
            this.setHome(NBTUtil.getBlockPos(tag, "home"));
        }
        this.smashCooldown = tag.getInt("smash");
        this.castCooldown = tag.getInt("cast");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "run_controller", 1, this::runController));
        this.attackController = new AnimationController((GeoAnimatable)this, "attack_controller", 5, this::attackController);
        data.add(this.attackController);
    }

    private PlayState attackController(AnimationState<?> AnimationState2) {
        return PlayState.CONTINUE;
    }

    private PlayState runController(AnimationState AnimationState2) {
        if (((Boolean)this.entityData.get(SMASHING)).booleanValue() || ((Boolean)this.entityData.get(CASTING)).booleanValue()) {
            return PlayState.STOP;
        }
        if (AnimationState2.getController().getCurrentAnimation() != null && !AnimationState2.getController().getCurrentAnimation().animation().name().equals("run_master")) {
            return PlayState.STOP;
        }
        if (AnimationState2.isMoving()) {
            AnimationState2.getController().setAnimation(RawAnimation.begin().thenPlay("run_master"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (arg == Animations.SMASH.ordinal()) {
                if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animation().name().equals("smash")) {
                    return;
                }
                this.attackController.forceAnimationReset();
                this.attackController.setAnimation(RawAnimation.begin().thenPlay("smash").thenPlay("idle"));
            }
            if (arg == Animations.CAST.ordinal()) {
                if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animation().name().equals("cast")) {
                    return;
                }
                this.attackController.forceAnimationReset();
                this.attackController.setAnimation(RawAnimation.begin().thenPlay("cast").thenPlay("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 10.5);
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public void performRangedAttack(LivingEntity entity, float p_82196_2_) {
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.level, this.spell, (LivingEntity)this, new LivingCaster((LivingEntity)this)).withColors(this.color));
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(this.level, resolver);
        projectileSpell.setColor(this.color);
        projectileSpell.shoot((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 1.0f, 0.8f);
        this.level.addFreshEntity((Entity)projectileSpell);
        this.castCooldown = 40;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.getHome() != null) {
            String home = this.getHome().getX() + ", " + this.getHome().getY() + ", " + this.getHome().getZ();
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{home}));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{Component.translatable((String)"ars_nouveau.nothing").getString()}));
        }
    }

    public static enum Animations {
        CAST,
        SMASH;

    }
}

