/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityWallSpell
extends EntityProjectileSpell {
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> LANDED = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SENSITIVE = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final EntityDataAccessor<Boolean> SHOULD_FALL = SynchedEntityData.defineId(EntityWallSpell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public double extendedTime;
    public int maxProcs = 100;
    public int totalProcs;
    List<EntityHit> hitEntities = new ArrayList<EntityHit>();
    public float growthFactor = 1.0f;

    public EntityWallSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.WALL_SPELL.get()), worldIn);
    }

    public EntityWallSpell(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.WALL_SPELL.get()), worldIn, x, y, z);
    }

    public EntityWallSpell(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.WALL_SPELL.get()), worldIn, shooter);
    }

    public void setAccelerates(int accelerates) {
        this.entityData.set(ACCELERATES, (Object)accelerates);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            if (this.spellResolver == null) {
                return;
            }
            boolean isOnGround = this.level.getBlockState(this.blockPosition()).blocksMotion();
            this.setLanded(isOnGround);
        }
        super.tick();
        this.castSpells();
    }

    @Override
    public void traceAnyHit(@Nullable HitResult raytraceresult, Vec3 thisPosition, Vec3 nextPosition) {
    }

    @Override
    public void tickNextPosition() {
        if (!this.shouldFall()) {
            return;
        }
        if (!this.getLanded()) {
            this.setDeltaMovement(0.0, -0.2, 0.0);
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        super.tickNextPosition();
    }

    public void castSpells() {
        if (this.level.isClientSide) {
            return;
        }
        float aoe = this.getAoe();
        int flatAoe = Math.round(aoe);
        BlockPos start = this.blockPosition().offset(flatAoe * this.getDirection().getStepX(), 0, flatAoe * this.getDirection().getStepZ());
        BlockPos end = this.blockPosition().offset(-flatAoe * this.getDirection().getStepX(), flatAoe, -flatAoe * this.getDirection().getStepZ());
        if (this.isSensitive()) {
            if (this.age % (20 - 2 * this.getAccelerates()) != 0 && this.age != 1) {
                return;
            }
            for (BlockPos p : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
                p = p.immutable();
                this.spellResolver.getNewResolver(this.spellResolver.spellContext.clone().makeChildContext()).onResolveEffect(this.level, (HitResult)new BlockHitResult(new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()), Direction.UP, p, false));
            }
        } else {
            int i = 0;
            AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)start, (BlockPos)end);
            if (aabb.maxX == aabb.minX) {
                aabb = aabb.inflate((double)this.growthFactor, 0.0, 0.0);
            }
            if (aabb.maxY == aabb.minY) {
                aabb = aabb.inflate(0.0, (double)this.growthFactor, 0.0);
            }
            if (aabb.maxZ == aabb.minZ) {
                aabb = aabb.inflate(0.0, 0.0, (double)this.growthFactor);
            }
            for (Entity entity : this.level.getEntities(null, aabb)) {
                if (entity.equals((Object)this) || entity.getType().is(EntityTags.LINGERING_BLACKLIST)) continue;
                Optional<EntityHit> hit = this.hitEntities.stream().filter(e -> e.entity.refersTo(entity)).findFirst();
                boolean skipEntity = hit.isPresent();
                if (hit.isPresent() && this.level.getGameTime() - hit.get().gameTime > 20L) {
                    this.hitEntities.remove(hit.get());
                    skipEntity = false;
                }
                if (skipEntity) continue;
                this.spellResolver.getNewResolver(this.spellResolver.spellContext.clone().makeChildContext()).onResolveEffect(this.level, (HitResult)new EntityHitResult(entity));
                ++i;
                if (hit.isEmpty()) {
                    this.hitEntities.add(new EntityHit(entity));
                }
                if (i <= 5) continue;
                break;
            }
            this.totalProcs += i;
            if (this.totalProcs >= this.maxProcs) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public int getExpirationTime() {
        return (int)(70.0 + this.extendedTime * 20.0);
    }

    @Override
    public int getParticleDelay() {
        return 0;
    }

    @Override
    public void playParticles() {
        BlockPos pos = this.getOnPos();
        int range = Math.round(this.getAoe());
        int chance = 5;
        int numParticles = 20;
        RandomSource rand = this.random;
        BlockPos.betweenClosedStream((BlockPos)pos.offset(range * this.getDirection().getStepX(), 0, range * this.getDirection().getStepZ()), (BlockPos)pos.offset(-range * this.getDirection().getStepX(), range, -range * this.getDirection().getStepZ())).forEach(blockPos -> {
            if (rand.nextInt(chance) == 0) {
                for (int i = 0; i < rand.nextInt(numParticles); ++i) {
                    double x = (double)blockPos.getX() + ParticleUtil.inRange(-this.growthFactor, this.growthFactor) + 0.5;
                    double y = (double)blockPos.getY() + ParticleUtil.inRange(-this.growthFactor, this.growthFactor);
                    double z = (double)blockPos.getZ() + ParticleUtil.inRange(-this.growthFactor, this.growthFactor) + 0.5;
                    this.level.addParticle(ParticleLineData.createData(this.getParticleColor()), x, y, z, x, y + ParticleUtil.inRange(0.5, 5.0), z);
                }
            }
        });
        ParticleUtil.spawnLight(this.level, this.getParticleColor(), this.position.add(0.0, 0.5, 0.0), 10);
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.WALL_SPELL.get();
    }

    @Override
    protected void onHit(HitResult result) {
        if (!this.level.isClientSide && result instanceof BlockHitResult && !this.isRemoved()) {
            BlockState state = this.level.getBlockState(((BlockHitResult)result).getBlockPos());
            if (state.is(BlockTags.PORTALS)) {
                state.entityInside(this.level, ((BlockHitResult)result).getBlockPos(), (Entity)this);
                return;
            }
            this.setLanded(true);
        }
    }

    public int getAccelerates() {
        return (Integer)this.entityData.get(ACCELERATES);
    }

    public void setAoe(float aoe) {
        this.entityData.set(AOE, (Object)Float.valueOf(aoe));
    }

    public float getAoe() {
        return 3.0f + ((Float)this.entityData.get(AOE)).floatValue();
    }

    public void setLanded(boolean landed) {
        this.entityData.set(LANDED, (Object)landed);
    }

    public boolean getLanded() {
        return (Boolean)this.entityData.get(LANDED);
    }

    public void setSensitive(boolean sensitive) {
        this.entityData.set(SENSITIVE, (Object)sensitive);
    }

    public boolean isSensitive() {
        return (Boolean)this.entityData.get(SENSITIVE);
    }

    public void setDirection(Direction direction) {
        this.entityData.set(DIRECTION, (Object)direction);
    }

    public Direction getDirection() {
        return (Direction)this.entityData.get(DIRECTION);
    }

    public void setShouldFall(boolean shouldFall) {
        this.entityData.set(SHOULD_FALL, (Object)shouldFall);
    }

    public boolean shouldFall() {
        return (Boolean)this.entityData.get(SHOULD_FALL);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ACCELERATES, (Object)0);
        pBuilder.define(AOE, (Object)Float.valueOf(0.0f));
        pBuilder.define(LANDED, (Object)false);
        pBuilder.define(SENSITIVE, (Object)false);
        pBuilder.define(DIRECTION, (Object)Direction.NORTH);
        pBuilder.define(SHOULD_FALL, (Object)true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("sensitive", this.isSensitive());
        tag.putString("direction", this.getDirection().name());
        tag.putBoolean("should_fall", this.shouldFall());
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        this.setSensitive(compound.getBoolean("sensitive"));
        this.setDirection(Direction.valueOf((String)compound.getString("direction")));
        this.setShouldFall(compound.getBoolean("should_fall"));
    }

    public static class EntityHit {
        long gameTime;
        WeakReference<Entity> entity;

        public EntityHit(Entity entity) {
            this.entity = new WeakReference<Entity>(entity);
            this.gameTime = entity.level.getGameTime();
        }
    }
}

