/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.RandomStorageVisitGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.TransferGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.TransferTask;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityBookwyrm
extends FlyingMob
implements IDispellable,
ITooltipProvider,
IWandable,
GeoEntity,
ICharmSerializable {
    public static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.defineId(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(EntityBookwyrm.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public BlockPos lecternPos;
    public int backoffTicks;
    public boolean playerTooFar;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static String[] COLORS = new String[]{"purple", "green", "blue", "black", "red", "white"};
    public static final Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>();

    public EntityBookwyrm(EntityType<? extends FlyingMob> p_i48568_1_, Level p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    public EntityBookwyrm(Level p_i50190_2_) {
        this((EntityType<? extends FlyingMob>)((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get()), p_i50190_2_);
    }

    public EntityBookwyrm(Level world, BlockPos lecternPos) {
        this(world);
        this.lecternPos = lecternPos;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || player.getCommandSenderWorld().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(COLORS).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.setColor(color.getName());
            player.getMainHandItem().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.dead || this.lecternPos == null) {
            return;
        }
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level.isClientSide && this.backoffTicks >= 0) {
            --this.backoffTicks;
        }
        if (this.level.getGameTime() % 20L == 0L && !(this.level.getBlockEntity(this.lecternPos) instanceof StorageLecternTile) && !this.level.isClientSide) {
            this.hurt(this.level.damageSources().playerAttack((Player)ANFakePlayer.getPlayer((ServerLevel)this.level)), 99.0f);
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 100L == 0L) {
            this.playerTooFar = true;
            ServerLevel serverLevel = (ServerLevel)this.level;
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                if (!(BlockUtil.distanceFrom(serverPlayer.position(), this.position()) < 40.0)) continue;
                this.playerTooFar = false;
                break;
            }
        }
    }

    public boolean canCollideWith(Entity pEntity) {
        if (pEntity instanceof Player) {
            return false;
        }
        return super.canCollideWith(pEntity);
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    public boolean hurt(@NotNull DamageSource source, float p_70097_2_) {
        if (!SummonUtil.canSummonTakeDamage(source)) {
            return false;
        }
        return super.hurt(source, p_70097_2_);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, world);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TransferGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RandomStorageVisitGoal(this, () -> {
            StorageLecternTile tile = this.getTile();
            if (tile == null || this.playerTooFar) {
                return null;
            }
            ArrayList<BlockPos> targets = new ArrayList<BlockPos>(tile.connectedInventories);
            targets.add(tile.getBlockPos());
            return ((BlockPos)targets.get(this.level.random.nextInt(targets.size()))).above();
        }));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public TransferTask getTransferTask() {
        StorageLecternTile tile = this.getTile();
        if (tile != null) {
            return tile.getTransferTask();
        }
        return null;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.BOOKWYRM_CHARM.get());
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        StorageLecternTile tile = this.getTile();
        if (tile != null) {
            tile.removeBookwyrm(this);
        }
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.lecternPos != null) {
            tag.putLong("lectern", this.lecternPos.asLong());
        }
        if (!this.getHeldStack().isEmpty()) {
            Tag itemTag = this.getHeldStack().save((HolderLookup.Provider)this.registryAccess());
            tag.put("held", itemTag);
        }
        tag.putInt("backoff", this.backoffTicks);
        tag.putString("color", (String)this.entityData.get(COLOR));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("lectern")) {
            this.lecternPos = BlockPos.of((long)tag.getLong("lectern"));
        }
        this.setHeldStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("held")));
        this.backoffTicks = tag.getInt("backoff");
        if (tag.contains("color")) {
            this.entityData.set(COLOR, (Object)tag.getString("color"));
        }
    }

    @Nullable
    public StorageLecternTile getTile() {
        return this.lecternPos == null || !(this.level.getBlockEntity(this.lecternPos) instanceof StorageLecternTile) ? null : (StorageLecternTile)this.level.getBlockEntity(this.lecternPos);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "walkController", 1, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("fly"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    @NotNull
    public ItemStack getHeldStack() {
        return (ItemStack)this.entityData.get(HELD_ITEM);
    }

    public void setHeldStack(ItemStack stack) {
        this.entityData.set(HELD_ITEM, (Object)stack);
    }

    public void die(DamageSource source) {
        if (!this.level.isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.BOOKWYRM_CHARM.get());
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
        }
        super.die(source);
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.FLYING_SPEED, ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()).add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HELD_ITEM, (Object)ItemStack.EMPTY);
        pBuilder.define(COLOR, (Object)"blue");
    }

    public ResourceLocation getTexture() {
        String color = this.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "blue";
        }
        String finalColor = color;
        return TEXTURES.computeIfAbsent(color, key -> ArsNouveau.prefix("textures/entity/book_wyrm_" + finalColor + ".png"));
    }

    @Override
    public void fromCharmData(PersistentFamiliarData data) {
        this.setColor(data.color());
        this.setCustomName(data.name());
    }

    @Override
    public String getColor() {
        return (String)this.getEntityData().get(COLOR);
    }

    public void setColor(String color) {
        this.getEntityData().set(COLOR, (Object)color);
    }
}

