/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.hollingsworth.arsnouveau.common.entity.EnchantedSkull;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AnimHeadSummon
extends AnimBlockSummon {
    public CompoundTag head_data = new CompoundTag();

    public AnimHeadSummon(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AnimHeadSummon(Level pLevel, BlockState state, CompoundTag head_data) {
        this((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.ANIMATED_HEAD.get()), pLevel);
        this.blockState = state;
        this.head_data = head_data;
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ANIMATED_HEAD.get();
    }

    @Override
    public void returnToFallingBlock(BlockState blockState) {
        if (this.level.isClientSide || !this.dropItem || blockState == null) {
            return;
        }
        EnchantedSkull fallingBlock = new EnchantedSkull(this.level, this.blockPosition(), blockState);
        fallingBlock.setOwner((Entity)this.getOwner());
        fallingBlock.setDeltaMovement(this.getDeltaMovement());
        if (blockState.getBlock() == Blocks.PLAYER_HEAD) {
            fallingBlock.blockData = this.head_data;
        }
        this.level.addFreshEntity((Entity)fallingBlock);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("head_data", (Tag)this.head_data);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.head_data = pCompound.getCompound("head_data");
    }

    public ItemStack getStack() {
        Item item = this.getBlockState().getBlock().asItem();
        ItemStack stack = item.getDefaultInstance();
        if (item instanceof PlayerHeadItem) {
            // empty if block
        }
        return stack;
    }

    public static CompoundTag getHeadTagFromName(String playerName) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("SkullOwner", playerName);
        return compoundtag;
    }
}

