/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.debug.IDebugger;
import com.hollingsworth.arsnouveau.common.entity.debug.IDebuggerProvider;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalLookAtMob;
import com.hollingsworth.arsnouveau.common.entity.goal.LookAtTarget;
import com.hollingsworth.arsnouveau.common.entity.goal.UntamedFindItemGoal;
import com.hollingsworth.arsnouveau.common.entity.statemachine.SimpleStateMachine;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.DecideCrabActionState;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Alakarkinos
extends PathfinderMob
implements GeoEntity,
IDispellable,
ITooltipProvider,
IWandable,
IDebuggerProvider,
IAnimationListener,
ICharmSerializable {
    public boolean tamed;
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(Alakarkinos.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public static final EntityDataAccessor<Boolean> HAS_HAT = SynchedEntityData.defineId(Alakarkinos.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> BLOWING_BUBBLES = SynchedEntityData.defineId(Alakarkinos.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<BlockPos>> BLOWING_AT = SynchedEntityData.defineId(Alakarkinos.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public int findBlockCooldown;
    public boolean partyCrab = false;
    public BlockPos jukeboxPos = null;
    public BlockPos hatPos = null;
    public Vec3 lookAt = null;
    public static final EntityDataAccessor<Boolean> NEED_SOURCE = SynchedEntityData.defineId(Alakarkinos.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    boolean beingTamed = false;
    public SimpleStateMachine stateMachine = new SimpleStateMachine(new DecideCrabActionState(this));
    int ticksBlowingAnim;
    int tamedTicks;
    AnimationController placeHat;
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    boolean setBehaviors = false;

    public Alakarkinos(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reloadGoals();
    }

    public Alakarkinos(Level pLevel, BlockPos pos, boolean tamed) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.ALAKARKINOS_TYPE.get()), pLevel);
        this.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        this.tamed = tamed;
        this.reloadGoals();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean hasSound) {
        super.setRecordPlayingNearby(pos, hasSound);
        this.partyCrab = hasSound;
        this.jukeboxPos = pos;
    }

    public void tick() {
        super.tick();
        if (!this.tamed && !this.beingTamed && this.level.getGameTime() % 40L == 0L) {
            for (ItemEntity itementity : this.level.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0))) {
                this.pickUpItem(itementity);
            }
        }
        if (!this.tamed && this.getMainHandItem().is(ItemTags.DECORATED_POT_SHERDS)) {
            ++this.tamedTicks;
        }
        if (!(this.tamedTicks <= 60 || this.level.isClientSide || this.isRemoved() || this.isDeadOrDying())) {
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            ItemStack stack = new ItemStack(ItemsRegistry.ALAKARKINOS_SHARD);
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!this.level.isClientSide) {
            this.stateMachine.tick();
            SummonUtil.healOverTime((LivingEntity)this);
            if (this.findBlockCooldown > 0) {
                --this.findBlockCooldown;
            }
        } else if (this.blowingBubbles()) {
            ++this.ticksBlowingAnim;
            if (this.ticksBlowingAnim < 10) {
                return;
            }
            Optional optPos = (Optional)this.entityData.get(BLOWING_AT);
            if (optPos.isEmpty()) {
                return;
            }
            BlockPos to = (BlockPos)optPos.get();
            Vec3 towards = new Vec3((double)to.getX() + 0.5, (double)to.getY() + 0.5, (double)to.getZ() + 0.5);
            float randScale = 0.2f;
            Vec3 from = new Vec3(this.getX() + ParticleUtil.inRange(-randScale, randScale), this.getY() + 0.75 + ParticleUtil.inRange(-randScale, randScale), this.getZ() + ParticleUtil.inRange(-randScale, randScale));
            Vec3 dir = towards.subtract(from).normalize();
            Vec3 pos = from.add(dir.scale(0.5));
            Vec3 motion = dir.scale(0.2);
            this.level.addAlwaysVisibleParticle((ParticleOptions)ModParticles.BUBBLE_TYPE.get(), pos.x, pos.y, pos.z, motion.x, motion.y * 0.05, motion.z);
            if (this.getRandom().nextInt(20) == 0) {
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.NEUTRAL, 0.8f + this.getRandom().nextFloat() * 0.2f, 0.9f + this.getRandom().nextFloat() * 0.15f, false);
            }
        } else {
            this.ticksBlowingAnim = 0;
        }
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (!this.tamed && !this.beingTamed && itemEntity.getItem().is(ItemTags.DECORATED_POT_SHERDS)) {
            this.beingTamed = true;
            ItemStack stack = itemEntity.getItem().copy();
            stack.setCount(1);
            this.setItemInHand(InteractionHand.MAIN_HAND, stack);
            itemEntity.getItem().shrink(1);
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void die(DamageSource source) {
        if (!this.level.isClientSide && this.tamed) {
            ItemStack stack = new ItemStack(ItemsRegistry.ALAKARKINOS_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
        }
        super.die(source);
    }

    @Override
    public void fromCharmData(PersistentFamiliarData data) {
        this.setCustomName(data.name());
    }

    @Override
    public String getColor() {
        return "red";
    }

    protected void reloadGoals() {
        if (this.level.isClientSide()) {
            return;
        }
        this.goalSelector.availableGoals.clear();
        for (WrappedGoal goal : this.getGoals()) {
            this.goalSelector.addGoal(goal.getPriority(), goal.getGoal());
        }
    }

    public List<WrappedGoal> getGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        if (this.tamed) {
            list.add(new WrappedGoal(4, (Goal)new ConditionalLookAtMob((Mob)this, Player.class, 3.0f, 0.02f, () -> this.lookAt == null)));
            list.add(new WrappedGoal(4, (Goal)new ConditionalLookAtMob((Mob)this, Mob.class, 8.0f, () -> this.lookAt == null)));
            list.add(new WrappedGoal(4, (Goal)new LookAtTarget((Mob)this, 8.0f, () -> this.lookAt)));
        } else {
            list.add(new WrappedGoal(1, (Goal)new UntamedFindItemGoal((Mob)this, () -> this.getMainHandItem().isEmpty(), e -> e.getItem().is(ItemTags.DECORATED_POT_SHERDS))));
            list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 0.02f)));
            list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f)));
            list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        }
        return list;
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ALAKARKINOS_TYPE.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HOME, Optional.empty());
        pBuilder.define(HAS_HAT, (Object)true);
        pBuilder.define(BLOWING_BUBBLES, (Object)false);
        pBuilder.define(BLOWING_AT, Optional.empty());
        pBuilder.define(NEED_SOURCE, (Object)false);
    }

    public void setNeedSource(boolean needSource) {
        this.entityData.set(NEED_SOURCE, (Object)needSource);
    }

    public boolean needSource() {
        return (Boolean)this.entityData.get(NEED_SOURCE);
    }

    public boolean hasHat() {
        return (Boolean)this.entityData.get(HAS_HAT);
    }

    public void setHat(boolean hasHat) {
        this.entityData.set(HAS_HAT, (Object)hasHat);
    }

    public void setBlowingBubbles(boolean blowingBubbles) {
        this.entityData.set(BLOWING_BUBBLES, (Object)blowingBubbles);
    }

    public boolean blowingBubbles() {
        return (Boolean)this.entityData.get(BLOWING_BUBBLES);
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.tamed && this.needSource()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.wixie.need_mana"));
        }
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (playerEntity.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, null) != null) {
            this.entityData.set(HOME, Optional.ofNullable(storedPos));
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.alakarkinos.set_home"));
        }
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide && this.tamed) {
            ItemStack stack = new ItemStack(ItemsRegistry.ALAKARKINOS_CHARM);
            stack.set(DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    @Override
    public IDebugger getDebugger() {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkController", 1, event -> {
            if (this.blowingBubbles()) {
                return PlayState.STOP;
            }
            if (event.isMoving() || this.level.isClientSide && PatchouliHandler.isPatchouliWorld()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "idleController", 1, event -> {
            if (this.blowingBubbles()) {
                return PlayState.STOP;
            }
            if (!event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "danceController", 1, event -> {
            if (this.blowingBubbles()) {
                return PlayState.STOP;
            }
            if (this.getMainHandItem().is(ItemTags.DECORATED_POT_SHERDS) || this.partyCrab && this.jukeboxPos != null && BlockUtil.distanceFrom(this.position, this.jukeboxPos) <= 8.0) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("dance"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "blowBubbles", 1, event -> {
            if (this.blowingBubbles()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("bubble_blow"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        this.placeHat = new AnimationController((GeoAnimatable)this, "placeHatController", 1, event -> PlayState.CONTINUE);
        controllers.add(this.placeHat);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public boolean save(CompoundTag pCompound) {
        if (((Optional)this.entityData.get(HOME)).isPresent()) {
            pCompound.putLong("home", ((BlockPos)((Optional)this.entityData.get(HOME)).get()).asLong());
        }
        pCompound.putInt("findBlockCooldown", this.findBlockCooldown);
        if (this.hatPos != null) {
            pCompound.putLong("hatPos", this.hatPos.asLong());
        }
        pCompound.putBoolean("needSource", this.needSource());
        pCompound.putBoolean("tamed", this.tamed);
        pCompound.putBoolean("beingTamed", this.beingTamed);
        pCompound.putBoolean("hasHat", this.hasHat());
        return super.save(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("home")) {
            this.entityData.set(HOME, Optional.of(BlockPos.of((long)pCompound.getLong("home"))));
        }
        this.findBlockCooldown = pCompound.getInt("findBlockCooldown");
        if (pCompound.contains("hatPos")) {
            this.hatPos = BlockPos.of((long)pCompound.getLong("hatPos"));
        }
        this.tamed = pCompound.getBoolean("tamed");
        this.setNeedSource(pCompound.getBoolean("needSource"));
        this.beingTamed = pCompound.getBoolean("beingTamed");
        if (!this.setBehaviors) {
            this.goalSelector.availableGoals = new LinkedHashSet();
            this.reloadGoals();
            this.setBehaviors = true;
        }
        if (pCompound.contains("hasHat")) {
            this.setHat(pCompound.getBoolean("hasHat"));
        }
    }

    @Override
    public void startAnimation(int arg) {
        if (arg == Animations.PLACE_HAT.ordinal()) {
            if (this.placeHat == null) {
                return;
            }
            this.placeHat.forceAnimationReset();
            this.placeHat.setAnimation(RawAnimation.begin().thenPlay("place_hat"));
        } else if (arg == Animations.BUBBLE_BLOW.ordinal()) {
            if (this.placeHat == null) {
                return;
            }
            this.placeHat.forceAnimationReset();
            this.placeHat.setAnimation(RawAnimation.begin().thenPlay("bubble_blow"));
        } else if (arg == Animations.PICKUP_HAT.ordinal()) {
            if (this.placeHat == null) {
                return;
            }
            this.placeHat.forceAnimationReset();
            this.placeHat.setAnimation(RawAnimation.begin().thenPlay("pickup_hat"));
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    public static enum Animations {
        PLACE_HAT,
        BUBBLE_BLOW,
        PICKUP_HAT;

    }
}

