/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;

public class VolcanicSourcelinkTile
extends SourcelinkTile
implements GeoAnimatable {
    public VolcanicSourcelinkTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.VOLCANIC_TILE.get(), pos, state);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L && this.canAcceptSource()) {
            for (ItemEntity itemEntity : this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).inflate(1.0))) {
                int source = this.getSourceValue(itemEntity.getItem());
                if (source <= 0 || !this.canConsumeEntireItem(itemEntity.getItem()) && this.getSource() > 0) continue;
                this.addSource(source);
                ItemStack containerItem = itemEntity.getItem().getCraftingRemainingItem();
                itemEntity.getItem().shrink(1);
                if (!containerItem.isEmpty()) {
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), containerItem));
                }
                Networking.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, itemEntity.blockPosition(), new ParticleColor(255, 0, 0), new int[0]));
                return;
            }
            for (ArcanePedestalTile arcanePedestalTile : this.getSurroundingPedestals()) {
                int sourceValue = this.getSourceValue(arcanePedestalTile.getItem(0));
                if (sourceValue <= 0 || !this.canConsumeEntireItem(arcanePedestalTile.getItem(0)) && this.getSource() > 0) continue;
                this.addSource(sourceValue);
                ItemStack containerItem = arcanePedestalTile.getItem(0).getCraftingRemainingItem();
                arcanePedestalTile.removeItem(0, 1);
                arcanePedestalTile.setItem(0, containerItem);
                Networking.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new PacketANEffect(PacketANEffect.EffectType.BURST, arcanePedestalTile.getBlockPos().above(), new ParticleColor(255, 0, 0), new int[0]));
            }
        }
    }

    public boolean canConsumeEntireItem(ItemStack i) {
        int sourceValue = this.getSourceValue(i);
        return this.getSource() + sourceValue <= this.getMaxSource();
    }

    public int getSourceValue(ItemStack i) {
        int source = 0;
        int progress = 0;
        int burnTime = i.getBurnTime(RecipeType.SMELTING);
        if (burnTime > 0) {
            source = burnTime / 12;
            progress = 1;
        }
        if (i.getItem() == BlockRegistry.BLAZING_LOG.asItem()) {
            source += 100;
            progress += 5;
        } else if (i.is(ItemTagProvider.ARCHWOOD_LOG_TAG)) {
            source += 50;
            progress += 3;
        }
        if (i.getItem() == ItemsRegistry.FIRE_ESSENCE.get()) {
            source = 2000;
        }
        this.progress += progress;
        this.setChanged();
        return source;
    }

    @Override
    public void doRandomAction() {
        if (this.level.isClientSide) {
            return;
        }
        AtomicBoolean set = new AtomicBoolean(false);
        BlockPos magmaPos = this.getBlockInArea(Blocks.MAGMA_BLOCK, 1);
        if (magmaPos != null && this.progress >= 200) {
            this.level.setBlockAndUpdate(magmaPos, Blocks.LAVA.defaultBlockState());
            this.progress -= 200;
            return;
        }
        BlockPos stonePos = this.getBlockInArea(Blocks.STONE, 1);
        if (stonePos != null && this.progress >= 150) {
            this.level.setBlockAndUpdate(stonePos, Blocks.MAGMA_BLOCK.defaultBlockState());
            this.progress -= 150;
            return;
        }
        stonePos = this.getTagInArea((TagKey<Block>)Tags.Blocks.STONES, 1);
        if (stonePos != null && this.progress >= 150) {
            this.level.setBlockAndUpdate(stonePos, Blocks.MAGMA_BLOCK.defaultBlockState());
            this.progress -= 150;
        }
    }

    public BlockPos getTagInArea(TagKey<Block> block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(range, -1, range), (BlockPos)this.worldPosition.offset(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.immutable();
            if (posFound.get() == null && this.level.getBlockState(blockPos).is(block)) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(range, -1, range), (BlockPos)this.worldPosition.offset(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.immutable();
            if (posFound.get() == null && this.level.getBlockState(blockPos).getBlock() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    @Override
    public int getMaxSource() {
        return 5000;
    }
}

