/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.google.common.collect.EvictingQueue;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.MultiExtractedReference;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.item.inv.StorageItemHandler;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.CraftingLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.LecternInvWrapper;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.goal.bookwyrm.TransferTask;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class StorageLecternTile
extends ModdedTile
implements MenuProvider,
ITickable,
IWandable,
ITooltipProvider,
ICapabilityProvider<CraftingLecternTile, Direction, IItemHandler> {
    public Map<String, InventoryManager> tabManagerMap = new HashMap<String, InventoryManager>();
    public Map<String, Map<StoredItemStack, Long>> itemsByTab = new HashMap<String, Map<StoredItemStack, Long>>();
    public Map<Item, Long> itemCounts = new HashMap<Item, Long>();
    public String lastSearch = "";
    public boolean updateItems;
    public List<BlockPos> connectedInventories = new ArrayList<BlockPos>();
    public List<String> tabNames = new ArrayList<String>();
    public List<HandlerPos> handlerPosList = new ArrayList<HandlerPos>();
    public SortSettings sortSettings = new SortSettings();
    public BlockPos mainLecternPos;
    public List<UUID> bookwyrmUUIDs = new ArrayList<UUID>();
    public int backoffTicks;
    public int checkPlayerRangeTicks;
    public boolean canCreateTasks = false;
    public static final String TAB_ALL = "8f6fe318-4ca6-4b29-ab63-15ec5289f5c9";
    public Queue<TransferTask> transferTasks = EvictingQueue.create((int)10);
    IItemHandler lecternInvWrapper;

    public StorageLecternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), pos, state);
    }

    public StorageLecternTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public InventoryManager getInvManager(@Nullable String tab) {
        if (tab == null || tab.isEmpty()) {
            return this.tabManagerMap.getOrDefault(TAB_ALL, new InventoryManager());
        }
        return this.tabManagerMap.getOrDefault(tab, this.tabManagerMap.getOrDefault(TAB_ALL, new InventoryManager()));
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public AbstractContainerMenu createMenu(int id, Inventory plInv, Player arg2) {
        return new StorageTerminalMenu(id, plInv, this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"ars_nouveau.storage_lectern");
    }

    public Map<StoredItemStack, Long> getStacks(@Nullable String tabName) {
        this.updateItems = true;
        if (tabName == null || tabName.isEmpty()) {
            return this.itemsByTab.getOrDefault(TAB_ALL, new HashMap());
        }
        return this.itemsByTab.getOrDefault(tabName, this.itemsByTab.getOrDefault(TAB_ALL, new HashMap()));
    }

    public List<String> getTabNames() {
        this.tabNames = new ArrayList<String>();
        for (BlockPos pos : this.connectedInventories) {
            String tabName;
            Nameable provider;
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (!(tile instanceof Nameable) || !(provider = (Nameable)tile).hasCustomName() || (tabName = provider.getCustomName().getString().trim()).isEmpty()) continue;
            this.tabNames.add(provider.getDisplayName().getString());
        }
        return this.tabNames;
    }

    public StoredItemStack pullStack(StoredItemStack stack, int max, @Nullable String tabName) {
        if (stack == null || max <= 0) {
            return null;
        }
        ItemStack st = stack.getStack();
        MultiExtractedReference pulled = this.getInvManager(tabName).extractItemFromAll(st, max, true);
        if (pulled.getExtracted().isEmpty()) {
            return null;
        }
        this.addExtractTasks(pulled);
        return new StoredItemStack(pulled.getExtracted());
    }

    private void addExtractTasks(MultiExtractedReference multiSlotReference) {
        if (multiSlotReference.getExtracted().isEmpty()) {
            return;
        }
        for (ExtractedStack extractedStack : multiSlotReference.getSlots()) {
            BlockPos pos = this.handlerPosList.stream().filter(handlerPos -> handlerPos.handler().equals((Object)extractedStack.getHandler())).findFirst().map(HandlerPos::pos).orElse(null);
            if (pos == null) continue;
            this.addTransferTask(new TransferTask(pos.above(), this.getBlockPos().above(), extractedStack.stack, this.level.getGameTime()));
        }
    }

    private void addInsertTasks(ItemStack stack, MultiInsertReference reference) {
        if (reference.isEmpty() || stack.isEmpty()) {
            return;
        }
        for (SlotReference extractedStack : reference.getSlots()) {
            BlockPos pos = this.handlerPosList.stream().filter(handlerPos -> handlerPos.handler().equals((Object)extractedStack.getHandler())).findFirst().map(HandlerPos::pos).orElse(null);
            if (pos == null) continue;
            this.addTransferTask(new TransferTask(this.getBlockPos().above(), pos.above(), stack, this.level.getGameTime()));
        }
    }

    public void addTransferTask(TransferTask task) {
        if (!this.canCreateTasks) {
            return;
        }
        this.transferTasks.add(task);
    }

    @Nullable
    public TransferTask getTransferTask() {
        ArrayList<TransferTask> staleTasks = new ArrayList<TransferTask>();
        TransferTask task = null;
        Iterator iterator = this.transferTasks.iterator();
        if (iterator.hasNext()) {
            TransferTask transferTask = (TransferTask)iterator.next();
            if (this.level.getGameTime() - transferTask.gameTime > 200L) {
                staleTasks.add(transferTask);
            }
            task = transferTask;
            staleTasks.add(transferTask);
        }
        this.transferTasks.removeAll(staleTasks);
        return task;
    }

    public StoredItemStack pushStack(StoredItemStack stack, @Nullable String tab) {
        if (stack == null) {
            return null;
        }
        ItemStack copyStack = stack.getActualStack().copy();
        MultiInsertReference reference = this.getInvManager(tab).insertStackWithReference(stack.getActualStack());
        ItemStack remaining = reference.getRemainder();
        if (!reference.isEmpty()) {
            this.addInsertTasks(copyStack, reference);
        }
        if (remaining.isEmpty()) {
            return null;
        }
        return new StoredItemStack(remaining);
    }

    public ItemStack pushStack(ItemStack itemstack, @Nullable String tab) {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return itemstack;
        }
        StoredItemStack is = mainLectern.pushStack(new StoredItemStack(itemstack), tab);
        return is == null ? ItemStack.EMPTY : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st, @Nullable String tabName) {
        if (st.isEmpty()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st), tabName);
        if (st0 != null) {
            Containers.dropItemStack((Level)this.level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (ItemStack)st0.getActualStack());
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.mainLecternPos = null;
        this.updateBlock();
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level == null) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(storedPos);
        if (tile instanceof StorageLecternTile) {
            StorageLecternTile newMasterLectern = (StorageLecternTile)tile;
            return;
        }
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, (Object)side);
        if (handler == null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.no_tile"));
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) > 30.0) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.inv_too_far"));
            return;
        }
        if (this.getBlockPos().equals((Object)storedPos)) {
            return;
        }
        if (this.connectedInventories.contains(storedPos)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.removed"));
            this.connectedInventories.remove(storedPos);
        } else {
            if (this.connectedInventories.size() >= this.getMaxConnectedInventories()) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.too_many"));
                return;
            }
            this.connectedInventories.add(storedPos.immutable());
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.from_set"));
        }
        this.mainLecternPos = null;
        this.updateBlock();
        this.updateItems = true;
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || storedPos.equals((Object)this.worldPosition) || this.level == null) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.worldPosition) > 30.0) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.lectern_too_far"));
            return;
        }
        this.mainLecternPos = storedPos.immutable();
        this.connectedInventories = new ArrayList<BlockPos>();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.storage.lectern_chained", (Object[])new Object[]{storedPos.getX(), storedPos.getY(), storedPos.getZ()}));
        this.updateBlock();
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.mainLecternPos != null) {
            list.add(ColorPos.centered(this.mainLecternPos, ParticleColor.TO_HIGHLIGHT));
            return list;
        }
        for (BlockPos pos : this.connectedInventories) {
            list.add(ColorPos.centered(pos, ParticleColor.FROM_HIGHLIGHT));
        }
        for (EntityBookwyrm bookwyrm : this.getBookwyrmEntities()) {
            list.add(ColorPos.centered(bookwyrm.blockPosition(), ParticleColor.GREEN));
        }
        return list;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.backoffTicks > 0) {
            --this.backoffTicks;
        }
        if (this.backoffTicks <= 0 && this.level.getGameTime() % 20L == 0L) {
            this.insertNearbyItems();
        }
        if (this.checkPlayerRangeTicks > 0) {
            --this.checkPlayerRangeTicks;
        }
        if (this.checkPlayerRangeTicks <= 0) {
            this.checkPlayerRangeTicks = 60 + this.level.random.nextInt(5);
            this.canCreateTasks = false;
            ServerLevel serverLevel = (ServerLevel)this.level;
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                if (!(BlockUtil.distanceFrom(serverPlayer.position(), this.getBlockPos()) < 40.0)) continue;
                this.canCreateTasks = true;
                break;
            }
        }
        if (this.updateItems) {
            this.updateItems();
            this.updateItems = false;
        }
    }

    public void updateItems() {
        this.itemsByTab.clear();
        this.tabManagerMap.clear();
        this.handlerPosList = new ArrayList<HandlerPos>();
        HashMap<String, List> mappedFilterables = new HashMap<String, List>();
        this.itemsByTab.put(TAB_ALL, new HashMap());
        for (BlockPos pos : this.connectedInventories) {
            Nameable nameable;
            IItemHandler handler;
            BlockEntity invTile = this.level.getBlockEntity(pos);
            if (invTile == null || (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) == null) continue;
            StorageItemHandler storageItemHandler = new StorageItemHandler(handler, InvUtil.filtersOnTile(invTile));
            mappedFilterables.computeIfAbsent(TAB_ALL, s -> new ArrayList()).add(storageItemHandler);
            this.handlerPosList.add(new HandlerPos(pos, handler));
            if (!(invTile instanceof Nameable) || !(nameable = (Nameable)invTile).hasCustomName()) continue;
            String tabName = nameable.getCustomName().getString();
            mappedFilterables.computeIfAbsent(tabName, s -> new ArrayList()).add(storageItemHandler);
        }
        for (String tabName : mappedFilterables.keySet()) {
            this.itemsByTab.put(tabName, new HashMap());
            for (FilterableItemHandler filterableItemHandler : (List)mappedFilterables.get(tabName)) {
                IItemHandler handler = filterableItemHandler.getHandler();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    StoredItemStack storedItemStack = new StoredItemStack(stack);
                    this.itemsByTab.get(tabName).merge(storedItemStack, storedItemStack.getQuantity(), Long::sum);
                }
            }
            this.tabManagerMap.put(tabName, new InventoryManager((List)mappedFilterables.get(tabName)));
        }
        this.itemCounts = new HashMap<Item, Long>();
        Map<StoredItemStack, Long> allItems = this.itemsByTab.get(TAB_ALL);
        for (StoredItemStack stack : allItems.keySet()) {
            this.itemCounts.put(stack.getStack().getItem(), allItems.get(stack));
        }
    }

    public List<EntityBookwyrm> getBookwyrmEntities() {
        ArrayList<EntityBookwyrm> bookwyrmEntities = new ArrayList<EntityBookwyrm>();
        ArrayList<UUID> staleUUIDs = new ArrayList<UUID>();
        for (UUID uuid : this.bookwyrmUUIDs) {
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(uuid);
            if (entity instanceof EntityBookwyrm) {
                EntityBookwyrm bookwyrm = (EntityBookwyrm)entity;
                bookwyrmEntities.add(bookwyrm);
                continue;
            }
            staleUUIDs.add(uuid);
        }
        this.bookwyrmUUIDs.removeAll(staleUUIDs);
        return bookwyrmEntities;
    }

    public void insertNearbyItems() {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            IItemHandler handler;
            BlockEntity tile;
            BlockPos pos = this.worldPosition.relative(dir);
            if (this.level.getBlockState(pos).is(BlockTagProvider.AUTOPULL_DISABLED) || (tile = this.level.getBlockEntity(pos)) == null || mainLectern.connectedInventories.contains(pos) || (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) == null) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack remainder;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack extractedStack = handler.extractItem(i, stack.getMaxStackSize(), false);
                ItemStack remaining = mainLectern.pushStack(extractedStack, null);
                if (!remaining.isEmpty() && !(remainder = handler.insertItem(i, remaining, false)).isEmpty()) {
                    Containers.dropItemStack((Level)this.level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (ItemStack)remainder);
                }
                return;
            }
        }
        this.backoffTicks = 100 + this.level.random.nextInt(20);
    }

    public void removeBookwyrm(EntityBookwyrm bookwyrm) {
        this.bookwyrmUUIDs.remove(bookwyrm.getUUID());
        this.updateBlock();
    }

    public boolean canInteractWith(Player player) {
        return !this.isRemoved();
    }

    public boolean openMenu(Player player) {
        StorageLecternTile mainLectern = this.getMainLectern();
        if (mainLectern == null) {
            return false;
        }
        player.openMenu((MenuProvider)mainLectern);
        return true;
    }

    @Nullable
    public StorageLecternTile getMainLectern() {
        return this.getMainLectern(new ArrayList<BlockPos>());
    }

    @Nullable
    public StorageLecternTile getMainLectern(List<BlockPos> visitedPos) {
        BlockEntity blockEntity;
        if (this.mainLecternPos == null) {
            return this;
        }
        if (visitedPos.contains(this.mainLecternPos)) {
            return null;
        }
        visitedPos.add(this.mainLecternPos);
        if (this.level.isLoaded(this.mainLecternPos) && (blockEntity = this.level.getBlockEntity(this.mainLecternPos)) instanceof StorageLecternTile) {
            StorageLecternTile storageTerminalBlockEntity = (StorageLecternTile)blockEntity;
            return storageTerminalBlockEntity.getMainLectern(visitedPos);
        }
        return null;
    }

    public void setSorting(SortSettings sortSettings) {
        this.sortSettings = sortSettings;
        this.updateBlock();
    }

    public int getMaxConnectedInventories() {
        return this.getBookwyrmEntities().size() * (Integer)Config.BOOKWYRM_LIMIT.get();
    }

    @Nullable
    public EntityBookwyrm addBookwyrm() {
        if (this.level.isClientSide) {
            return null;
        }
        EntityBookwyrm bookwyrm = new EntityBookwyrm(this.level, this.getBlockPos());
        bookwyrm.setPos((double)this.getBlockPos().getX() + 0.5, this.getBlockPos().getY() + 1, (double)this.getBlockPos().getZ() + 0.5);
        this.level.addFreshEntity((Entity)bookwyrm);
        this.bookwyrmUUIDs.add(bookwyrm.getUUID());
        this.updateBlock();
        return bookwyrm;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        compound.put("settings", ANCodecs.encode(SortSettings.CODEC, this.sortSettings));
        ListTag list = new ListTag();
        for (BlockPos pos : this.connectedInventories) {
            CompoundTag c = new CompoundTag();
            c.putInt("x", pos.getX());
            c.putInt("y", pos.getY());
            c.putInt("z", pos.getZ());
            list.add((Object)c);
        }
        compound.put("invs", (Tag)list);
        if (this.mainLecternPos != null) {
            compound.putLong("mainLecternPos", this.mainLecternPos.asLong());
        }
        ListTag bookwyrmList = new ListTag();
        for (UUID uuid : this.bookwyrmUUIDs) {
            bookwyrmList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        compound.put("bookwyrmUUIDs", (Tag)bookwyrmList);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        if (compound.contains("settings")) {
            this.sortSettings = ANCodecs.decode(SortSettings.CODEC, (Tag)compound.getCompound("settings"));
        }
        ListTag list = compound.getList("invs", 10);
        this.connectedInventories.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag c = list.getCompound(i);
            this.connectedInventories.add(new BlockPos(c.getInt("x"), c.getInt("y"), c.getInt("z")));
        }
        if (compound.contains("mainLecternPos")) {
            this.mainLecternPos = BlockPos.of((long)compound.getLong("mainLecternPos"));
        }
        if (compound.contains("bookwyrmUUIDs")) {
            this.bookwyrmUUIDs.clear();
            ListTag bookwyrmList = compound.getList("bookwyrmUUIDs", 11);
            for (Tag tag : bookwyrmList) {
                this.bookwyrmUUIDs.add(NbtUtils.loadUUID((Tag)tag));
            }
        }
        this.updateItems = true;
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.mainLecternPos != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.lectern_chained", (Object[])new Object[]{this.mainLecternPos.getX(), this.mainLecternPos.getY(), this.mainLecternPos.getZ()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.num_connected", (Object[])new Object[]{this.connectedInventories.size()}));
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.storage.num_bookwyrms", (Object[])new Object[]{this.bookwyrmUUIDs.size()}));
        }
    }

    @Nullable
    public IItemHandler getCapability(CraftingLecternTile object, Direction context) {
        StorageLecternTile lecternTile = object.getMainLectern();
        if (lecternTile == null) {
            this.lecternInvWrapper = new LecternInvWrapper(this, new IItemHandler[0]);
            return this.lecternInvWrapper;
        }
        ArrayList<IItemHandler> modifiables = new ArrayList<IItemHandler>();
        for (BlockPos pos : lecternTile.connectedInventories) {
            IItemHandler lih;
            BlockEntity invTile;
            if (pos.equals((Object)this.getBlockPos()) || (invTile = lecternTile.level.getBlockEntity(pos)) == null || (lih = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) == null) continue;
            modifiables.add(lih);
        }
        lecternTile.lecternInvWrapper = new LecternInvWrapper(this, modifiables.toArray(new IItemHandler[0]));
        return lecternTile.lecternInvWrapper;
    }

    public record HandlerPos(BlockPos pos, IItemHandler handler) {
    }
}

