/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.RotatingSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RotatingTurretTile
extends BasicSpellTurretTile
implements IWandable {
    public float rotationX;
    public float rotationY;
    public float neededRotationX;
    public float neededRotationY;
    public float clientNeededX;
    public float clientNeededY;

    public RotatingTurretTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public RotatingTurretTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.ROTATING_TURRET_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        float diff;
        super.tick();
        if (this.level.isClientSide) {
            float diff2;
            if (this.clientNeededX != this.neededRotationX) {
                diff2 = this.neededRotationX - this.clientNeededX;
                this.clientNeededX = (double)Math.abs(diff2) < 0.1 ? this.neededRotationX : (this.clientNeededX += diff2 * 0.1f);
            }
            if (this.clientNeededY != this.neededRotationY) {
                diff2 = this.neededRotationY - this.clientNeededY;
                this.clientNeededY = (double)Math.abs(diff2) < 0.1 ? this.neededRotationY : (this.clientNeededY += diff2 * 0.1f);
            }
            if (this.rotationX != this.clientNeededX) {
                diff2 = this.clientNeededX - this.rotationX;
                this.rotationX = (double)Math.abs(diff2) < 0.1 ? this.clientNeededX : (this.rotationX += diff2 * 0.1f);
            }
            if (this.rotationY != this.clientNeededY) {
                diff2 = this.clientNeededY - this.rotationY;
                this.rotationY = (double)Math.abs(diff2) < 0.1 ? this.clientNeededY : (this.rotationY += diff2 * 0.1f);
            }
            return;
        }
        if (this.rotationX != this.neededRotationX) {
            diff = this.neededRotationX - this.rotationX;
            if ((double)Math.abs(diff) < 0.1) {
                this.setRotationX(this.neededRotationX);
            } else {
                this.setRotationX(this.rotationX + diff * 0.1f);
            }
            this.setChanged();
        }
        if (this.rotationY != this.neededRotationY) {
            diff = this.neededRotationY - this.rotationY;
            if ((double)Math.abs(diff) < 0.1) {
                this.setRotationY(this.neededRotationY);
            } else {
                this.setRotationY(this.rotationY + diff * 0.1f);
            }
            this.setChanged();
        }
    }

    public void aim(@Nullable BlockPos blockPos, Player playerEntity) {
        if (blockPos == null) {
            return;
        }
        Vec3 thisVec = Vec3.atCenterOf((Vec3i)this.getBlockPos());
        Vec3 blockVec = Vec3.atCenterOf((Vec3i)blockPos);
        Vec3 diffVec = blockVec.subtract(thisVec);
        Vec3 diffVec2D = new Vec3(diffVec.x, diffVec.z, 0.0);
        Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
        float angle = (float)(RotatingTurretTile.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0);
        if (blockVec.x < thisVec.x) {
            angle = -angle;
        }
        this.neededRotationX = angle + 90.0f;
        rotVec = new Vec3(diffVec.x, 0.0, diffVec.z);
        angle = (float)(RotatingTurretTile.angleBetween(diffVec, rotVec) * 180.0 / 3.1415927410125732);
        if (blockVec.y < thisVec.y) {
            angle = -angle;
        }
        this.neededRotationY = angle;
        this.updateBlock();
        ParticleUtil.beam(blockPos, this.getBlockPos(), this.level);
        PortUtil.sendMessageNoSpam((Entity)playerEntity, (Component)Component.literal((String)("Turret now aims to " + blockPos.toShortString())));
    }

    public static double angleBetween(Vec3 a, Vec3 b) {
        double projection = a.normalize().dot(b.normalize());
        return Math.acos(Mth.clamp((double)projection, (double)-1.0, (double)1.0));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.aim(storedPos, playerEntity);
        }
    }

    @Override
    public void shootSpell() {
        Level level;
        BlockPos pos = this.getBlockPos();
        if (this.spellCaster.getSpell().isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int manaCost = this.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceWithParticles(pos, (Level)level2, 10, manaCost) == null) {
            return;
        }
        Networking.sendToNearbyClient((Level)level2, pos, (CustomPacketPayload)new PacketOneShotAnimation(pos));
        Position iposition = RotatingSpellTurret.getDispensePosition(pos, this);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer(level2);
        fakePlayer.setPos(pos.getX(), pos.getY(), pos.getZ());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext((Level)level2, this.spellCaster.getSpell(), (LivingEntity)fakePlayer, new TileCaster(this, SpellContext.CasterType.TURRET)));
        if (resolver.castType != null && RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.get(resolver.castType).onCast(resolver, level2, pos, (Player)fakePlayer, iposition, this.orderedByNearest()[0].getOpposite());
            this.spellCaster.playSound(pos, (Level)level2, null, this.spellCaster.getCurrentSound(), SoundSource.BLOCKS);
        }
    }

    public Direction[] orderedByNearest() {
        Direction direction2;
        float f = this.getRotationY() * (float)Math.PI / 180.0f;
        float f1 = (90.0f + this.getRotationX()) * (float)Math.PI / 180.0f;
        float f2 = Mth.sin((float)f);
        float f3 = Mth.cos((float)f);
        float f4 = Mth.sin((float)f1);
        float f5 = Mth.cos((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? Direction.EAST : Direction.WEST;
        Direction direction1 = flag1 ? Direction.UP : Direction.DOWN;
        Direction direction3 = direction2 = flag2 ? Direction.SOUTH : Direction.NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return RotatingTurretTile.makeDirectionArray(direction1, direction, direction2);
            }
            return f10 > f7 ? RotatingTurretTile.makeDirectionArray(direction, direction2, direction1) : RotatingTurretTile.makeDirectionArray(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return RotatingTurretTile.makeDirectionArray(direction1, direction2, direction);
        }
        return f9 > f7 ? RotatingTurretTile.makeDirectionArray(direction2, direction, direction1) : RotatingTurretTile.makeDirectionArray(direction2, direction1, direction);
    }

    static Direction[] makeDirectionArray(Direction pFirst, Direction pSecond, Direction pThird) {
        return new Direction[]{pFirst, pSecond, pThird, pThird.getOpposite(), pSecond.getOpposite(), pFirst.getOpposite()};
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putFloat("rotationY", this.rotationY);
        tag.putFloat("rotationX", this.rotationX);
        tag.putFloat("neededRotationY", this.neededRotationY);
        tag.putFloat("neededRotationX", this.neededRotationX);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.rotationX = tag.getFloat("rotationX");
        this.rotationY = tag.getFloat("rotationY");
        this.neededRotationX = tag.getFloat("neededRotationX");
        this.neededRotationY = tag.getFloat("neededRotationY");
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public void setRotationX(float rot) {
        this.rotationX = rot;
    }

    public void setRotationY(float rot) {
        this.rotationY = rot;
    }

    public Vec3 getShootAngle() {
        float f = this.getRotationY() * ((float)Math.PI / 180);
        float f1 = (90.0f + this.getRotationX()) * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4)).reverse();
    }
}

