/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class PotionDiffuserTile
extends ModdedTile
implements ITickable,
IWandable,
ITooltipProvider {
    public PotionContents lastConsumedPotion = PotionContents.EMPTY;
    public int ticksToConsume;
    public BlockPos boundPos;
    public boolean isOff;

    public PotionDiffuserTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.POTION_DIFFUSER_TILE, pos, state);
    }

    @Override
    public void tick() {
        if (this.isOff) {
            return;
        }
        if (this.level.isClientSide && !this.isOff && this.ticksToConsume > 0 && !PotionUtil.isEmpty(this.lastConsumedPotion) && this.level.getGameTime() % 8L == 0L) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + 0.5, this.getY() + 1.0, this.getZ() + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        if (this.ticksToConsume <= 0 && this.boundPos != null && this.level.getGameTime() % 60L == 0L) {
            this.obtainPotion();
        }
        if (this.ticksToConsume > 0) {
            --this.ticksToConsume;
            if (this.level.getGameTime() % 300L == 0L) {
                for (LivingEntity entity : this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos()).inflate(10.0))) {
                    this.lastConsumedPotion.forEachEffect(effectinstance -> {
                        if (((MobEffect)effectinstance.getEffect().value()).isInstantenous()) {
                            ((MobEffect)effectinstance.getEffect().value()).applyInstantenousEffect(null, null, entity, effectinstance.getAmplifier(), 1.0);
                        } else {
                            entity.addEffect(new MobEffectInstance(effectinstance), null);
                        }
                    });
                }
            }
        }
    }

    public void obtainPotion() {
        PotionJarTile jar;
        BlockEntity blockEntity;
        if (this.level.isLoaded(this.boundPos) && (blockEntity = this.level.getBlockEntity(this.boundPos)) instanceof PotionJarTile && !PotionUtil.isEmpty((jar = (PotionJarTile)blockEntity).getData()) && jar.getAmount() >= 100) {
            this.lastConsumedPotion = jar.getData();
            this.ticksToConsume = 12000;
            jar.remove(100);
            ParticleColor color2 = ParticleColor.fromInt(jar.getColor());
            EntityFlyingItem item2 = new EntityFlyingItem(this.level, jar.getBlockPos().above(), this.worldPosition, Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
            item2.setDistanceAdjust(2.0f);
            this.level.addFreshEntity((Entity)item2);
            this.updateBlock();
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity blockEntity;
        if (storedPos != null && (blockEntity = this.level.getBlockEntity(storedPos)) instanceof PotionJarTile) {
            PotionJarTile jar = (PotionJarTile)blockEntity;
            this.boundPos = storedPos.immutable();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.potion_diffuser.set_pos"));
            if (this.lastConsumedPotion != null && !PotionUtil.isEmpty(this.lastConsumedPotion) && !PotionUtil.arePotionContentsEqual(this.lastConsumedPotion, jar.getData())) {
                this.obtainPotion();
            }
            this.updateBlock();
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.potion_diffuser.bind_to_jar"));
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.boundPos = NBTUtil.getNullablePos(pTag, "boundPos");
        this.isOff = pTag.getBoolean("isOff");
        this.ticksToConsume = pTag.getInt("ticksToConsume");
        if (pTag.contains("lastConsumedPotion")) {
            this.lastConsumedPotion = (PotionContents)ANCodecs.decode(pRegistries, PotionContents.CODEC, (Tag)pTag.getCompound("lastConsumedPotion"));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.boundPos != null) {
            NBTUtil.storeBlockPos(tag, "boundPos", this.boundPos);
        }
        tag.putBoolean("isOff", this.isOff);
        tag.putInt("ticksToConsume", this.ticksToConsume);
        if (this.lastConsumedPotion != null) {
            tag.put("lastConsumedPotion", ANCodecs.encode(pRegistries, PotionContents.CODEC, this.lastConsumedPotion));
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.boundPos == null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.potion_diffuser.no_pos").withStyle(ChatFormatting.GOLD));
        }
        if (this.isOff) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.potion_diffuser.off").withStyle(ChatFormatting.GOLD));
        }
        if (this.lastConsumedPotion != null) {
            this.lastConsumedPotion.addPotionTooltip(tooltip::add, 1.0f, 20.0f);
        }
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> colorPos) {
        if (this.boundPos != null) {
            colorPos.add(ColorPos.centered(this.boundPos));
        }
        return colorPos;
    }
}

