/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.MirrorWeave;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MirrorWeaveTile
extends ModdedTile
implements GeoBlockEntity,
ILightable {
    public BlockState mimicState;
    public BlockState nextState = BlockRegistry.MIRROR_WEAVE.defaultBlockState();
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MirrorWeaveTile(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.mimicState = this.getDefaultBlockState();
    }

    public MirrorWeaveTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockRegistry.MIRROR_WEAVE_TILE.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("mimic_state", (Tag)NbtUtils.writeBlockState((BlockState)this.mimicState));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("mimic_state")) {
            HolderLookup.RegistryLookup holdergetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
            this.mimicState = NbtUtils.readBlockState((HolderGetter)holdergetter, (CompoundTag)pTag.getCompound("mimic_state"));
        } else {
            this.mimicState = this.getDefaultBlockState();
        }
    }

    public BlockState getDefaultBlockState() {
        return BlockRegistry.MIRROR_WEAVE.defaultBlockState();
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockState state = world.getBlockState(((BlockHitResult)rayTraceResult).getBlockPos());
            world.setBlock(this.getBlockPos(), (BlockState)state.setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - stats.getBuffCount(AugmentDampen.INSTANCE)), 15))), 3);
            world.sendBlockUpdated(((BlockHitResult)rayTraceResult).getBlockPos(), state, (BlockState)state.setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - stats.getBuffCount(AugmentDampen.INSTANCE)), 15))), 3);
        }
        this.updateBlock();
    }
}

