/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.util.FlatPortalAreaHelper;
import com.hollingsworth.arsnouveau.api.util.PortalFrameTester;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PortalBlock
extends TickableModBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)14.0);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty ALTERNATE = BooleanProperty.create((String)"alternate");

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public PortalBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK).noCollission().strength(-1.0f, 3600000.0f).noLootTable());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)ALTERNATE, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.getX() + (double)rand.nextFloat();
            double d1 = (double)pos.getY() + (double)rand.nextFloat();
            double d2 = (double)pos.getZ() + (double)rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.getBlockState(pos.west()).getBlock() != this && worldIn.getBlockState(pos.east()).getBlock() != this) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    public void setType(Level pLevel, BlockPos pPos, boolean alternate) {
        if ((Boolean)pLevel.getBlockState(pPos).getValue((Property)ALTERNATE) == alternate) {
            return;
        }
        pLevel.setBlockAndUpdate(pPos, (BlockState)pLevel.getBlockState(pPos).setValue((Property)ALTERNATE, (Comparable)Boolean.valueOf(alternate)));
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)pPos.offset(-1, -1, -1), (BlockPos)pPos.offset(1, 1, 1))) {
            Block block = pLevel.getBlockState(pos).getBlock();
            if (!(block instanceof PortalBlock)) continue;
            PortalBlock portalBlock = (PortalBlock)block;
            if ((Boolean)pLevel.getBlockState(pos).getValue((Property)ALTERNATE) == alternate) continue;
            this.setType(pLevel, pos, alternate);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.isClientSide || pHand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pPlayer.getItemInHand(pHand).getItem() instanceof DominionWand && pLevel.getBlockEntity(pPos) instanceof PortalTile) {
            boolean nextVal = (Boolean)pLevel.getBlockState(pPos).getValue((Property)ALTERNATE) == false;
            this.setType(pLevel, pPos, nextVal);
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockEntity blockEntity = worldIn.getBlockEntity(hit.getBlockPos());
        if (blockEntity instanceof PortalTile) {
            PortalTile tile = (PortalTile)blockEntity;
            tile.warp((Entity)projectile);
        }
    }

    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new PortalTile(p_153215_, p_153216_);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof PortalTile) {
            PortalTile tile = (PortalTile)blockEntity;
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                tile.entityQueue.add((Entity)player);
            } else {
                tile.warp(entityIn);
                entityIn.fallDistance = 0.0f;
            }
        }
    }

    public boolean trySpawnPortal(Level worldIn, BlockPos stackPos, WarpScrollData data, String displayName) {
        if (!((Boolean)ServerConfig.ENABLE_WARP_PORTALS.get()).booleanValue()) {
            return false;
        }
        return this.trySpawnVerticalPortal((LevelAccessor)worldIn, stackPos, data, displayName) || this.trySpawnHorizontalPortal(worldIn, stackPos, data, displayName);
    }

    public boolean trySpawnVerticalPortal(LevelAccessor worldIn, BlockPos stackPos, WarpScrollData data, String displayName) {
        Size portalblock$size = this.isPortal(worldIn, stackPos);
        if (portalblock$size != null) {
            portalblock$size.placePortalBlocks(data, displayName);
            return true;
        }
        return false;
    }

    public boolean trySpawnHorizontalPortal(Level worldIn, BlockPos stackPos, WarpScrollData data, String displayName) {
        PortalFrameTester helper = new FlatPortalAreaHelper().init(worldIn, stackPos, (Direction.Axis)null, bs -> bs.is(BlockTagProvider.DECORATIVE_AN));
        if (((FlatPortalAreaHelper)helper).isValidFrame()) {
            BlockPos.betweenClosed((BlockPos)((FlatPortalAreaHelper)helper).lowerCorner, (BlockPos)((FlatPortalAreaHelper)helper).lowerCorner.relative(Direction.Axis.X, ((FlatPortalAreaHelper)helper).xSize - 1).relative(Direction.Axis.Z, ((FlatPortalAreaHelper)helper).zSize - 1)).forEach(blockPos -> {
                worldIn.setBlock(blockPos, (BlockState)BlockRegistry.PORTAL_BLOCK.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y), 18);
                BlockEntity patt0$temp = worldIn.getBlockEntity(blockPos);
                if (patt0$temp instanceof PortalTile) {
                    PortalTile tile = (PortalTile)patt0$temp;
                    tile.warpPos = data.pos().orElse(null);
                    tile.dimID = data.dimension();
                    tile.rotationVec = data.rotation();
                    tile.displayName = displayName;
                    tile.isHorizontal = true;
                    tile.updateBlock();
                }
            });
            return true;
        }
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.getAxis();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.getValue(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.isHorizontal();
        BlockEntity blockEntity = worldIn.getBlockEntity(currentPos);
        if (blockEntity instanceof PortalTile) {
            PortalTile portal = (PortalTile)blockEntity;
            if (portal.isHorizontal) {
                FlatPortalAreaHelper frameTester = new FlatPortalAreaHelper();
                frameTester.init((Level)worldIn, currentPos, (Direction.Axis)null, bs -> bs.is(BlockTagProvider.DECORATIVE_AN));
                if (!frameTester.isValidFrame()) {
                    return Blocks.AIR.defaultBlockState();
                }
                return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
            }
        }
        return !flag && facingState.getBlock() != this && !new Size(worldIn, currentPos, direction$axis1).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS}).add(new Property[]{ALTERNATE});
    }

    @Nullable
    public Size isPortal(LevelAccessor worldIn, BlockPos pos) {
        Size portalblock$size = new Size(worldIn, pos, Direction.Axis.X);
        if (portalblock$size.isValid() && portalblock$size.portalBlockCount == 0) {
            return portalblock$size;
        }
        Size portalblock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        return portalblock$size1.isValid() && portalblock$size1.portalBlockCount == 0 ? portalblock$size1 : null;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private BlockPos warpPos;
        private int dimId;

        public Size(LevelAccessor worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.getY() > blockpos.getY() - 21 && pos.getY() > 0 && this.canReplace(worldIn.getBlockState(pos.below()))) {
                pos = pos.below();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.relative(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 1 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canReplace(this.world.getBlockState(blockpos = pos.relative(directionIn, i))) && this.isPortalFrame(this.world, blockpos.below()); ++i) {
            }
            BlockPos framePos = pos.relative(directionIn, i);
            return this.isPortalFrame(this.world, framePos) ? i : 0;
        }

        public boolean isPortalFrame(LevelAccessor world, BlockPos pos) {
            return world.getBlockState(pos).is(BlockTagProvider.DECORATIVE_AN);
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.relative(this.rightDir, i).above(this.height);
                    BlockState blockstate = this.world.getBlockState(blockpos);
                    if (!this.canReplace(blockstate)) break block0;
                    Block block = blockstate.getBlock();
                    if (block instanceof PortalBlock) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.isPortalFrame(this.world, framePos = blockpos.relative(this.leftDir)) : i == this.width - 1 && !this.isPortalFrame(this.world, framePos = blockpos.relative(this.rightDir))) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.relative(this.rightDir, j).above(this.height);
                if (this.isPortalFrame(this.world, framePos)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 1) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canReplace(BlockState pos) {
            Block block = pos.getBlock();
            return pos.isAir() || block == Blocks.FIRE || block instanceof PortalBlock;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 1 && this.height <= 21;
        }

        public void placePortalBlocks(WarpScrollData data, String displayName) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.relative(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.setBlock(blockpos.above(j), (BlockState)BlockRegistry.PORTAL_BLOCK.defaultBlockState().setValue(AXIS, (Comparable)this.axis), 18);
                    BlockEntity blockEntity = this.world.getBlockEntity(blockpos.above(j));
                    if (!(blockEntity instanceof PortalTile)) continue;
                    PortalTile tile = (PortalTile)blockEntity;
                    tile.setFromScroll(data);
                    tile.displayName = displayName;
                    tile.updateBlock();
                }
            }
        }

        private boolean rightSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean isComplete() {
            return this.isValid() && this.rightSize();
        }
    }
}

