/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.ArcaneCore;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnchantingApparatusBlock
extends TickableModBlock {
    public EnchantingApparatusBlock() {
        this(TickableModBlock.defaultProperties().noOcclusion());
    }

    public EnchantingApparatusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantingApparatusTile(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (world.isClientSide || handIn != InteractionHand.MAIN_HAND || !((blockEntity = world.getBlockEntity(pos)) instanceof EnchantingApparatusTile)) {
            return ItemInteractionResult.SUCCESS;
        }
        EnchantingApparatusTile tile = (EnchantingApparatusTile)blockEntity;
        if (tile.isCrafting) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!(world.getBlockState(pos.below()).getBlock() instanceof ArcaneCore)) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"alert.core"));
            return ItemInteractionResult.SUCCESS;
        }
        if (tile.getStack() == null || tile.getStack().isEmpty()) {
            IEnchantingRecipe recipe = tile.getRecipe(player.getMainHandItem(), player);
            if (recipe == null) {
                ArrayList<ColorPos> colorPos = new ArrayList<ColorPos>();
                for (BlockPos pedPos : tile.pedestalList()) {
                    BlockEntity blockEntity2 = world.getBlockEntity(pedPos);
                    if (!(blockEntity2 instanceof ArcanePedestalTile)) continue;
                    ArcanePedestalTile pedestalTile = (ArcanePedestalTile)blockEntity2;
                    colorPos.add(ColorPos.centeredAbove(pedPos));
                }
                Networking.sendToNearbyClient(world, tile.getBlockPos(), (CustomPacketPayload)new HighlightAreaPacket(colorPos, 60));
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.apparatus.norecipe"));
            } else if (recipe.consumesSource() && !SourceUtil.hasSourceNearby(tile.getBlockPos(), tile.getLevel(), 10, recipe.sourceCost())) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.apparatus.nomana"));
            } else if (tile.attemptCraft(player.getMainHandItem(), player)) {
                tile.setStack(player.getInventory().removeItem(player.getInventory().selected, 1));
            }
        } else {
            ItemEntity item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), tile.getStack());
            world.addFreshEntity((Entity)item);
            tile.setStack(ItemStack.EMPTY);
            if (tile.attemptCraft(player.getMainHandItem(), player)) {
                tile.setStack(player.getInventory().removeItem(player.getInventory().selected, 1));
            }
        }
        world.sendBlockUpdated(pos, state, state, 2);
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        EnchantingApparatusTile tile;
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof EnchantingApparatusTile && (tile = (EnchantingApparatusTile)blockEntity).getStack() != null) {
            worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), tile.getStack()));
        }
        return state;
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

