/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PortalTileRenderer<T extends PortalTile>
implements BlockEntityRenderer<T> {
    private static final Random RANDOM = new Random(31100L);

    public PortalTileRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(PortalTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (((Boolean)Config.ALTERNATE_PORTAL_RENDER.get()).booleanValue() || ((Boolean)tileEntityIn.getBlockState().getValue((Property)PortalBlock.ALTERNATE)).booleanValue()) {
            return;
        }
        double d0 = 5.0;
        int i = this.getPasses(d0);
        float f = this.getOffset();
        Matrix4f matrix4f = matrixStackIn.last().pose();
        this.renderCube(tileEntityIn, f, 0.1f, matrix4f, bufferIn.getBuffer(RenderType.endPortal()));
        for (int j = 1; j < i; ++j) {
            this.renderCube(tileEntityIn, f, 2.0f / (float)(35 - j), matrix4f, bufferIn.getBuffer(RenderType.endPortal()));
        }
    }

    private void renderCube(PortalTile tileEntityIn, float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, VertexConsumer p_228883_5_) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, f, f1, f2, Direction.SOUTH);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f, f1, f2, Direction.NORTH);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2, Direction.EAST);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, f, f1, f2, Direction.WEST);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f, f1, f2, Direction.DOWN);
        this.renderFace(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, p_228883_2_, p_228883_2_, 1.0f, 1.0f, 0.0f, 0.0f, f, f1, f2, Direction.UP);
    }

    private void renderFace(PortalTile tileEntityIn, Matrix4f matrix, VertexConsumer iBuilder, float p_228884_4_, float p_228884_5_, float p_228884_6_, float p_228884_7_, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float p_228884_12_, float p_228884_13_, float p_228884_14_, Direction direction) {
        Direction.Axis beAxis = (Direction.Axis)tileEntityIn.getBlockState().getValue(PortalBlock.AXIS);
        Direction.Axis directionAxis = direction.getAxis();
        if (!tileEntityIn.isHorizontal && beAxis == Direction.Axis.X && directionAxis == Direction.Axis.Z || beAxis == Direction.Axis.Z && directionAxis == Direction.Axis.X) {
            iBuilder.addVertex(matrix, p_228884_4_, p_228884_6_, p_228884_8_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_5_, p_228884_6_, p_228884_9_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_5_, p_228884_7_, p_228884_10_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_4_, p_228884_7_, p_228884_11_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
        } else if (tileEntityIn.isHorizontal && direction.getAxis() == Direction.Axis.Y) {
            iBuilder.addVertex(matrix, p_228884_4_, p_228884_6_, p_228884_8_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_5_, p_228884_6_, p_228884_9_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_5_, p_228884_7_, p_228884_10_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
            iBuilder.addVertex(matrix, p_228884_4_, p_228884_7_, p_228884_11_).setColor(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f);
        }
    }

    protected int getPasses(double p_191286_1_) {
        if (p_191286_1_ > 36864.0) {
            return 1;
        }
        if (p_191286_1_ > 25600.0) {
            return 3;
        }
        if (p_191286_1_ > 16384.0) {
            return 5;
        }
        if (p_191286_1_ > 9216.0) {
            return 7;
        }
        if (p_191286_1_ > 4096.0) {
            return 9;
        }
        if (p_191286_1_ > 1024.0) {
            return 11;
        }
        if (p_191286_1_ > 576.0) {
            return 13;
        }
        return p_191286_1_ > 256.0 ? 14 : 15;
    }

    protected float getOffset() {
        return 0.75f;
    }
}

