/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.registry.ShaderRegistry;
import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class BubbleRenderer
extends EntityRenderer<BubbleEntity> {
    public static ResourceLocation TEXTURE = ArsNouveau.prefix("textures/entity/bubble.png");
    public static ResourceLocation POP_1 = ArsNouveau.prefix("textures/entity/bubble_pop1.png");
    public static ResourceLocation POP_2 = ArsNouveau.prefix("textures/entity/bubble_pop2.png");
    public static ResourceLocation POP_3 = ArsNouveau.prefix("textures/entity/bubble_pop3.png");
    public static ResourceLocation POP_4 = ArsNouveau.prefix("textures/entity/bubble_pop4.png");
    public static ResourceLocation POP_5 = ArsNouveau.prefix("textures/entity/bubble_pop5.png");

    public BubbleRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(BubbleEntity pEntity) {
        return TEXTURE;
    }

    public void render(BubbleEntity entityIn, float pEntityYaw, float pPartialTick, PoseStack matrixStack, MultiBufferSource buffer, int pPackedLight) {
        BubbleRenderer.renderBubble((Entity)entityIn, this.entityRenderDispatcher, matrixStack, buffer);
    }

    public static void renderBubble(Entity entityIn, EntityRenderDispatcher entityRenderDispatcher, PoseStack matrixStack, MultiBufferSource buffer) {
        double y = entityIn.getBbHeight();
        matrixStack.pushPose();
        matrixStack.translate(0.0, y, 0.0);
        matrixStack.mulPose(entityRenderDispatcher.cameraOrientation());
        matrixStack.scale(0.025f, -0.025f, 0.025f);
        float base = 2.0f;
        Entity passenger = entityIn.getFirstPassenger();
        if (passenger != null) {
            base += 1.0f;
            base *= passenger.getBbWidth() / entityIn.getBbWidth();
        }
        matrixStack.scale(base, base, base);
        Matrix4f pose = matrixStack.last().pose();
        ResourceLocation texture = TEXTURE;
        if (entityIn instanceof BubbleEntity) {
            BubbleEntity bubbleEntity = (BubbleEntity)entityIn;
            if (bubbleEntity.poppingTicks > 0) {
                int popTicks = bubbleEntity.poppingTicks;
                texture = popTicks < 2 ? POP_1 : (popTicks < 3 ? POP_2 : (popTicks < 4 ? POP_3 : (popTicks < 5 ? POP_4 : POP_5)));
            }
        }
        VertexConsumer r = buffer.getBuffer(ShaderRegistry.worldEntityIcon(texture));
        r.addVertex(pose, -8.0f, -8.0f, 0.0f).setUv(0.0f, 0.0f);
        r.addVertex(pose, -8.0f, 8.0f, 0.0f).setUv(0.0f, 1.0f);
        r.addVertex(pose, 8.0f, 8.0f, 0.0f).setUv(1.0f, 1.0f);
        r.addVertex(pose, 8.0f, -8.0f, 0.0f).setUv(1.0f, 0.0f);
        matrixStack.popPose();
    }
}

