/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.jei.ApparatusEnchantingRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ArmorUpgradeRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.BuddingConversionRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.CraftingTerminalTransferHandler;
import com.hollingsworth.arsnouveau.client.jei.CrushRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.DyeRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.GlyphRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ImbuementRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.ScryRitualRecipeCategory;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ArmorUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.DyeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ScryRitualRecipe;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIArsNouveauPlugin
implements IModPlugin {
    public static final RecipeType<GlyphRecipe> GLYPH_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"glyph_recipe", GlyphRecipe.class);
    public static final RecipeType<EnchantingApparatusRecipe> ENCHANTING_APP_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"enchanting_apparatus", EnchantingApparatusRecipe.class);
    public static final RecipeType<EnchantmentRecipe> ENCHANTING_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"enchantment_apparatus", EnchantmentRecipe.class);
    public static final RecipeType<ArmorUpgradeRecipe> ARMOR_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"armor_upgrade", ArmorUpgradeRecipe.class);
    public static final RecipeType<ImbuementRecipe> IMBUEMENT_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"imbuement", ImbuementRecipe.class);
    public static final RecipeType<CrushRecipe> CRUSH_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"crush", CrushRecipe.class);
    public static final RecipeType<BuddingConversionRecipe> BUDDING_CONVERSION_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"budding_conversion", BuddingConversionRecipe.class);
    public static final RecipeType<ScryRitualRecipe> SCRY_RITUAL_RECIPE_TYPE = RecipeType.create((String)"ars_nouveau", (String)"scry_ritual", ScryRitualRecipe.class);
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ArsNouveau.prefix("main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GlyphRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CrushRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ImbuementRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new EnchantingApparatusRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ApparatusEnchantingRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ArmorUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BuddingConversionRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ScryRitualRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        ArrayList<GlyphRecipe> recipeList = new ArrayList<GlyphRecipe>();
        ArrayList<EnchantingApparatusRecipe> apparatus = new ArrayList<EnchantingApparatusRecipe>();
        ArrayList<EnchantmentRecipe> enchantments = new ArrayList<EnchantmentRecipe>();
        ArrayList<CrushRecipe> crushRecipes = new ArrayList<CrushRecipe>();
        ArrayList<ArmorUpgradeRecipe> armorUpgrades = new ArrayList<ArmorUpgradeRecipe>();
        List<ImbuementRecipe> imbuementRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).stream().map(RecipeHolder::value).toList();
        ArrayList<BuddingConversionRecipe> buddingConversionRecipes = new ArrayList<BuddingConversionRecipe>();
        ArrayList<ScryRitualRecipe> scryRitualRecipes = new ArrayList<ScryRitualRecipe>();
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        for (Recipe i : manager.getRecipes().stream().map(RecipeHolder::value).toList()) {
            EnchantingApparatusRecipe enchantingApparatusRecipe;
            if (i instanceof GlyphRecipe) {
                GlyphRecipe glyphRecipe = (GlyphRecipe)i;
                recipeList.add(glyphRecipe);
            }
            if (i instanceof EnchantmentRecipe) {
                EnchantmentRecipe enchantmentRecipe = (EnchantmentRecipe)i;
                enchantments.add(enchantmentRecipe);
            } else if (i instanceof ArmorUpgradeRecipe) {
                ArmorUpgradeRecipe upgradeRecipe = (ArmorUpgradeRecipe)i;
                armorUpgrades.add(upgradeRecipe);
            } else if (i instanceof EnchantingApparatusRecipe && !(enchantingApparatusRecipe = (EnchantingApparatusRecipe)i).excludeJei()) {
                apparatus.add(enchantingApparatusRecipe);
            }
            if (i instanceof CrushRecipe) {
                CrushRecipe crushRecipe = (CrushRecipe)i;
                crushRecipes.add(crushRecipe);
            }
            if (i instanceof BuddingConversionRecipe) {
                BuddingConversionRecipe buddingConversionRecipe = (BuddingConversionRecipe)i;
                buddingConversionRecipes.add(buddingConversionRecipe);
            }
            if (!(i instanceof ScryRitualRecipe)) continue;
            ScryRitualRecipe scryRitualRecipe = (ScryRitualRecipe)i;
            scryRitualRecipes.add(scryRitualRecipe);
        }
        registry.addRecipes(GLYPH_RECIPE_TYPE, recipeList);
        registry.addRecipes(CRUSH_RECIPE_TYPE, crushRecipes);
        registry.addRecipes(ENCHANTING_APP_RECIPE_TYPE, apparatus);
        registry.addRecipes(ENCHANTING_RECIPE_TYPE, enchantments);
        registry.addRecipes(IMBUEMENT_RECIPE_TYPE, imbuementRecipes);
        registry.addRecipes(ARMOR_RECIPE_TYPE, armorUpgrades);
        registry.addRecipes(BUDDING_CONVERSION_RECIPE_TYPE, buddingConversionRecipes);
        registry.addRecipes(SCRY_RITUAL_RECIPE_TYPE, scryRitualRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.SCRIBES_BLOCK), new RecipeType[]{GLYPH_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)EffectCrush.INSTANCE.glyphItem), new RecipeType[]{CRUSH_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.IMBUEMENT_BLOCK), new RecipeType[]{IMBUEMENT_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ENCHANTING_APP_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ENCHANTING_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack(BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ARMOR_RECIPE_TYPE});
        registry.addRecipeCatalyst(new ItemStack(ItemsRegistry.AMETHYST_GOLEM_CHARM), new RecipeType[]{BUDDING_CONVERSION_RECIPE_TYPE});
        registry.addRecipeCatalyst(RitualRegistry.getRitualItemMap().get(ScryRitualRecipeCategory.SCRY_RITUAL).asItem().getDefaultInstance(), new RecipeType[]{SCRY_RITUAL_RECIPE_TYPE});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        CraftingTerminalTransferHandler.registerTransferHandlers(registration);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(DyeRecipe.class, (ICraftingCategoryExtension)new DyeRecipeCategory());
    }

    public void registerIngredientAliases(@NotNull IIngredientAliasRegistration registration) {
        List<SpellSchool> schools = List.of(SpellSchools.ELEMENTAL, SpellSchools.ABJURATION, SpellSchools.CONJURATION, SpellSchools.NECROMANCY, SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER);
        for (SpellSchool school : schools) {
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, GlyphRegistry.getGlyphItemMap().values().stream().map(Supplier::get).filter(glyph -> school.isPartOfSchool(glyph.spellPart)).map(Item::getDefaultInstance).toList(), school.getTextComponent().getString());
        }
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        JEIArsNouveauPlugin.jeiRuntime = jeiRuntime;
    }

    static {
        IAutoFillTerminal.updateSearch.add(new IAutoFillTerminal.ISearchHandler(){

            @Override
            public void setSearch(String text) {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    jeiRuntime.getIngredientFilter().setFilterText(text);
                }
            }

            @Override
            public String getSearch() {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    return jeiRuntime.getIngredientFilter().getFilterText();
                }
                return "";
            }

            @Override
            public String getName() {
                return "JEI";
            }
        });
    }
}

