/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class CraftingButton
extends GuiImageButton {
    private AbstractSpellPart abstractSpellPart = null;
    public List<SpellValidationError> validationErrors = new LinkedList<SpellValidationError>();
    public int slotNum;

    public CraftingButton(int x, int y, Button.OnPress onPress, int slotNum) {
        super(x, y, 0, 0, 22, 20, 22, 20, "textures/gui/spell_glyph_slot.png", onPress);
        this.slotNum = slotNum;
    }

    public void clear() {
        this.validationErrors.clear();
        this.abstractSpellPart = null;
    }

    @Nullable
    public AbstractSpellPart getAbstractSpellPart() {
        return this.abstractSpellPart;
    }

    public void setAbstractSpellPart(AbstractSpellPart abstractSpellPart) {
        this.abstractSpellPart = abstractSpellPart;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.validationErrors.isEmpty()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
        }
        if (this.abstractSpellPart != null) {
            RenderUtils.drawSpellPart(this.abstractSpellPart, graphics, this.x + 3, this.y + 2, 16, !this.validationErrors.isEmpty(), 0);
        }
        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.abstractSpellPart != null) {
            tooltip.add((Component)Component.translatable((String)this.abstractSpellPart.getLocalizationKey()));
            for (SpellValidationError ve : this.validationErrors) {
                tooltip.add((Component)ve.makeTextComponentExisting().withStyle(ChatFormatting.RED));
            }
        }
    }
}

