/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public record SpellTooltip(AbstractCaster<?> spellcaster, boolean showName) implements TooltipComponent
{
    public SpellTooltip(AbstractCaster<?> spellcaster) {
        this(spellcaster, false);
    }

    public static class SpellTooltipRenderer
    implements ClientTooltipComponent {
        private final AbstractCaster<?> spellCaster;
        private final boolean showName;

        public SpellTooltipRenderer(SpellTooltip pSpellTooltip) {
            this.spellCaster = pSpellTooltip.spellcaster();
            this.showName = pSpellTooltip.showName();
        }

        public int getHeight() {
            return this.showName ? 28 : 20;
        }

        public int getWidth(@NotNull Font pFont) {
            return 4 + this.spellCaster.getSpell().size() * 16;
        }

        public void renderText(@NotNull Font pFont, int pX, int pY, @NotNull Matrix4f pMatrix, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull MultiBufferSource.BufferSource pBufferSource) {
            if (this.showName) {
                pFont.drawInBatch((Component)Component.literal((String)this.spellCaster.getSpellName()), (float)(pX + 4), (float)pY, -1, true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }

        public void renderImage(@NotNull Font pFont, int pX, int pY, @NotNull GuiGraphics pGuiGraphics) {
            Spell spell = this.spellCaster.getSpell();
            int recipeSize = spell.size();
            for (int i = 0; i < recipeSize; ++i) {
                AbstractSpellPart part = spell.get(i);
                RenderUtils.drawSpellPart(part, pGuiGraphics, pX + i * 16, pY + (this.showName ? 10 : 0), 16, false);
            }
        }
    }
}

