/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.container.FakeSlot;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.container.NumberFormatUtil;
import com.hollingsworth.arsnouveau.client.container.SlotStorage;
import com.hollingsworth.arsnouveau.client.container.SortSettings;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.buttons.StateButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.StorageSettingsButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.StorageTabButton;
import com.hollingsworth.arsnouveau.common.network.ClientToServerStoragePacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.SetTerminalSettingsPacket;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractStorageTerminalScreen<T extends StorageTerminalMenu>
extends AbstractContainerScreen<T> {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) {
            return key.getStack().getTooltipLines(Item.TooltipContext.EMPTY, (Player)Minecraft.getInstance().player, AbstractStorageTerminalScreen.getTooltipFlag()).stream().map(Component::getString).collect(Collectors.toList());
        }
    });
    protected Minecraft mc = Minecraft.getInstance();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected NoShadowTextField searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    protected boolean expanded;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected static final ResourceLocation scrollBall = ArsNouveau.prefix("textures/gui/scroll_ball.png");
    protected static final ResourceLocation tabImages = ArsNouveau.prefix("textures/gui/bookwyrm_storage_tabs.png");
    protected StateButton buttonSortingType;
    protected StateButton buttonDirection;
    protected StateButton buttonSearchType;
    private Comparator<StoredItemStack> sortComp;
    List<String> tabNames = new ArrayList<String>();
    public List<StorageTabButton> tabButtons = new ArrayList<StorageTabButton>();
    boolean noSort;
    List<StoredItemStack> itemsSorted = new ArrayList<StoredItemStack>();
    List<StoredItemStack> itemsUnsorted = new ArrayList<StoredItemStack>();
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public AbstractStorageTerminalScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void receiveSettings(SortSettings settings) {
        boolean wasExpanded = this.expanded;
        if (settings != null) {
            this.controllMode = settings.controlMode();
            this.comparator = StoredItemStack.SortingTypes.VALUES[settings.sortType() % StoredItemStack.SortingTypes.VALUES.length].create(settings.reverseSort());
            this.searchType = settings.searchType();
            this.buttonSortingType.state = settings.sortType();
            this.buttonDirection.state = settings.reverseSort() ? 1 : 0;
            this.buttonSearchType.state = this.searchType;
            this.expanded = settings.expanded();
        }
        if (this.expanded != wasExpanded) {
            ((StorageTerminalMenu)this.menu).addStorageSlots(this.expanded);
        }
    }

    protected void onPacket() {
        if (this.tabNames != null && !this.tabNames.isEmpty()) {
            for (StorageTabButton tabButton : this.tabButtons) {
                tabButton.visible = false;
            }
            this.tabButtons.get((int)0).visible = true;
            ArrayList<String> names = new ArrayList<String>(new HashSet<String>(this.tabNames));
            names.sort(String::compareToIgnoreCase);
            for (int i = 0; i < names.size() && i < this.tabButtons.size(); ++i) {
                this.tabButtons.get((int)(i + 1)).visible = true;
                this.tabButtons.get((int)(i + 1)).highlightText = (String)names.get(i);
            }
        }
        if (!this.loadedSearch && ((StorageTerminalMenu)this.menu).search != null) {
            this.loadedSearch = true;
            this.searchField.setValue(((StorageTerminalMenu)this.menu).search);
            this.searchField.setFocused(true);
            if (this.searchField.getValue().isEmpty()) {
                this.searchField.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
            } else {
                this.searchField.setSuggestion("");
            }
        }
    }

    protected void syncSortSettings() {
        StorageTabButton selectedTabButton = this.tabButtons.stream().filter(i -> i.visible && i.isSelected).findFirst().orElse(null);
        Networking.sendToServer(new SetTerminalSettingsPacket(this.getSortSettings(), selectedTabButton == null ? null : selectedTabButton.highlightText));
    }

    public SortSettings getSortSettings() {
        return new SortSettings(this.controllMode, this.comparator.isReversed(), this.comparator.type(), this.searchType, this.expanded);
    }

    protected void init() {
        this.clearWidgets();
        this.scrollTo(0.0f);
        this.inventoryLabelY = this.imageHeight - 92;
        super.init();
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new NoShadowTextField(font, this.leftPos + 115, this.topPos + 6, 60, 9, (Component)Component.translatable((String)"narrator.ars_nouveau.search"));
        this.searchField.setMaxLength(100);
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setValue(this.searchLast);
        this.searchLast = "";
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.buttonSortingType = (StateButton)this.addRenderableWidget((GuiEventListener)new StorageSettingsButton(this.leftPos - 17, this.topPos + 14, 22, 12, 44, 13, 0, ArsNouveau.prefix("textures/gui/sort_type.png"), b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.state = this.comparator.type();
            this.syncSortSettings();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (StateButton)this.addRenderableWidget((GuiEventListener)new StorageSettingsButton(this.leftPos - 17, this.topPos + 29, 22, 12, 44, 13, 0, ArsNouveau.prefix("textures/gui/sort_order.png"), b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.state = this.comparator.isReversed() ? 1 : 0;
            this.syncSortSettings();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (StateButton)this.addRenderableWidget((GuiEventListener)new StorageSettingsButton(this.leftPos - 17, this.topPos + 44, 22, 12, 44, 13, 0, ArsNouveau.prefix("textures/gui/search_sync.png"), b -> {
            this.buttonSearchType.state = this.searchType = this.searchType == 0 ? 1 : 0;
            this.syncSortSettings();
        }));
        for (int i = 0; i < 12; ++i) {
            StorageTabButton button = (StorageTabButton)this.addRenderableWidget((GuiEventListener)new StorageTabButton(this.leftPos - 13, this.topPos + 59 + i * 15, 18, 12, 256, 13, i, 0, tabImages, b -> {
                StorageTabButton tabButton = (StorageTabButton)b;
                this.setSelectedTab(tabButton.state);
                this.syncSortSettings();
            }));
            button.visible = false;
            if (i == 0) {
                button.isAll = true;
                button.isSelected = true;
            }
            this.tabButtons.add(button);
        }
        this.updateSearch();
    }

    public void setSelectedTab(int index) {
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get((int)i).isSelected = i == index;
        }
    }

    protected void updateSearch() {
        String searchString = this.searchField.getValue().trim();
        if (this.searchField.getValue().isEmpty()) {
            this.searchField.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
        } else {
            this.searchField.setSuggestion("");
        }
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            this.itemsSorted = new ArrayList<StoredItemStack>();
            boolean searchMod = false;
            String search = searchString;
            if (searchString.startsWith("@")) {
                searchMod = true;
                search = searchString.substring(1);
            }
            Pattern m = null;
            try {
                m = Pattern.compile(search.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(search.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            try {
                block6: for (StoredItemStack is : this.itemsUnsorted) {
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? BuiltInRegistries.ITEM.getKey((Object)is.getStack().getItem()).getNamespace() : is.getStack().getHoverName().getString();
                    boolean notDone = true;
                    if (m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone) continue;
                    for (String lp : (List)tooltipCache.get((Object)is)) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        continue block6;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Collections.sort(this.itemsSorted, this.noSort ? this.sortComp : this.comparator);
            if (!this.searchLast.equals(searchString)) {
                this.scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if (this.searchType == 1) {
                    IAutoFillTerminal.sync(searchString);
                }
                CompoundTag nbt = new CompoundTag();
                nbt.putString("search", searchString);
                Networking.sendToServer(new ClientToServerStoragePacket(nbt));
                this.onUpdateSearch(searchString);
            } else {
                this.scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    public final void scrollTo(float p_148329_1_) {
        int lines = this.getSortSettings() == null || !this.getSortSettings().expanded() ? 3 : 7;
        int i = (this.itemsSorted.size() + 9 - 1) / 9 - lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemsSorted.size()) {
                    ((StorageTerminalMenu)this.menu).setSlotContents(l + k * 9, this.itemsSorted.get(i1));
                    continue;
                }
                ((StorageTerminalMenu)this.menu).setSlotContents(l + k * 9, null);
            }
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        this.itemsSorted.add(is);
    }

    public static TooltipFlag getTooltipFlag() {
        return Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
    }

    protected void containerTick() {
        this.updateSearch();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack st = graphics.pose();
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0) != 0;
        int i = this.leftPos;
        int j = this.topPos;
        int k = i + 187;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (AbstractStorageTerminalScreen.hasShiftDown()) {
            if (!this.noSort) {
                List<StoredItemStack> list = this.itemsSorted;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                map.defaultReturnValue(Integer.MAX_VALUE);
                for (int m = 0; m < list.size(); ++m) {
                    map.put((Object)list.get(m), m);
                }
                this.sortComp = Comparator.comparing(arg_0 -> ((Object2IntMap)map).getInt(arg_0));
                this.noSort = true;
            }
        } else if (this.noSort) {
            this.sortComp = null;
            this.noSort = false;
            this.refreshItemList = true;
            this.itemsUnsorted = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.menu).itemList);
        }
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        i = k;
        j = l;
        k = j1;
        graphics.blit(scrollBall, i, j + 3 + (int)((float)(k - j - 14) * this.currentScroll), 0.0f, 0.0f, 12, 12, 12, 12);
        if (((StorageTerminalMenu)this.menu).getCarried().isEmpty() && this.slotIDUnderMouse != -1) {
            SlotStorage slot = ((StorageTerminalMenu)this.getMenu()).storageSlotList.get(this.slotIDUnderMouse);
            if (slot.stack != null) {
                if (slot.stack.getQuantity() > 9999L) {
                    ClientInfo.setTooltip(new Component[]{Component.translatable((String)"tooltip.ars_nouveau.amount", (Object[])new Object[]{slot.stack.getQuantity()})});
                }
                graphics.renderTooltip(this.font, slot.stack.getActualStack(), mouseX, mouseY);
                ClientInfo.setTooltip(new Component[0]);
            }
        } else {
            this.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.buttonSortingType.isHovered()) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)("tooltip.ars_nouveau.sorting_" + this.buttonSortingType.state)), mouseX, mouseY);
        }
        if (this.buttonSearchType.isHovered()) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)("tooltip.ars_nouveau.search_" + this.buttonSearchType.state), (Object[])new Object[]{IAutoFillTerminal.getHandlerName()}), mouseX, mouseY);
        }
        if (this.buttonDirection.isHovered()) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)("tooltip.ars_nouveau.direction_" + this.buttonDirection.state), (Object[])new Object[]{IAutoFillTerminal.getHandlerName()}), mouseX, mouseY);
        }
        for (StorageTabButton tabButton : this.tabButtons) {
            if (tabButton.isHovered() && tabButton.isAll) {
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.ars_nouveau.master_tab"), mouseX, mouseY);
                continue;
            }
            if (!tabButton.isHovered() || tabButton.highlightText == null) continue;
            graphics.renderTooltip(this.font, (Component)Component.literal((String)tabButton.highlightText), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics p_281635_, int mouseX, int mouseY) {
        PoseStack st = p_281635_.pose();
        st.pushPose();
        this.slotIDUnderMouse = this.drawSlots(p_281635_, mouseX, mouseY);
        st.popPose();
    }

    protected int drawSlots(GuiGraphics st, int mouseX, int mouseY) {
        StorageTerminalMenu term = (StorageTerminalMenu)this.getMenu();
        int slotHover = -1;
        for (int i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            slotHover = i;
        }
        return slotHover;
    }

    protected boolean drawSlot(GuiGraphics st, SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            ItemStack stack = slot.stack.getStack().copy().split(1);
            int i = slot.xDisplayPosition;
            int j = slot.yDisplayPosition;
            st.renderItem(stack, i, j);
            st.renderItemDecorations(this.font, stack, i, j, null);
            this.drawStackSize(st, this.getFont(), slot.stack.getQuantity(), i, j);
        }
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = slot.xDisplayPosition;
            int t = slot.yDisplayPosition;
            AbstractStorageTerminalScreen.renderSlotHighlight((GuiGraphics)st, (int)l, (int)t, (int)0);
            return true;
        }
        return false;
    }

    private void drawStackSize(GuiGraphics graphics, Font fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        String stackSize = NumberFormatUtil.formatNumber(size);
        PoseStack st = graphics.pose();
        st.pushPose();
        st.scale(scaleFactor, scaleFactor, scaleFactor);
        st.translate(0.0f, 0.0f, 450.0f);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.width(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        graphics.drawString(this.font, stackSize, X, Y, 0xFFFFFF);
        st.popPose();
        RenderSystem.enableDepthTest();
    }

    protected boolean needsScrollBars() {
        return this.itemsSorted.size() > this.rowCount * 9;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.searchField.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.slotIDUnderMouse > -1) {
            if (this.isPullOne(mouseButton)) {
                if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, StorageTerminalMenu.SlotAction.PULL_ONE, this.isTransferOne(mouseButton));
                    return true;
                }
                return true;
            }
            if (this.pullHalf(mouseButton)) {
                if (!((StorageTerminalMenu)this.menu).getCarried().isEmpty()) {
                    this.storageSlotClick(null, AbstractStorageTerminalScreen.hasControlDown() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                } else if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.hasControlDown() ? StorageTerminalMenu.SlotAction.GET_QUARTER : StorageTerminalMenu.SlotAction.GET_HALF, false);
                    return true;
                }
            } else if (this.pullNormal(mouseButton)) {
                if (!((StorageTerminalMenu)this.menu).getCarried().isEmpty()) {
                    this.storageSlotClick(null, StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
                } else if (((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack != null && ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() > 0L) {
                    this.storageSlotClick(((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack, AbstractStorageTerminalScreen.hasShiftDown() ? StorageTerminalMenu.SlotAction.SHIFT_PULL : StorageTerminalMenu.SlotAction.PULL_OR_PUSH_STACK, false);
                    return true;
                }
            }
        } else if (GLFW.glfwGetKey((long)this.mc.getWindow().getWindow(), (int)32) != 0) {
            this.storageSlotClick(null, StorageTerminalMenu.SlotAction.SPACE_CLICK, false);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void storageSlotClick(StoredItemStack slotStack, StorageTerminalMenu.SlotAction act, boolean pullOne) {
        CompoundTag interactTag = new CompoundTag();
        interactTag.putBoolean("pullOne", pullOne);
        interactTag.putInt("action", act.ordinal());
        if (slotStack != null) {
            interactTag.put("stack", ANCodecs.encode((HolderLookup.Provider)ArsNouveau.proxy.getMinecraft().level.registryAccess(), StoredItemStack.CODEC, slotStack));
        }
        CompoundTag dataTag = new CompoundTag();
        dataTag.put("interaction", (Tag)interactTag);
        Networking.sendToServer(new ClientToServerStoragePacket(dataTag));
    }

    public boolean isPullOne(int mouseButton) {
        return mouseButton == 1 && AbstractStorageTerminalScreen.hasShiftDown();
    }

    public boolean isTransferOne(int mouseButton) {
        return AbstractStorageTerminalScreen.hasShiftDown() && AbstractStorageTerminalScreen.hasControlDown();
    }

    public boolean pullHalf(int mouseButton) {
        return mouseButton == 1;
    }

    public boolean pullNormal(int mouseButton) {
        return mouseButton == 0;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.onClose();
            return true;
        }
        return this.searchField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.searchField.canConsumeInput() || super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_, double scrollY) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (this.itemsSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll + scrollY / (double)i);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.scrollTo(this.currentScroll);
        return true;
    }

    public abstract ResourceLocation getGui();

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(this.getGui(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(ArsNouveau.prefix("textures/gui/search_paper.png"), this.leftPos + 102, this.topPos + 3, 0.0f, 0.0f, 72, 15, 72, 15);
    }

    protected void onUpdateSearch(String text) {
    }

    public void receive(CompoundTag tag) {
        ((StorageTerminalMenu)this.menu).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
        if (tag.contains("tabs")) {
            ListTag tabs = tag.getList("tabs", 10);
            this.tabNames = new ArrayList<String>();
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < tabs.size(); ++i) {
                nameSet.add(tabs.getCompound(i).getString("name"));
            }
            this.tabNames.addAll(new ArrayList(nameSet).subList(0, Math.min(nameSet.size(), 11)));
            Collections.sort(this.tabNames);
        }
        this.onPacket();
    }

    public void updateItems(List<StoredItemStack> items) {
        ((StorageTerminalMenu)this.menu).updateItems(items);
        this.refreshItemList = true;
        if (this.noSort) {
            this.itemsUnsorted.forEach(s -> {
                StoredItemStack mapStack = ((StorageTerminalMenu)this.menu).itemMap.get(s);
                s.setCount(mapStack != null ? mapStack.getQuantity() : 0L);
            });
        } else {
            this.itemsUnsorted = new ArrayList<StoredItemStack>(((StorageTerminalMenu)this.menu).itemList);
        }
    }

    public Slot getSlotUnderMouse() {
        Slot s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.container.setItem(0, ((StorageTerminalMenu)this.getMenu()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }
}

