/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SpellSchool {
    private final String id;
    private Set<SpellSchool> subSchools = new HashSet<SpellSchool>();
    private Set<AbstractSpellPart> spellParts = new HashSet<AbstractSpellPart>();

    public SpellSchool(String id) {
        this.id = id;
    }

    public boolean isPartOfSchool(AbstractSpellPart part) {
        if (this.getSpellParts().contains(part)) {
            return true;
        }
        for (SpellSchool spellSchool : this.getSubSchools()) {
            if (!spellSchool.getSpellParts().contains(part)) continue;
            return true;
        }
        return false;
    }

    public boolean addSpellPart(AbstractSpellPart spellPart) {
        return this.getSpellParts().add(spellPart);
    }

    public Component getTextComponent() {
        return Component.translatable((String)("ars_nouveau.school." + this.getId()));
    }

    public String getId() {
        return this.id;
    }

    public Set<SpellSchool> getSubSchools() {
        return this.subSchools;
    }

    public void setSubSchools(Set<SpellSchool> subSchools) {
        this.subSchools = subSchools;
    }

    public SpellSchool withSubSchool(SpellSchool spellSchool) {
        this.getSubSchools().add(spellSchool);
        return this;
    }

    public Set<AbstractSpellPart> getSpellParts() {
        return this.spellParts;
    }

    public void setSpellParts(Set<AbstractSpellPart> spellParts) {
        this.spellParts = spellParts;
    }

    public ResourceLocation getTexturePath() {
        return ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)("textures/gui/schools/" + this.getId() + "_tooltip.png"));
    }
}

