/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class SpellResolver
implements Cloneable {
    public AbstractCastMethod castType;
    public Spell spell;
    public SpellContext spellContext;
    public boolean silent;
    private final ISpellValidator spellValidator;
    @Nullable
    public HitResult hitResult = null;
    @Nullable
    public SpellResolver previousResolver = null;

    public SpellResolver(SpellContext spellContext) {
        this.spell = spellContext.getSpell();
        this.castType = spellContext.getSpell().getCastMethod();
        this.spellContext = spellContext;
        this.spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
    }

    public SpellResolver withSilent(boolean isSilent) {
        this.silent = isSilent;
        return this;
    }

    public boolean canCast(LivingEntity entity) {
        List<SpellValidationError> validationErrors = this.spellValidator.validate(this.spell.unsafeList());
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && !entity.getCommandSenderWorld().isClientSide) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)validationErrors.get(0).makeTextComponentExisting());
        }
        return false;
    }

    protected boolean enoughMana(LivingEntity entity) {
        Player player;
        boolean canCast;
        int totalCost = this.getResolveCost();
        boolean enoughMana = this.spellContext.getCaster().enoughMana(totalCost);
        boolean bl = canCast = enoughMana || entity instanceof Player && (player = (Player)entity).isCreative();
        if (!canCast && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!this.silent) {
                PortUtil.sendMessageNoSpam((Entity)serverPlayer, (Component)Component.translatable((String)"ars_nouveau.spell.no_mana"));
                Networking.sendToPlayerClient(new NotEnoughManaPacket(totalCost), serverPlayer);
            }
        }
        return canCast;
    }

    public SpellCastEvent postEvent() {
        return SpellUtil.postEvent(new SpellCastEvent(this.spell, this.spellContext));
    }

    public SpellStats getCastStats() {
        LivingEntity caster = this.spellContext.getUnwrappedCaster();
        return new SpellStats.Builder().setAugments(this.spell.getAugments(0, caster)).addItemsFromEntity(caster).build(this.castType, this.hitResult, caster.level, caster, this.spellContext);
    }

    public boolean onCast(ItemStack stack, Level level) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent().isCanceled()) {
            this.hitResult = null;
            CastResolveType resolveType = this.castType.onCast(stack, this.spellContext.getUnwrappedCaster(), level, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnBlock(BlockHitResult blockRayTraceResult) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent().isCanceled()) {
            this.hitResult = blockRayTraceResult;
            CastResolveType resolveType = this.castType.onCastOnBlock(blockRayTraceResult, this.spellContext.getUnwrappedCaster(), this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnBlock(UseOnContext context) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent().isCanceled()) {
            this.hitResult = context.hitResult;
            CastResolveType resolveType = this.castType.onCastOnBlock(context, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public boolean onCastOnEntity(ItemStack stack, Entity target, InteractionHand hand) {
        if (this.canCast(this.spellContext.getUnwrappedCaster()) && !this.postEvent().isCanceled()) {
            this.hitResult = new EntityHitResult(target);
            CastResolveType resolveType = this.castType.onCastOnEntity(stack, this.spellContext.getUnwrappedCaster(), target, hand, this.getCastStats(), this.spellContext, this);
            if (resolveType == CastResolveType.SUCCESS) {
                this.expendMana();
            }
            return resolveType.wasSuccess;
        }
        return false;
    }

    public void onResolveEffect(Level world, HitResult result) {
        this.hitResult = result;
        this.resolveAllEffects(world);
    }

    protected void resolveAllEffects(Level world) {
        this.spellContext.resetCastCounter();
        this.resume(world);
    }

    public void resume(Level world) {
        AbstractSpellPart part;
        LivingEntity shooter = this.spellContext.getUnwrappedCaster();
        SpellResolveEvent.Pre spellResolveEvent = new SpellResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext, this);
        NeoForge.EVENT_BUS.post((Event)spellResolveEvent);
        if (spellResolveEvent.isCanceled()) {
            return;
        }
        while (this.spellContext.hasNextPart() && (part = this.spellContext.nextPart()) != null) {
            if (part instanceof AbstractAugment || !part.isEnabled()) continue;
            SpellStats.Builder builder = new SpellStats.Builder();
            List<AbstractAugment> augments = this.spell.getAugments(this.spellContext.getCurrentIndex() - 1, shooter);
            SpellStats stats = builder.setAugments(augments).addItemsFromEntity(shooter).build(part, this.hitResult, world, shooter, this.spellContext);
            if (!(part instanceof AbstractEffect)) continue;
            AbstractEffect effect = (AbstractEffect)part;
            EffectResolveEvent.Pre preEvent = new EffectResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext, effect, stats, this);
            NeoForge.EVENT_BUS.post((Event)preEvent);
            if (preEvent.isCanceled()) continue;
            effect.onResolve(this.hitResult, world, shooter, stats, this.spellContext, this);
            NeoForge.EVENT_BUS.post((Event)new EffectResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext, effect, stats, this));
        }
        NeoForge.EVENT_BUS.post((Event)new SpellResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext, this));
    }

    public void expendMana() {
        int totalCost = this.getResolveCost();
        this.spellContext.getCaster().expendMana(totalCost);
    }

    public int getResolveCost() {
        int cost = this.spellContext.getSpell().getCost() - ManaUtil.getPlayerDiscounts(this.spellContext.getUnwrappedCaster(), this.spell, this.spellContext.getCasterTool());
        SpellCostCalcEvent event = new SpellCostCalcEvent(this.spellContext, cost);
        NeoForge.EVENT_BUS.post((Event)event);
        cost = Math.max(0, event.currentCost);
        return cost;
    }

    public SpellResolver getNewResolver(SpellContext context) {
        SpellResolver newResolver = new SpellResolver(context);
        newResolver.previousResolver = this;
        return newResolver;
    }

    public boolean hasFocus(ItemStack stack) {
        return CuriosUtil.hasItem(this.spellContext.getUnwrappedCaster(), stack);
    }

    public boolean hasFocus(Item stack) {
        return CuriosUtil.hasItem(this.spellContext.getUnwrappedCaster(), stack.getDefaultInstance());
    }

    public SpellResolver clone() {
        try {
            SpellResolver clone = (SpellResolver)super.clone();
            clone.spellContext = this.spellContext.clone();
            clone.previousResolver = this.previousResolver != null ? this.previousResolver.clone() : null;
            clone.castType = this.castType;
            clone.spell = this.spell;
            clone.silent = this.silent;
            clone.hitResult = this.hitResult;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

