/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.source;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSourceMachine
extends ModdedTile
implements ISourceTile,
IWololoable {
    private int source = 0;
    private int maxSource = 0;
    private ParticleColor color = ParticleColor.defaultParticleColor();
    public static String SOURCE_TAG = "source";
    public static String MAX_SOURCE_TAG = "max_source";
    public static String COLOR_TAG = "color";
    @Nullable
    public SourceStorage sourceStorage;

    public AbstractSourceMachine(BlockEntityType<?> manaTile, BlockPos pos, BlockState state) {
        super(manaTile, pos, state);
    }

    @NotNull
    public SourceStorage getSourceStorage() {
        if (this.sourceStorage == null) {
            this.sourceStorage = new SourceStorage(this.getMaxSource(), this.getTransferRate(), this.getTransferRate(), this.source){

                @Override
                public void onContentsChanged() {
                    AbstractSourceMachine.this.source = this.source;
                    AbstractSourceMachine.this.updateBlock();
                }
            };
            if (this.level != null) {
                this.level.invalidateCapabilities(this.worldPosition);
            }
        }
        return this.sourceStorage;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.source = tag.getInt(SOURCE_TAG);
        this.maxSource = tag.getInt(MAX_SOURCE_TAG);
        this.color = ParticleColor.fromInt(tag.getInt(COLOR_TAG));
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt(SOURCE_TAG, this.getSource());
        tag.putInt(MAX_SOURCE_TAG, this.getMaxSource());
        tag.putInt(COLOR_TAG, this.getColor().getColor());
    }

    @Override
    public int setSource(int source) {
        if (this.source == source) {
            return this.source;
        }
        this.source = Math.clamp((long)source, 0, this.getMaxSource());
        this.updateBlock();
        return this.source;
    }

    @Override
    public boolean updateBlock() {
        if (this.level != null) {
            this.getSourceStorage().setSource(this.source);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public int addSource(int source, boolean simulate) {
        return this.getSourceStorage().receiveSource(source, simulate);
    }

    @Override
    public int addSource(int source) {
        return this.setSource(this.getSource() + source);
    }

    @Override
    public int getSource() {
        if (this.sourceStorage == null) {
            return this.source;
        }
        return this.getSourceStorage().getSource();
    }

    @Override
    public int removeSource(int source, boolean simulate) {
        return this.getSourceStorage().extractSource(source, simulate);
    }

    @Override
    public int removeSource(int source) {
        if (source == 0) {
            return this.getSource();
        }
        this.setSource(this.getSource() - source);
        return this.getSource();
    }

    @Override
    public void setMaxSource(int max) {
        this.maxSource = max;
        this.updateBlock();
    }

    @Override
    public int getMaxSource() {
        if (this.sourceStorage == null) {
            return this.maxSource;
        }
        return this.getSourceStorage().getSourceCapacity();
    }

    @Override
    public boolean canAcceptSource() {
        return this.getSource() < this.getMaxSource();
    }

    @Override
    public boolean canProvideSource() {
        return this.getSource() > 0;
    }

    public boolean canAcceptSource(int source) {
        return this.getSourceStorage().canAcceptSource(source);
    }

    public int transferSource(ISourceTile from, ISourceTile to) {
        int transferRate = this.getTransferRate(from, to);
        from.removeSource(transferRate);
        to.addSource(transferRate);
        return transferRate;
    }

    public int transferSource(ISourceCap from, ISourceCap to) {
        int transfer = to.receiveSource(from.extractSource(from.getMaxExtract(), true), true);
        if (transfer == 0) {
            return 0;
        }
        from.extractSource(transfer, false);
        to.receiveSource(transfer, false);
        return transfer;
    }

    public int getTransferRate(ISourceTile from, ISourceTile to) {
        return this.getTransferRate(from, to, from.getTransferRate());
    }

    public int getTransferRate(ISourceTile from, ISourceTile to, int fromTransferRate) {
        return Math.min(Math.min(fromTransferRate, from.getSource()), to.getMaxSource() - to.getSource());
    }

    public int transferSource(ISourceTile from, ISourceTile to, int fromTransferRate) {
        int transferRate = this.getTransferRate(from, to, fromTransferRate);
        if (transferRate == 0) {
            return 0;
        }
        from.removeSource(transferRate);
        to.addSource(transferRate);
        return transferRate;
    }

    @Override
    public ParticleColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(ParticleColor color) {
        this.color = color;
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        BlockFillContents fill = (BlockFillContents)pComponentInput.getOrDefault(DataComponentRegistry.BLOCK_FILL_CONTENTS, (Object)new BlockFillContents(0));
        this.source = fill.amount();
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.BLOCK_FILL_CONTENTS, (Object)new BlockFillContents(this.source));
    }
}

