/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRitual {
    public RitualBrazierTile tile;
    private RitualContext context;
    public RandomSource rand = RandomSource.create();
    public UUID playerUUID;

    public void tryTick(RitualBrazierTile tickingTile) {
        if (tickingTile == null || !this.getContext().isStarted || this.getContext().isDone) {
            return;
        }
        this.tile = tickingTile;
        this.tick();
    }

    @Nullable
    public BlockPos getPos() {
        return this.tile != null ? this.tile.getBlockPos() : null;
    }

    @Nullable
    public Level getWorld() {
        return this.tile != null ? this.tile.getLevel() : null;
    }

    public boolean canStart(@Nullable Player player) {
        return true;
    }

    public List<ItemStack> getConsumedItems() {
        return this.getContext().consumedItems;
    }

    public boolean canConsumeItem(ItemStack stack) {
        return false;
    }

    public void onItemConsumed(ItemStack stack) {
        this.getConsumedItems().add(stack.split(1));
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.getBlockPos());
    }

    public boolean didConsumeItem(ItemLike item) {
        for (ItemStack i : this.getConsumedItems()) {
            if (i.getItem() != item.asItem()) continue;
            return true;
        }
        return false;
    }

    public int itemConsumedCount(Predicate<ItemStack> stackPredicate) {
        int total = 0;
        for (ItemStack stack : this.getConsumedItems()) {
            if (!stackPredicate.test(stack)) continue;
            total += stack.getCount();
        }
        return total;
    }

    public List<String> getFormattedConsumedItems() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (ItemStack i : this.getConsumedItems()) {
            String name = i.getHoverName().getString();
            if (map.containsKey(name)) {
                map.put(name, (Integer)map.get(name) + 1);
                continue;
            }
            map.put(name, 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : map.keySet()) {
            list.add(s + " x " + String.valueOf(map.get(s)));
        }
        return list;
    }

    public void incrementProgress() {
        ++this.getContext().progress;
    }

    public int getProgress() {
        return this.getContext().progress;
    }

    public void onStart(@Nullable Player player) {
        this.getContext().isStarted = true;
        if (player != null) {
            this.playerUUID = player.getUUID();
        }
    }

    public boolean isRunning() {
        return this.getContext().isStarted && !this.getContext().isDone;
    }

    public boolean isDone() {
        return this.getContext().isDone;
    }

    public void setFinished() {
        this.getContext().isDone = true;
    }

    protected abstract void tick();

    public void onEnd() {
        this.getContext().isDone = true;
    }

    public String getName() {
        return Component.translatable((String)"ars_nouveau.tablet_of", (Object[])new Object[]{Component.translatable((String)("item." + this.getRegistryName().getNamespace() + "." + this.getRegistryName().getPath())).getString()}).getString();
    }

    public String getDescription() {
        return Component.translatable((String)this.getDescriptionKey()).getString();
    }

    public String getDescriptionKey() {
        return this.getRegistryName().getNamespace() + ".ritual_desc." + this.getRegistryName().getPath();
    }

    public int getSourceCost() {
        return 0;
    }

    public boolean consumesSource() {
        return this.getSourceCost() > 0;
    }

    public void setNeedsSource(boolean needMana) {
        this.getContext().needsSourceToRun = needMana;
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.getBlockPos());
    }

    public boolean needsSourceNow() {
        return this.getContext().needsSourceToRun;
    }

    public boolean takeSourceNow() {
        this.setNeedsSource(true);
        return this.tile.takeSource();
    }

    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        CompoundTag contextTag = new CompoundTag();
        this.getContext().write(provider, contextTag);
        tag.put("context", (Tag)contextTag);
    }

    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.setContext(RitualContext.read(provider, tag.getCompound("context")));
    }

    @NotNull
    public RitualContext getContext() {
        if (this.context == null) {
            this.context = new RitualContext();
        }
        return this.context;
    }

    public void setContext(RitualContext context) {
        this.context = context;
    }

    public abstract ResourceLocation getRegistryName();

    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(255), this.rand.nextInt(22), this.rand.nextInt(255));
    }

    public ParticleColor getOuterColor() {
        return this.getCenterColor();
    }

    public int getParticleIntensity() {
        return 10;
    }

    public String getLangName() {
        return "";
    }

    public String getLangDescription() {
        return "";
    }

    @Deprecated(since="4.11.0", forRemoval=true)
    public boolean canBeTraded() {
        return true;
    }

    public void onDestroy() {
    }

    public void onStatusChanged(boolean status) {
    }
}

