/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.registry;

import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;

public class AlakarkinosConversionRegistry {
    private static List<AlakarkinosRecipe> RECIPES = new ArrayList<AlakarkinosRecipe>();
    private static Set<Block> CONVERTABLE_BLOCKS = Set.of();
    private static Map<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>> CONVERTABLE_BLOCKS_MAP = new HashMap<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>>();

    public static List<AlakarkinosRecipe> getRecipes() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static void reloadAlakarkinosRecipes(RecipeManager recipeManager) {
        RECIPES = new ArrayList<AlakarkinosRecipe>();
        List<AlakarkinosRecipe> recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeRegistry.ALAKARKINOS_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        RECIPES.addAll(recipes);
        CONVERTABLE_BLOCKS = new HashSet<Block>();
        for (AlakarkinosRecipe recipe : RECIPES) {
            CONVERTABLE_BLOCKS.add(recipe.input());
        }
        CONVERTABLE_BLOCKS_MAP = new HashMap<Block, WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>>();
        for (AlakarkinosRecipe recipe : RECIPES) {
            WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>> list = CONVERTABLE_BLOCKS_MAP.getOrDefault(recipe.input(), (WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>)WeightedRandomList.create());
            ArrayList<WeightedEntry.Wrapper> modifiedList = new ArrayList<WeightedEntry.Wrapper>(list.unwrap());
            modifiedList.add(WeightedEntry.wrap((Object)recipe, (int)recipe.weight()));
            CONVERTABLE_BLOCKS_MAP.put(recipe.input(), (WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>>)WeightedRandomList.create(modifiedList));
        }
    }

    public static boolean isConvertable(Block block) {
        return CONVERTABLE_BLOCKS.contains(block);
    }

    @Nullable
    public static AlakarkinosRecipe getConversionResult(Block block, RandomSource random) {
        if (!AlakarkinosConversionRegistry.isConvertable(block)) {
            return null;
        }
        WeightedRandomList<WeightedEntry.Wrapper<AlakarkinosRecipe>> list = CONVERTABLE_BLOCKS_MAP.get(block);
        Optional entry = list.getRandom(random);
        return entry.map(WeightedEntry.Wrapper::data).orElse(null);
    }
}

