/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.ItemCasterProvider;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ICasterTool
extends IScribeable,
IDisplayMana,
ISpellHotkeyListener,
ItemCasterProvider {
    @Override
    default public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack tableStack) {
        ItemStack heldStack = player.getItemInHand(handIn);
        AbstractCaster<?> tableCaster = SpellCasterRegistry.from(tableStack);
        if (!(heldStack.getItem() instanceof SpellBook) && !(heldStack.getItem() instanceof SpellParchment) && heldStack.getItem() != ItemsRegistry.MANIPULATION_ESSENCE.asItem()) {
            return false;
        }
        if (tableCaster == null) {
            return false;
        }
        AbstractCaster<?> heldCaster = SpellCasterRegistry.from(heldStack);
        Spell spell = new Spell();
        if (heldStack.getItem() == ItemsRegistry.MANIPULATION_ESSENCE.asItem()) {
            String[] words = new String[]{"the", "elder", "scrolls", "klaatu", "berata", "niktu", "xyzzy", "bless", "curse", "light", "darkness", "fire", "air", "earth", "water", "hot", "dry", "cold", "wet", "ignite", "snuff", "embiggen", "twist", "shorten", "stretch", "fiddle", "destroy", "imbue", "galvanize", "enchant", "free", "limited", "range", "of", "towards", "inside", "sphere", "cube", "self", "other", "ball", "mental", "physical", "grow", "shrink", "demon", "elemental", "spirit", "animal", "creature", "beast", "humanoid", "undead", "fresh", "stale", "phnglui", "mglwnafh", "cthulhu", "rlyeh", "wgahnagl", "fhtagn", "baguette"};
            int numWords = world.random.nextInt(3) + 3;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < numWords; ++i) {
                sb.append(words[world.random.nextInt(words.length)]).append(" ");
            }
            ((AbstractCaster)((AbstractCaster)tableCaster.setHidden(true)).setHiddenRecipe(sb.toString())).saveToStack(tableStack);
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.spell_hidden"));
            return true;
        }
        if (heldCaster != null) {
            spell = heldCaster.getSpell();
            ((AbstractCaster)((AbstractCaster)((AbstractCaster)((AbstractCaster)tableCaster.setColor(heldCaster.getColor())).setFlavorText(heldCaster.getFlavorText())).setSpellName(heldCaster.getSpellName())).setSound(heldCaster.getCurrentSound())).saveToStack(tableStack);
        }
        if (this.isScribedSpellValid(tableCaster, player, handIn, tableStack, spell)) {
            Spell.Mutable mutableSpell = spell.mutable();
            this.scribeModifiedSpell(tableCaster, player, handIn, tableStack, mutableSpell);
            ((AbstractCaster)tableCaster.setSpell(mutableSpell.immutable())).saveToStack(tableStack);
            this.sendSetMessage(player);
            return true;
        }
        this.sendInvalidMessage(player);
        return false;
    }

    default public void sendSetMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.set_spell"));
    }

    default public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.invalid_spell"));
    }

    @Override
    @Nullable
    default public AbstractCaster<?> getSpellCaster(ItemStack stack) {
        return SpellCasterRegistry.from(stack);
    }

    default public void scribeModifiedSpell(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell.Mutable spell) {
    }

    default public boolean isScribedSpellValid(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.isValid();
    }

    default public void getInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip2, TooltipFlag flagIn) {
        AbstractCaster<?> caster = this.getSpellCaster(stack);
        if (caster == null) {
            return;
        }
        stack.addToTooltip(caster.getComponentType(), context, tooltip2::add, flagIn);
    }
}

