/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.entity;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.manmaed.petrock.entity.PREntityTypes;
import net.manmaed.petrock.item.PRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityPetRock
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.defineId(EntityPetRock.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected EntityPetRock(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.setTame(false, false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    protected void defineSynchedData(SynchedEntityData.Builder synceddata) {
        super.defineSynchedData(synceddata);
        synceddata.define(VARIANT_ID, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("rock_variant", this.getVariant().intValue());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains("rock_variant")) {
            this.setVariant(compoundTag.getInt("rock_variant"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
        this.playSound(SoundEvents.STONE_STEP, 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.STONE_BREAK;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.STONE_BREAK;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public void setTame(boolean tame1, boolean tame2) {
        super.setTame(tame1, tame2);
        if (tame1) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(2.0);
        }
    }

    public boolean isRockVariantChangeItem(Item item) {
        Item[] changeItems;
        for (Item itemloop : changeItems = new Item[]{Blocks.STONE.asItem(), Blocks.NETHERRACK.asItem(), Blocks.END_STONE.asItem(), Blocks.DEEPSLATE.asItem(), Blocks.DIORITE.asItem(), Blocks.GRANITE.asItem(), Blocks.ANDESITE.asItem(), Blocks.CLAY.asItem(), Blocks.BEDROCK.asItem()}) {
            if (item != itemloop) continue;
            return true;
        }
        return false;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack == ((Item)PRItems.STONEIUM.get()).getDefaultInstance();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        Level level = this.level();
        if (level.isClientSide) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || item == PRItems.STONEIUM.get() && !this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (item == PRItems.KIBBLE.get() && this.getHealth() < this.getMaxHealth()) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                this.heal(3.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.isRockVariantChangeItem(item)) {
                this.rightClickSetRockVariant(itemStack, player);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.mobInteract(player, hand);
                if ((!interactionresult.consumesAction() || this.isBaby()) && this.isOwnedBy((LivingEntity)player)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (item == PRItems.STONEIUM.get()) {
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setOrderedToSit(true);
                level.broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                level.broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        EntityPetRock petRock = new EntityPetRock((EntityType<? extends TamableAnimal>)((EntityType)PREntityTypes.PETROCK.get()), (Level)serverLevel);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            petRock.setOwnerUUID(uuid);
            petRock.setTame(true, true);
        }
        return petRock;
    }

    public void setVariant(Integer variant) {
        this.entityData.set(VARIANT_ID, (Object)variant);
    }

    public Integer getVariant() {
        return (Integer)this.entityData.get(VARIANT_ID);
    }

    public String getVariantName() {
        int type = this.getVariant();
        return switch (type) {
            case -1 -> "missingno";
            case 1 -> "nether";
            case 2 -> "end";
            case 3 -> "deepslate";
            case 4 -> "diorite";
            case 5 -> "granite";
            case 6 -> "andesite";
            case 7 -> "clay";
            case 8 -> "bedrock";
            case 9 -> "squidgy";
            default -> "stone";
        };
    }

    private void rightClickSetRockVariant(ItemStack itemStack, Player player) {
        Item item = itemStack.getItem();
        String itemName = item.toString();
        String regex = "(?<=:)[^:]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(itemName);
        String extractedName = "missingno";
        if (matcher.find()) {
            extractedName = matcher.group();
        }
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        switch (extractedName) {
            case "stone": {
                this.setVariant(0);
                break;
            }
            case "netherrack": {
                this.setVariant(1);
                break;
            }
            case "end_stone": {
                this.setVariant(2);
                break;
            }
            case "deepslate": {
                this.setVariant(3);
                break;
            }
            case "diorite": {
                this.setVariant(4);
                break;
            }
            case "granite": {
                this.setVariant(5);
                break;
            }
            case "andesite": {
                this.setVariant(6);
                break;
            }
            case "clay": {
                this.setVariant(7);
                break;
            }
            case "bedrock": {
                this.setVariant(8);
                break;
            }
            case "missingno": {
                this.setVariant(-1);
                break;
            }
            case "squidgy": {
                this.setVariant(9);
            }
        }
    }

    public void tick() {
        String customName;
        super.tick();
        if (this.getVariant() == null) {
            this.setVariant(0);
        }
        if (this.hasCustomName() && (customName = this.getCustomName().getString()).equals("Squidgy") && this.getVariant() != 9) {
            this.setVariant(9);
        }
    }
}

