/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.datagen;

import java.util.concurrent.CompletableFuture;
import net.manmaed.petrock.datagen.PRAdvancementProvider;
import net.manmaed.petrock.datagen.PRBlockTagsProvider;
import net.manmaed.petrock.datagen.PRItemTagsProvider;
import net.manmaed.petrock.datagen.PRLanguageProvider;
import net.manmaed.petrock.datagen.PRLootTabels;
import net.manmaed.petrock.datagen.PRRecipeProvider;
import net.manmaed.petrock.datagen.PRWorldGenProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="petrock", bus=EventBusSubscriber.Bus.MOD)
public class PRDataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PRBlockTagsProvider prBlockTagsProvider = new PRBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        generator.addProvider(true, (DataProvider)new PRRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)prBlockTagsProvider);
        generator.addProvider(true, (DataProvider)new PRItemTagsProvider(packOutput, lookupProvider, prBlockTagsProvider.contentsGetter(), fileHelper));
        generator.addProvider(true, (DataProvider)new PRLootTabels(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new PRWorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new PRAdvancementProvider(packOutput, lookupProvider, fileHelper));
        PRLanguageProvider.addTranslations(generator);
    }
}

