/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.polylib;

import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vswe.stevescarts.network.packets.PacketEntityData;
import vswe.stevescarts.polylib.DataEntity;

public class EntityData<T> {
    public static Logger LOGGER = LogManager.getLogger();
    private final DataEntity entity;
    private final AbstractDataStore<T> dataStore;
    private T previousValue;

    public EntityData(DataEntity entity, AbstractDataStore<T> dataStore) {
        this.entity = entity;
        this.dataStore = dataStore;
        this.previousValue = dataStore.get();
        entity.registerEntityData(this);
    }

    public T get() {
        return (T)this.dataStore.get();
    }

    private Entity getEntity() {
        return (Entity)this.entity;
    }

    public void set(T value) {
        this.set(value, false);
    }

    public void set(T value, boolean force) {
        if (this.getEntity().level() != null && this.getEntity().level().isClientSide()) {
            return;
        }
        this.dataStore.set(value);
        this.detectAndSend(force);
    }

    public AbstractDataStore<T> getStorage() {
        return this.dataStore;
    }

    public void detectAndSend() {
        this.detectAndSend(false);
    }

    public void detectAndSend(boolean force) {
        if (!(this.getEntity().level() instanceof ServerLevel) || this.dataStore.isSameValue(this.previousValue) && !force) {
            return;
        }
        this.previousValue = this.dataStore.get();
        int index = this.entity.getEntityDataList().indexOf(this);
        if (index == -1) {
            LOGGER.warn("Invalid entity data found on entity ()", (Object)this.entity);
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this.getEntity(), (CustomPacketPayload)new PacketEntityData(this.getEntity().getId(), index, this.dataStore), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void toBytes(RegistryFriendlyByteBuf buffer) {
        this.dataStore.toBytes(buffer);
    }

    public void fromBytes(RegistryFriendlyByteBuf buffer) {
        this.dataStore.fromBytes(buffer);
    }

    public void save(String name, CompoundTag tag, HolderLookup.Provider provider) {
        tag.put(name, this.dataStore.toTag(provider));
    }

    public void load(String name, CompoundTag tag, HolderLookup.Provider provider) {
        this.dataStore.fromTag(provider, tag.get(name));
    }
}

