/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.farms.ICropModule;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleTool;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotSeed;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.polylib.EntityData;

public abstract class ModuleFarmer
extends ModuleTool
implements ISuppliesModule {
    private ArrayList<ICropModule> plantModules;
    private int farming;
    private float farmAngle;
    private float rigAngle = -3.926991f;
    private final EntityData<Boolean> isFarming = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleFarmer(EntityMinecartModular cart) {
        super(cart);
    }

    protected abstract int getRange();

    public int getExternalRange() {
        return this.getRange();
    }

    @Override
    public void init() {
        super.init();
        this.plantModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ICropModule)) continue;
            this.plantModules.add((ICropModule)((Object)module));
        }
        this.plantModules.addAll(StevesCartsAPI.CROP_MODULES);
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.TOOLS.FARMER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSeed(this.getCart(), slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean work() {
        Level world = this.getCart().level();
        BlockPos next = this.getNextblock();
        for (int i = -this.getRange(); i <= this.getRange(); ++i) {
            for (int j = -this.getRange(); j <= this.getRange(); ++j) {
                BlockPos coord = next.offset(i, -1, j);
                if (this.farm(world, coord)) {
                    return true;
                }
                if (this.till(world, coord)) {
                    return true;
                }
                if (!this.plant(world, coord)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean till(Level world, BlockPos pos) {
        if (world.getBlockState(pos).is(BlockTags.DIRT) && world.getBlockState(pos.above()).isAir()) {
            if (this.doPreWork()) {
                this.startWorking(10);
                return true;
            }
            this.stopWorking();
            world.setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 3);
        }
        return false;
    }

    protected boolean plant(Level world, BlockPos pos) {
        int hasSeeds = -1;
        BlockState soilState = world.getBlockState(pos);
        Block soilblock = soilState.getBlock();
        if (soilblock != null) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                TriState state;
                BlockState cropblock;
                if (this.getStack(i).isEmpty() || !this.isSeedValidHandler(this.getStack(i)) || (cropblock = this.getCropFromSeedHandler(this.getStack(i))) == null || !world.getBlockState(pos.above()).isAir() || !(state = soilblock.canSustainPlant(soilState, (BlockGetter)world, pos, Direction.UP, cropblock)).isTrue() && !state.isDefault()) continue;
                hasSeeds = i;
                break;
            }
            if (hasSeeds != -1) {
                if (this.doPreWork()) {
                    this.startWorking(25);
                    return true;
                }
                this.stopWorking();
                BlockState cropblock2 = this.getCropFromSeedHandler(this.getStack(hasSeeds));
                world.setBlock(pos.above(), cropblock2, 3);
                ItemStack stack = this.getStack(hasSeeds);
                stack.shrink(1);
                if (this.getStack(hasSeeds).getCount() <= 0) {
                    this.setStack(hasSeeds, ItemStack.EMPTY);
                }
            }
        }
        return false;
    }

    protected boolean farm(Level world, BlockPos pos) {
        EntityMinecartModular cart = this.getCart();
        if (!this.isBroken()) {
            pos = pos.above();
            BlockState blockState = world.getBlockState(pos);
            Block block = blockState.getBlock();
            if (this.isReadyToHarvestHandler(world, pos)) {
                if (this.doPreWork()) {
                    int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
                    int workingtime = (int)((double)this.getBaseFarmingTime() / Math.pow(1.3f, efficiency));
                    this.setFarming(workingtime * 4);
                    this.startWorking(workingtime);
                    return true;
                }
                this.stopWorking();
                int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.ORIGIN, (Object)this.getCart().position());
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity != null) {
                    builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
                }
                List stuff = blockState.getDrops(builder);
                for (ItemStack iStack : stuff) {
                    cart.addItemToChest(iStack);
                    if (iStack.getCount() == 0) continue;
                    ItemEntity entityitem = new ItemEntity(world, (double)cart.x(), (double)cart.y(), (double)cart.z(), iStack);
                    world.addFreshEntity((Entity)entityitem);
                }
                world.removeBlock(pos, false);
                this.damageTool(3);
            }
        }
        return false;
    }

    protected int getBaseFarmingTime() {
        return 25;
    }

    public boolean isSeedValidHandler(@Nonnull ItemStack seed) {
        return seed.is(Tags.Items.SEEDS) || seed.is(Tags.Items.CROPS);
    }

    protected BlockState getCropFromSeedHandler(@Nonnull ItemStack seed) {
        Block cropBlock = Block.byItem((Item)seed.getItem());
        if (cropBlock == null) {
            return null;
        }
        if (cropBlock instanceof CropBlock) {
            CropBlock cropsBlock = (CropBlock)cropBlock;
            return cropsBlock.defaultBlockState();
        }
        return null;
    }

    protected boolean isReadyToHarvestHandler(Level world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropsBlock = (CropBlock)block;
            return cropsBlock.isMaxAge(world.getBlockState(pos));
        }
        return false;
    }

    public float getFarmAngle() {
        return this.farmAngle;
    }

    public float getRigAngle() {
        return this.rigAngle;
    }

    private void setFarming(int val) {
        this.farming = val;
        this.isFarming.set(val > 0);
    }

    protected boolean isFarming() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsFarming();
        }
        return this.getCart().isEngineBurning() && this.isFarming.get() != false;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().level().isClientSide) {
            this.setFarming(this.farming - 1);
        } else {
            float up = -3.926991f;
            float down = (float)(-Math.PI);
            boolean flag = this.isFarming();
            if (flag) {
                if (this.rigAngle < (float)(-Math.PI)) {
                    this.rigAngle += 0.1f;
                    if (this.rigAngle > (float)(-Math.PI)) {
                        this.rigAngle = (float)(-Math.PI);
                    }
                } else {
                    this.farmAngle = (float)((double)(this.farmAngle + 0.15f) % (Math.PI * 2));
                }
            } else if (this.rigAngle > -3.926991f) {
                this.rigAngle -= 0.075f;
                if (this.rigAngle < -3.926991f) {
                    this.rigAngle = -3.926991f;
                }
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || !this.isSeedValidHandler(item)) continue;
            return true;
        }
        return false;
    }
}

