/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.storages.tanks;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.modules.template.ModuleStorage;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotLiquidInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.polylib.EntityData;
import vswe.stevescarts.polylib.StringData;

public class ModuleTank
extends ModuleStorage
implements IFluidTank,
ITankHolder {
    protected SCTank tank;
    private int tick;
    protected int[] tankBounds;
    private final EntityData<String> fluidName = new EntityData<String>(this.getCart(), new StringData(""));
    private final EntityData<Integer> fluidAmount = new EntityData(this.getCart(), new IntData(-1));
    private final EntityData<Boolean> locked = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleTank(EntityMinecartModular cart) {
        super(cart);
        this.tankBounds = new int[]{35, 20, 36, 51};
        this.tank = new SCTank(this, this.getTankSize(), 0);
    }

    protected int getTankSize() {
        return 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotLiquidInput(this.getCart(), this.tank, -1, slotId, 8 + x * 18, 24 + y * 24);
        }
        return new SlotLiquidOutput(this.getCart(), slotId, 8 + x * 18, 24 + y * 24);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int getInventoryWidth() {
        return 1;
    }

    @Override
    public int getInventoryHeight() {
        return 2;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 80;
    }

    public boolean hasVisualTank() {
        return true;
    }

    @Override
    public void update() {
        super.update();
        if (this.tick-- <= 0) {
            this.tick = 5;
            if (!this.getCart().level().isClientSide) {
                this.tank.containerTransfer();
            } else if (!this.isPlaceholder()) {
                if (this.fluidName.get().isEmpty()) {
                    this.tank.setFluid(FluidStack.EMPTY);
                } else {
                    try {
                        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)this.fluidName.get().toLowerCase(Locale.ROOT)));
                        if (fluid != null && fluid != Fluids.EMPTY) {
                            this.tank.setFluid(new FluidStack(fluid, this.fluidAmount.get().intValue()));
                        }
                    }
                    catch (Exception e) {
                        StevesCarts.LOGGER.error("Failed to load fluid from dw");
                        StevesCarts.LOGGER.error((Object)e);
                    }
                }
            }
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.tank.setFluid(fluidStack);
    }

    @Override
    @Nonnull
    public ItemStack getInputContainer(int tankid) {
        return this.getStack(0);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.setStack(0, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @Nonnull ItemStack item) {
        this.addStack(1, item);
    }

    @Override
    public void onFluidUpdated(int tankid) {
        if (this.getCart().level().isClientSide) {
            return;
        }
        this.updateData();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.tank.drawFluid(guiGraphics, gui, this.tankBounds[0], this.tankBounds[1]);
        ResourceHelper.bindResource("/gui/tank.png");
        this.drawImage(guiGraphics, gui, this.tankBounds, 0, 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, this.getTankInfo(), x, y, this.tankBounds);
    }

    protected String getTankInfo() {
        Object str = this.tank.getMouseOver();
        if (this.locked.get().booleanValue()) {
            str = (String)str + "\n\n" + Localization.MODULES.TANKS.LOCKED.translate(new String[0]) + "\n" + Localization.MODULES.TANKS.UNLOCK.translate(new String[0]);
        } else if (!this.tank.getFluid().isEmpty()) {
            str = (String)str + "\n\n" + Localization.MODULES.TANKS.LOCK.translate(new String[0]);
        }
        return str;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid().isEmpty() ? FluidStack.EMPTY : this.tank.getFluid().copy();
    }

    public int getCapacity() {
        return this.getTankSize();
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    @Override
    protected void save(CompoundTag tag, int id, HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (!this.tank.getFluid().isEmpty()) {
            this.tank.getFluid().save(provider, (Tag)compound);
        }
        tag.put(this.generateNBTName("Fluid", id), (Tag)compound);
        this.locked.save(this.generateNBTName("Locked", id), tag, provider);
    }

    @Override
    protected void load(CompoundTag tag, int id, HolderLookup.Provider provider) {
        FluidStack fluidStack = FluidStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound(this.generateNBTName("Fluid", id))).orElse(FluidStack.EMPTY);
        this.tank.setFluid(fluidStack);
        this.locked.load(this.generateNBTName("Locked", id), tag, provider);
        this.updateData();
    }

    protected void updateData() {
        this.fluidName.set(this.tank.getFluid().isEmpty() ? "" : this.getFluidName(this.tank.getFluid().getFluid()));
        this.fluidAmount.set(this.tank.getFluid().isEmpty() ? -1 : this.tank.getFluid().getAmount());
    }

    public String getFluidName(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid).toString();
    }

    public float getFluidRenderHeight() {
        if (this.tank.getFluid().isEmpty()) {
            return 0.0f;
        }
        return this.tank.getFluidAmount() / this.getTankSize();
    }

    public boolean isCompletelyFilled() {
        return !this.getFluid().isEmpty() && this.getFluidAmount() >= this.getTankSize();
    }

    public boolean isCompletelyEmpty() {
        return this.getFluid().isEmpty() || this.getFluidAmount() == 0;
    }

    public int getFluidAmount() {
        return this.getFluid().isEmpty() ? 0 : this.tank.getFluidAmount();
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (!this.getFluid().isEmpty() || this.locked.get().booleanValue()) {
            this.setLocked(this.locked.get() == false);
            if (!this.locked.get().booleanValue() && !this.tank.getFluid().isEmpty() && this.tank.getFluid().getAmount() <= 0) {
                this.tank.setFluid(FluidStack.EMPTY);
                this.updateData();
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.tank.isLocked() ? 1 : 0));
        this.updateData();
    }

    private void setLocked(boolean val) {
        if (!this.isPlaceholder()) {
            this.locked.set(val);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.tankBounds)) {
            byte data = (byte)button;
            if (Screen.hasShiftDown()) {
                data = (byte)(data | 2);
            }
            this.sendPacket(0, data);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, int tankid, AbstractContainerScreen<?> gui, TextureAtlasSprite sprite, int targetX, int targetY, int width, int height) {
        this.drawImage(guiGraphics, (GuiMinecart)gui, sprite, targetX, targetY, width, height);
    }
}

