/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.BoolArrayData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModSerializers;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;
import vswe.stevescarts.polylib.EntityData;

public class ModuleDrillIntelligence
extends ModuleAddon {
    private ModuleDrill drill;
    private boolean hasHeightController;
    private int guiW = -1;
    private int guiH = -1;
    private boolean clickedState;
    private boolean clicked;
    private int lastId;
    private final EntityData<ModSerializers.BoolArray> disabledArray = new EntityData<ModSerializers.BoolArray>(this.getCart(), new BoolArrayData(new ModSerializers.BoolArray(this.getDrillWidth() * this.getDrillHeight())));

    public ModuleDrillIntelligence(EntityMinecartModular cart) {
        super(cart);
    }

    public ModSerializers.BoolArray getDisabledArray() {
        return this.isPlaceholder() ? new ModSerializers.BoolArray(256) : this.disabledArray.get();
    }

    public void setDisabledArray(ModSerializers.BoolArray array) {
        this.disabledArray.set(array);
        this.disabledArray.detectAndSend(true);
    }

    @Override
    public void preInit() {
        super.preInit();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrill) {
                this.drill = (ModuleDrill)module;
                continue;
            }
            if (!(module instanceof ModuleHeightControl)) continue;
            this.hasHeightController = true;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    private int getDrillWidth() {
        if (this.drill == null) {
            return 0;
        }
        return this.drill.getAreaWidth();
    }

    private int getDrillHeight() {
        if (this.drill == null) {
            return 0;
        }
        return this.drill.getAreaHeight() + (this.hasHeightController ? 2 : 0);
    }

    @Override
    public int guiWidth() {
        if (this.guiW == -1) {
            this.guiW = Math.max(15 + this.getDrillWidth() * 10 + 5, 93);
        }
        return this.guiW;
    }

    @Override
    public int guiHeight() {
        if (this.guiH == -1) {
            this.guiH = 20 + this.getDrillHeight() * 10 + 5;
        }
        return this.guiH;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/intelligence.png");
        int w = this.getDrillWidth();
        int h = this.getDrillHeight();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int[] rect = this.getSettingRect(i, j);
                int maxY = (this.getDrillHeight() / 2 - 1 - (Integer)SCConfig.COMMON.drillSize.get()) * 2;
                int srcX = !this.hasHeightController || j != maxY && j != h - 1 ? 0 : 8;
                int srcY = 0;
                this.drawImage(guiGraphics, gui, rect, srcX, srcY);
                if (this.isRestricted(j * w + i)) {
                    srcX = 16;
                    srcY = 8;
                    this.drawImage(guiGraphics, gui, rect, srcX, srcY);
                } else if (this.isActive(j * w + i)) {
                    srcX = this.isLocked(j * w + i) ? 8 : 0;
                    srcY = 8;
                    this.drawImage(guiGraphics, gui, rect, srcX, srcY);
                }
                srcX = this.inRect(x, y, rect) ? 8 : 0;
                srcY = 16;
                this.drawImage(guiGraphics, gui, rect, srcX, srcY);
            }
        }
    }

    public boolean isActive(int x, int y, int offset, boolean direction) {
        y = this.getDrillHeight() - 1 - y;
        if (this.hasHeightController) {
            y -= offset;
        }
        if (!direction) {
            x = this.getDrillWidth() - 1 - x;
        }
        return this.isActive(y * this.getDrillWidth() + x);
    }

    private boolean isActive(int id) {
        ModSerializers.BoolArray array = this.getDisabledArray();
        return !this.isRestricted(id) && (this.isLocked(id) || !array.get(id));
    }

    private boolean isLocked(int id) {
        int x = id % this.getDrillWidth();
        int y = id / this.getDrillWidth();
        return (y == this.getDrillHeight() - 1 || this.hasHeightController && y == this.getDrillHeight() - 2) && x == (this.getDrillWidth() - 1) / 2;
    }

    private boolean isRestricted(int id) {
        int size = (Integer)SCConfig.COMMON.drillSize.get();
        int centerX = (this.getDrillWidth() - 1) / 2;
        int x = id % this.getDrillWidth();
        int y = this.getDrillHeight() - id / this.getDrillWidth() - 3;
        int maxHeight = size * 2 + 1 - (this.hasHeightController ? 1 : 3);
        boolean validX = x > centerX + size || x < centerX - size;
        boolean validY = y > maxHeight;
        return validX || validY;
    }

    private void swapActiveness(int id) {
        if (!this.isRestricted(id) && !this.isLocked(id)) {
            ModSerializers.BoolArray array;
            array.set(id, !(array = this.getDisabledArray()).get(id));
            this.setDisabledArray(array);
        }
    }

    private int[] getSettingRect(int x, int y) {
        return new int[]{15 + x * 10, 20 + y * 10, 8, 8};
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        int w = this.getDrillWidth();
        int h = this.getDrillHeight();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int[] rect = this.getSettingRect(i, j);
                String str = this.isRestricted(j * w + i) ? Localization.MODULES.ADDONS.RESTRICTED_INTELLIGENCE.translate(new String[0]) : (this.isLocked(j * w + i) ? Localization.MODULES.ADDONS.LOCKED.translate(new String[0]) : Localization.MODULES.ADDONS.CHANGE_INTELLIGENCE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT_INTELLIGENCE.translate(this.isActive(j * w + i) ? "0" : "1"));
                this.drawStringOnMouseOver(guiGraphics, gui, str, x, y, rect);
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        int maxDrillWidth = 9;
        int maxDrillHeight = 9;
        return (int)Math.ceil(6.1875);
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.swapActiveness(data[0]);
        }
    }

    @Override
    protected void save(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        tagCompound.putByteArray(this.generateNBTName("enabled_data", id), this.getDisabledArray().getBytes());
    }

    @Override
    protected void load(CompoundTag tagCompound, int id, HolderLookup.Provider provider) {
        int baseSize = this.getDrillWidth() * this.getDrillHeight();
        ModSerializers.BoolArray loaded = ModSerializers.BoolArray.fromBytes(tagCompound.getByteArray(this.generateNBTName("enabled_data", id)));
        if (loaded.getBytes().length * 8 >= baseSize) {
            this.setDisabledArray(loaded);
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (button == -1 && this.clicked) {
            int w = this.getDrillWidth();
            int h = this.getDrillHeight();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int[] rect;
                    if (this.lastId == j * w + i || this.isActive(j * w + i) != this.clickedState || !this.inRect(x, y, rect = this.getSettingRect(i, j))) continue;
                    this.lastId = j * w + i;
                    this.sendPacket(0, (byte)(j * w + i));
                    return;
                }
            }
        }
        if (button == 0) {
            this.clicked = false;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            int w = this.getDrillWidth();
            int h = this.getDrillHeight();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int[] rect = this.getSettingRect(i, j);
                    if (!this.inRect(x, y, rect)) continue;
                    this.clicked = true;
                    this.clickedState = this.isActive(j * w + i);
                    this.lastId = j * w + i;
                    this.sendPacket(0, (byte)(j * w + i));
                    return;
                }
            }
        }
    }
}

