/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class ResourceHelper {
    private static HashMap<String, ResourceLocation> resources = new HashMap();
    private static HashMap<String, ResourceLocation> pathResources = new HashMap();

    public static ResourceLocation getResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)("textures" + path.toLowerCase()));
    }

    public static ResourceLocation getResourceFromPath(String path) {
        return ResourceLocation.withDefaultNamespace((String)("textures" + path.toLowerCase()));
    }

    public static void bindResource(ResourceLocation resource) {
        if (resource != null) {
            ResourceLocation lowercaseLocation = ResourceLocation.fromNamespaceAndPath((String)resource.getNamespace(), (String)resource.getPath());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)lowercaseLocation);
        }
    }

    public static void bindResource(String path) {
        if (resources.containsKey(path)) {
            ResourceHelper.bindResource(resources.get(path));
        } else {
            ResourceLocation resource = ResourceHelper.getResource(path);
            resources.put(path, resource);
            ResourceHelper.bindResource(resource);
        }
    }

    public static void bindResourcePath(String path) {
        if (pathResources.containsKey(path)) {
            ResourceHelper.bindResource(pathResources.get(path));
        } else {
            ResourceLocation resource = ResourceHelper.getResourceFromPath(path);
            pathResources.put(path, resource);
            ResourceHelper.bindResource(resource);
        }
    }
}

