/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import vswe.stevescarts.helpers.AnimationRig;

public class AnimationRigVal {
    private float val;
    private final float min;
    private final float max;
    private float speed;
    private AnimationRigVal down;
    private AnimationRigVal up;

    public AnimationRigVal(AnimationRig rig, float min, float max, float speed) {
        this.min = min;
        this.max = max;
        this.speed = speed;
        this.val = this.min;
        rig.addVal(this);
    }

    public void setUp(AnimationRigVal up) {
        this.up = up;
    }

    public void setDown(AnimationRigVal down) {
        this.down = down;
    }

    public void setUpAndDown(AnimationRigVal up) {
        this.setUp(up);
        up.setDown(this);
    }

    public float getVal() {
        return this.val;
    }

    public void setAnimDone() {
        this.val = this.max;
    }

    public boolean update(boolean goDown) {
        float target;
        float f = target = goDown ? this.min : this.max;
        if (target == this.val) {
            return false;
        }
        if (this.val < target) {
            this.val += this.speed;
            if (this.val > target) {
                this.val = target;
            }
        } else if (this.val > target) {
            this.val -= this.speed;
            if (this.val < target) {
                this.val = target;
            }
        }
        if (goDown) {
            if (this.down != null) {
                this.down.update(true);
            }
        } else if (this.up != null) {
            this.up.update(false);
        }
        return true;
    }

    public void setSpeedToSync(AnimationRigVal syncTo, boolean invert) {
        this.speed = (this.max - this.min) / ((syncTo.max - syncTo.min) / syncTo.speed);
        if (invert) {
            this.speed *= -1.0f;
        }
    }
}

