/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.ArrayList;
import java.util.Objects;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.init.ModContainers;

public class ContainerDistributor
extends ModularGuiContainerMenu {
    private final TileEntityDistributor distributor;
    public ArrayList<DataSync<DistributorSide>> sideSyncs = new ArrayList();

    public ContainerDistributor(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityDistributor)Objects.requireNonNull(Minecraft.getInstance().level.getBlockEntity(packetBuffer.readBlockPos())));
    }

    public ContainerDistributor(int id, Inventory invPlayer, TileEntityDistributor distributor) {
        super((MenuType)ModContainers.CONTAINER_DISTRIBUTOR.get(), id, invPlayer);
        this.distributor = distributor;
        ArrayList<DistributorSide> sides = distributor.getSides();
        int i = 0;
        while (i < sides.size()) {
            DistributorSide side = sides.get(i);
            int finalI = i++;
            this.sideSyncs.add((DataSync<DistributorSide>)new DataSync((ModularGuiContainerMenu)this, (AbstractDataStore)new SideData(side), () -> (DistributorSide)sides.get(finalI)));
        }
    }

    public TileEntityDistributor getDistributor() {
        return this.distributor;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public static class SideData
    extends AbstractDataStore<DistributorSide> {
        public SideData(DistributorSide initial) {
            super((Object)initial.copy().setData(0));
        }

        public DistributorSide set(DistributorSide value) {
            if (!Objects.equals(value.getData(), ((DistributorSide)this.value).getData()) && this.validator.test(value)) {
                this.value = value.copy();
                this.markDirty();
            }
            return (DistributorSide)this.value;
        }

        public void toBytes(RegistryFriendlyByteBuf buf) {
            buf.writeVarInt(((DistributorSide)this.value).getData());
        }

        public void fromBytes(RegistryFriendlyByteBuf buf) {
            ((DistributorSide)this.value).setData(buf.readVarInt());
        }

        public Tag toTag(HolderLookup.Provider provider) {
            return IntTag.valueOf((int)((DistributorSide)this.value).getData());
        }

        public void fromTag(HolderLookup.Provider provider, Tag tag) {
            ((DistributorSide)this.value).setData(((IntTag)tag).getAsInt());
        }

        public boolean isSameValue(DistributorSide newValue) {
            return ((DistributorSide)this.value).getData() == newValue.getData();
        }
    }
}

