/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models.workers.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.modules.workers.tools.ModuleWoodcutter;

public class ModelWoodCutter
extends ModelCartbase {
    private static ModelPart[] anchors;

    public ModelWoodCutter(ResourceLocation resource) {
        super(null, resource);
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        anchors = new ModelPart[5];
        for (int i = -2; i <= 2; ++i) {
            PartDefinition anchor = modelPartData.addOrReplaceChild("anchor" + i, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            anchor.addOrReplaceChild("side" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -1.5f, -0.5f, 7.0f, 3.0f, 1.0f), PartPose.offset((float)-13.0f, (float)0.0f, (float)(i * 2)));
            anchor.addOrReplaceChild("tip" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
            ModelWoodCutter.anchors[i + 2] = anchor.bake(16, 8);
        }
    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, int colour) {
        for (ModelPart anchor : anchors) {
            anchor.render(poseStack, vertexConsumers, light, overlay, colour);
        }
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        super.applyEffects(module, matrixStack, rtb, yaw, pitch, roll);
        float commonAngle = module == null ? 0.0f : ((ModuleWoodcutter)module).getCutterAngle();
        for (int i = 0; i < anchors.length; ++i) {
            float specificAngle = i % 2 == 0 ? (float)Math.sin(commonAngle) : (float)Math.cos(commonAngle);
            ModelWoodCutter.anchors[i].x = specificAngle * 1.25f;
        }
    }
}

