/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.upgrades.BaseUpgradeEffect;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.Transposer;

public class BlockRailAdvDetector
extends BaseRailBlock {
    public static final MapCodec<BlockRailAdvDetector> CODEC = BlockRailAdvDetector.simpleCodec(BlockRailAdvDetector::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;

    public BlockRailAdvDetector() {
        this(BlockBehaviour.Properties.of().noCollission().strength(0.7f).sound(SoundType.METAL));
    }

    private BlockRailAdvDetector(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, WATERLOGGED});
    }

    @NotNull
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(BlockState state, Level world, BlockPos pos, AbstractMinecart entityMinecart) {
        if (world.isClientSide || !(entityMinecart instanceof EntityMinecartModular)) {
            return;
        }
        EntityMinecartModular cart = (EntityMinecartModular)entityMinecart;
        if (!this.isCartReadyForAction(cart, pos)) {
            return;
        }
        int side = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntityUpgrade upgrade;
                BlockEntity tileentity;
                if (Math.abs(i) == Math.abs(j)) continue;
                BlockPos offset = pos.offset(i, 0, j);
                Block block = world.getBlockState(offset).getBlock();
                if (block == ModBlocks.CARGO_MANAGER.get() || block == ModBlocks.LIQUID_MANAGER.get()) {
                    TileEntityManager manager;
                    tileentity = world.getBlockEntity(offset);
                    if (tileentity instanceof TileEntityManager && (manager = (TileEntityManager)tileentity).getCart() == null) {
                        manager.setCart(cart);
                        manager.setSide(side);
                    }
                    return;
                }
                if (block == ModBlocks.MODULE_TOGGLER.get()) {
                    tileentity = world.getBlockEntity(offset);
                    if (tileentity instanceof TileEntityActivator) {
                        TileEntityActivator activator = (TileEntityActivator)tileentity;
                        boolean isOrange = false;
                        if (cart.temppushX == 0.0 == (cart.temppushZ == 0.0)) continue;
                        if (i == 0) {
                            isOrange = j == -1 ? cart.temppushX < 0.0 : cart.temppushX > 0.0;
                        } else if (j == 0) {
                            isOrange = i == -1 ? cart.temppushZ > 0.0 : cart.temppushZ < 0.0;
                        }
                        boolean isBlueBerry = false;
                        activator.handleCart(cart, isOrange);
                        cart.releaseCart();
                    }
                    return;
                }
                if (block instanceof BlockUpgrade && (upgrade = (TileEntityUpgrade)(tileentity = world.getBlockEntity(offset))) != null && upgrade.getUpgrade() != null) {
                    for (BaseUpgradeEffect effect : upgrade.getUpgrade().getEffects()) {
                        if (!(effect instanceof Transposer)) continue;
                        Transposer transposer = (Transposer)effect;
                        if (upgrade.getMaster() == null) continue;
                        for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                            if (tile.getUpgrade() == null) continue;
                            for (BaseUpgradeEffect effect2 : tile.getUpgrade().getEffects()) {
                                if (!(effect2 instanceof Disassemble)) continue;
                                Disassemble disassembler = (Disassemble)effect2;
                                if (!tile.getItem(0).isEmpty()) continue;
                                tile.setItem(0, ModuleData.createModularCart(cart));
                                for (int p = 0; p < cart.getContainerSize(); ++p) {
                                    ItemStack item = cart.removeItem(p, 64);
                                    if (item.isEmpty()) continue;
                                    upgrade.getMaster().puke(item);
                                }
                                cart.remove(Entity.RemovalReason.DISCARDED);
                                return;
                            }
                        }
                    }
                }
                ++side;
            }
        }
    }

    private boolean isCartReadyForAction(EntityMinecartModular cart, BlockPos pos) {
        return cart.disabledPos != null && cart.disabledPos.equals((Object)pos) && cart.isDisabled();
    }
}

