/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.Logging;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class SCConfig {
    public static final String CATEGORY_GENERAL = "general";
    static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Loaded Steves config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        LogManager.getLogger().debug(Logging.FORGEMOD, "Steves Carts config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<Boolean> useArcadeSounds;
        public final ModConfigSpec.ConfigValue<Boolean> useArcadeMobSounds;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client General settings").push(SCConfig.CATEGORY_GENERAL);
            builder.pop();
            this.useArcadeSounds = builder.comment("Enable arcade machine sounds").define("useArcadeSounds", true);
            this.useArcadeMobSounds = builder.comment("Enable mob sounds for arcade machines").define("useArcadeMobSounds", true);
        }
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Boolean> disableTimedCrafting;
        public final ModConfigSpec.ConfigValue<Integer> maxDynamites;
        public final ModConfigSpec.ConfigValue<Integer> drillSize;
        public final ModConfigSpec.ConfigValue<Integer> basic_solar_production;
        public final ModConfigSpec.ConfigValue<Integer> compact_solar_production;
        public final ModConfigSpec.ConfigValue<Integer> standard_solar_production;
        public final ModConfigSpec.ConfigValue<Boolean> allowCartToRunWithRepairItems;
        public final ModConfigSpec.ConfigValue<String> woodcutterRepairDiamond;
        public final ModConfigSpec.ConfigValue<String> woodcutterRepairHardened;
        public final ModConfigSpec.ConfigValue<String> woodcutterRepairNetherite;
        public final ModConfigSpec.ConfigValue<String> drillRepairIron;
        public final ModConfigSpec.ConfigValue<String> drillRepairDiamond;
        public final ModConfigSpec.ConfigValue<String> drillRepairHardened;
        public final ModConfigSpec.ConfigValue<String> farmerRepairDiamond;
        public final ModConfigSpec.ConfigValue<Boolean> assemblerInsertFuel;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push(SCConfig.CATEGORY_GENERAL);
            builder.pop();
            this.disableTimedCrafting = builder.comment("Disabled timed crafting").define("disableTimedCrafting", false);
            this.maxDynamites = builder.comment("The max amount of dynamites that can be held").define("maxDynamites", (Object)50);
            this.drillSize = builder.comment("Max drill size").define("drillSize", (Object)4);
            this.basic_solar_production = builder.comment("The amount of power the basic solar module will produce").define("basicSolarProduction", (Object)10);
            this.compact_solar_production = builder.comment("The amount of power the compact solar module will produce").define("compactSolarProduction", (Object)20);
            this.standard_solar_production = builder.comment("The amount of power the standard solar module will produce").define("standardSolarProduction", (Object)20);
            this.woodcutterRepairDiamond = builder.comment("Repair item for Diamond Woodcutter").define("woodcutterRepairDiamond", (Object)"minecraft:diamond");
            this.woodcutterRepairHardened = builder.comment("Repair item for Hardened Woodcutter").define("woodcutterRepairHardened", (Object)"stevescarts:component_reinforced_metal");
            this.woodcutterRepairNetherite = builder.comment("Repair item for Netherite Woodcutter").define("woodcutterRepairNetherite", (Object)"minecraft:netherite_ingot");
            this.drillRepairIron = builder.comment("Repair item for Iron Drill").define("drillRepairIron", (Object)"minecraft:iron_ingot");
            this.drillRepairDiamond = builder.comment("Repair item for Diamond Drill").define("drillRepairDiamond", (Object)"minecraft:diamond");
            this.drillRepairHardened = builder.comment("Repair item for Hardened Drill").define("drillRepairHardened", (Object)"stevescarts:component_reinforced_metal");
            this.farmerRepairDiamond = builder.comment("Repair item for Diamond farmer").define("farmerRepairDiamond", (Object)"minecraft:diamond");
            this.allowCartToRunWithRepairItems = builder.comment("Allow carts to run with items in the tool repair slot").define("allowCartToRunWithRepairItems", false);
            this.assemblerInsertFuel = builder.comment("Allow fuel to be auto inserted into the cart assembler").define("assemblerInsertFuel", false);
        }
    }
}

