/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.init.IModBase;

public final class ConfigurablePropertyData<T> {
    public final IModBase mod;
    public final String category;
    public final String name;
    public final T defaultValue;
    public final String comment;
    public final boolean isCommandable;
    public final ModConfigLocation configLocation;
    public final Field field;
    public final boolean requiresWorldRestart;
    public final boolean requiresMcRestart;
    public final boolean showInGui;
    public final int minValue;
    public final int maxValue;
    private Supplier<T> configProperty;
    private Consumer<T> configPropertyUpdater;

    public ConfigurablePropertyData(IModBase mod, String category, String name, T defaultValue, String comment, boolean isCommandable, ModConfigLocation configLocation, Field field, boolean requiresWorldRestart, boolean requiresMcRestart, boolean showInGui, int minValue, int maxValue) {
        this.mod = mod;
        this.category = category;
        this.name = name;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.isCommandable = isCommandable;
        this.field = field;
        this.configLocation = configLocation;
        this.requiresWorldRestart = requiresWorldRestart;
        this.requiresMcRestart = requiresMcRestart;
        this.showInGui = showInGui;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setConfigProperty(Supplier<T> configProperty, Consumer<T> configPropertyUpdater) {
        this.configProperty = configProperty;
        this.configPropertyUpdater = configPropertyUpdater;
    }

    public Supplier<T> getConfigProperty() {
        return this.configProperty;
    }

    public Consumer<T> getConfigPropertyUpdater() {
        return this.configPropertyUpdater;
    }

    public boolean isCommandable() {
        return this.isCommandable;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public ModConfigLocation getConfigLocation() {
        return this.configLocation;
    }

    public String getLanguageKey() {
        return "config." + this.mod.getModId() + "." + this.name.replaceAll("\\s", "");
    }

    public void saveToField() {
        try {
            this.field.set(null, this.configProperty.get());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

