/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.slot;

import java.util.Comparator;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.menu.slot.AbstractFakeSlot;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CraftMatrixFakeSlot
extends AbstractFakeSlot {
    private static final float ITEM_SWITCH_TIME = 40.0f;
    private final NonNullList<ItemStack> visibleStacks = NonNullList.create();
    private int ingredientIndex;
    private Ingredient ingredient;
    private float variantTimePassed;
    private int currentVariantIndex;
    private boolean isLocked;
    private boolean missing = true;

    public CraftMatrixFakeSlot(Container container, int slotId, int x, int y) {
        super(container, slotId, x, y);
    }

    public void setIngredient(int ingredientIndex, Ingredient ingredient, ItemStack lockedInput) {
        ItemStack effectiveLockedInput;
        this.ingredientIndex = ingredientIndex;
        Ingredient previousIngredient = this.ingredient;
        ItemStack itemStack = effectiveLockedInput = this.isLocked ? this.getItem() : ItemStack.EMPTY;
        if (!lockedInput.isEmpty()) {
            effectiveLockedInput = lockedInput;
        }
        this.visibleStacks.clear();
        this.ingredient = ingredient;
        for (ItemStack itemStack2 : ingredient.getItems()) {
            if (itemStack2.isEmpty()) continue;
            itemStack2.setCount(1);
            this.visibleStacks.add((Object)itemStack2);
        }
        this.visibleStacks.sort(Comparator.comparing(it -> Balm.getRegistries().getKey(it.getItem()).toString()));
        this.variantTimePassed = 0.0f;
        this.currentVariantIndex = previousIngredient != ingredient ? 0 : (!this.visibleStacks.isEmpty() ? this.currentVariantIndex % this.visibleStacks.size() : 0);
        this.isLocked = false;
        if (!effectiveLockedInput.isEmpty()) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.visibleStacks.get(i)), (ItemStack)effectiveLockedInput)) continue;
                this.currentVariantIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.variantTimePassed += partialTicks;
            if (this.variantTimePassed >= 40.0f) {
                ++this.currentVariantIndex;
                if (this.currentVariantIndex >= this.visibleStacks.size()) {
                    this.currentVariantIndex = 0;
                }
                this.variantTimePassed = 0.0f;
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return !this.visibleStacks.isEmpty() ? (ItemStack)this.visibleStacks.get(this.currentVariantIndex) : ItemStack.EMPTY;
    }

    @Override
    public boolean hasItem() {
        return !this.visibleStacks.isEmpty();
    }

    public boolean isActive() {
        return !this.visibleStacks.isEmpty();
    }

    public NonNullList<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public ItemStack scrollDisplayListAndLock(int i) {
        this.isLocked = true;
        this.currentVariantIndex += i;
        if (this.currentVariantIndex >= this.visibleStacks.size()) {
            this.currentVariantIndex = 0;
        } else if (this.currentVariantIndex < 0) {
            this.currentVariantIndex = this.visibleStacks.size() - 1;
        }
        return (ItemStack)this.visibleStacks.get(this.currentVariantIndex);
    }

    public ItemStack toggleLock() {
        this.isLocked = !this.isLocked;
        return this.isLocked ? this.getItem() : ItemStack.EMPTY;
    }

    public int getIngredientIndex() {
        return this.ingredientIndex;
    }
}

