/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.crafting.CraftingOperation;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.menu.slot.AbstractFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftableListingFakeSlot;
import net.blay09.mods.cookingforblockheads.network.message.AvailableCraftablesListMessage;
import net.blay09.mods.cookingforblockheads.network.message.CraftRecipeMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestAvailableCraftablesMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestSelectionRecipesMessage;
import net.blay09.mods.cookingforblockheads.network.message.SelectionRecipesListMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KitchenMenu
extends AbstractContainerMenu {
    private final Player player;
    private final KitchenImpl kitchen;
    private final List<CraftableListingFakeSlot> recipeListingSlots = new ArrayList<CraftableListingFakeSlot>();
    private final List<CraftMatrixFakeSlot> matrixSlots = new ArrayList<CraftMatrixFakeSlot>();
    private final NonNullList<ItemStack> lockedInputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final List<RecipeWithStatus> filteredCraftables = new ArrayList<RecipeWithStatus>();
    private String currentSearch;
    private Comparator<RecipeWithStatus> currentSorting = new ComparatorName();
    private List<RecipeWithStatus> craftables = new ArrayList<RecipeWithStatus>();
    private boolean craftablesDirty = true;
    private boolean recipesDirty = true;
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private RecipeWithStatus selectedCraftable;
    private List<RecipeWithStatus> recipesForSelection;
    private int recipesForSelectionIndex;

    public KitchenMenu(MenuType<KitchenMenu> containerType, int windowId, Player player, KitchenImpl kitchen) {
        super(containerType, windowId);
        AbstractFakeSlot slot;
        int j;
        int i;
        this.player = player;
        this.kitchen = kitchen;
        DefaultContainer fakeInventory = new DefaultContainer(21);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftableListingFakeSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeListingSlots.add((CraftableListingFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftMatrixFakeSlot((Container)fakeInventory, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((CraftMatrixFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, 8 + j * 18, 92 + i * 18){

                    public void setChanged() {
                        KitchenMenu.this.craftablesDirty = true;
                        KitchenMenu.this.recipesDirty = true;
                    }
                });
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, 8 + i * 18, 150){

                public void setChanged() {
                    KitchenMenu.this.craftablesDirty = true;
                    KitchenMenu.this.recipesDirty = true;
                }
            });
        }
    }

    public void clicked(int slotNumber, int dragType, ClickType clickType, Player player) {
        Slot slot;
        boolean handled = false;
        if (slotNumber >= 0 && slotNumber < this.slots.size() && (slot = (Slot)this.slots.get(slotNumber)) instanceof CraftableListingFakeSlot) {
            CraftableListingFakeSlot craftableSlot = (CraftableListingFakeSlot)slot;
            if (player.level().isClientSide) {
                if (this.isSelectedSlot(craftableSlot)) {
                    if (clickType == ClickType.PICKUP || clickType == ClickType.PICKUP_ALL || clickType == ClickType.QUICK_MOVE || clickType == ClickType.CLONE) {
                        this.requestCraft(clickType == ClickType.QUICK_MOVE, clickType == ClickType.CLONE);
                        handled = true;
                    }
                } else {
                    this.selectCraftable(craftableSlot.getCraftable());
                    handled = true;
                }
            }
        }
        if (!handled) {
            super.clicked(slotNumber, dragType, clickType, player);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.craftablesDirty) {
            this.broadcastAvailableRecipes();
            this.craftablesDirty = false;
        }
        if (this.recipesDirty) {
            if (this.selectedCraftable != null) {
                this.broadcastRecipesForResultItem(this.selectedCraftable.resultItem());
            }
            this.recipesDirty = false;
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container inventory) {
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.moveItemStackTo(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.moveItemStackTo(slotStack, 48, 57, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void selectCraftable(@Nullable RecipeWithStatus recipe) {
        this.selectedCraftable = recipe;
        this.resetSelectedRecipe();
        this.updateCraftableSlots();
        if (recipe != null) {
            if (this.player.level().isClientSide) {
                this.lockedInputs.clear();
                this.requestSelectionRecipes(recipe);
            }
        } else {
            this.resetSelectedRecipe();
            this.updateMatrixSlots();
        }
    }

    public void resetSelectedRecipe() {
        this.recipesForSelection = null;
        this.recipesForSelectionIndex = 0;
        this.updateMatrixSlots();
    }

    public void requestCraftables() {
        Balm.getNetworking().sendToServer((CustomPacketPayload)new RequestAvailableCraftablesMessage());
    }

    public void handleRequestCraftables() {
        this.craftablesDirty = true;
    }

    public void requestSelectionRecipes(RecipeWithStatus craftable) {
        Balm.getNetworking().sendToServer((CustomPacketPayload)new RequestSelectionRecipesMessage(craftable.resultItem(), this.lockedInputs));
    }

    public void handleRequestSelectionRecipes(ItemStack resultItem, NonNullList<ItemStack> lockedInputs) {
        this.selectedCraftable = this.findRecipeForResultItem(resultItem);
        this.lockedInputs.clear();
        for (int i = 0; i < lockedInputs.size(); ++i) {
            this.lockedInputs.set(i, (Object)((ItemStack)lockedInputs.get(i)));
        }
        this.recipesDirty = true;
    }

    private void requestCraft(boolean craftFullStack, boolean addToInventory) {
        RecipeHolder<?> recipe;
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && this.kitchen.canProcess((recipe = selectedRecipe.recipe(this.player)).value().getType())) {
            Balm.getNetworking().sendToServer((CustomPacketPayload)new CraftRecipeMessage(recipe.id(), this.lockedInputs, craftFullStack, addToInventory));
        }
    }

    public List<RecipeWithStatus> getAvailableCraftables() {
        HashMap<ResourceLocation, RecipeWithStatus> result = new HashMap<ResourceLocation, RecipeWithStatus>();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Multimap<ResourceLocation, RecipeHolder<Recipe<?>>> recipesByItemId = CookingForBlockheadsRegistry.getRecipesByItemId();
        for (ResourceLocation itemId : recipesByItemId.keySet()) {
            for (RecipeHolder recipe : recipesByItemId.get((Object)itemId)) {
                CraftingOperation operation;
                ItemStack resultItem = recipe.value().getResultItem((HolderLookup.Provider)this.player.level().registryAccess());
                if (this.isGroupItem(resultItem) || !this.kitchen.isRecipeAvailable(recipe, operation = context.createOperation(recipe).prepare())) continue;
                RecipeWithStatus recipeWithStatus = new RecipeWithStatus(recipe.id(), resultItem, operation.getMissingIngredients(), operation.getMissingIngredientsMask(), operation.getLockedInputs());
                result.compute(itemId, (k, v) -> RecipeWithStatus.best(v, recipeWithStatus));
            }
        }
        return result.values().stream().toList();
    }

    private boolean isGroupItem(ItemStack resultItem) {
        ResourceLocation itemId = Balm.getRegistries().getKey(resultItem.getItem());
        for (KitchenRecipeGroup group : CookingForBlockheadsRegistry.getGroups()) {
            ResourceLocation groupItemId = Balm.getRegistries().getKey(group.getParentItem());
            if (groupItemId.equals((Object)itemId)) continue;
            for (Ingredient ingredient : group.getChildren()) {
                if (!ingredient.test(resultItem)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<RecipeHolder<Recipe<?>>> getRecipesFor(ItemStack resultItem) {
        ArrayList recipes = new ArrayList(CookingForBlockheadsRegistry.getRecipesFor(resultItem));
        recipes.addAll(CookingForBlockheadsRegistry.getRecipesInGroup(resultItem));
        return recipes;
    }

    public void broadcastAvailableRecipes() {
        this.craftables = this.getAvailableCraftables();
        Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new AvailableCraftablesListMessage(this.craftables));
    }

    public void broadcastRecipesForResultItem(ItemStack resultItem) {
        ArrayList<RecipeWithStatus> result = new ArrayList<RecipeWithStatus>();
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        Collection<RecipeHolder<Recipe<?>>> recipesForResult = this.getRecipesFor(resultItem);
        for (RecipeHolder<Recipe<?>> recipe : recipesForResult) {
            ItemStack recipeResultItem = recipe.value().getResultItem((HolderLookup.Provider)this.player.level().registryAccess());
            CraftingOperation operation = context.createOperation(recipe).withLockedInputs(this.lockedInputs).prepare();
            result.add(new RecipeWithStatus(recipe.id(), recipeResultItem, operation.getMissingIngredients(), operation.getMissingIngredientsMask(), operation.getLockedInputs()));
        }
        result.sort(this.currentSorting);
        this.recipesForSelection = result;
        Balm.getNetworking().sendTo(this.player, (CustomPacketPayload)new SelectionRecipesListMessage(result));
    }

    public void craft(ResourceLocation recipeId, NonNullList<ItemStack> lockedInputs, boolean craftFullStack, boolean addToInventory) {
        Level level = this.player.level();
        RecipeHolder recipe = level.getRecipeManager().byKey(recipeId).orElse(null);
        if (recipe == null) {
            CookingForBlockheads.logger.error("Received invalid recipe from client: {}", (Object)recipeId);
            return;
        }
        if (!this.kitchen.canProcess(recipe.value().getType())) {
            CookingForBlockheads.logger.error("Received invalid craft request, unprocessable recipe {}", (Object)recipeId);
            return;
        }
        RecipeWithStatus craftable = this.craftables.stream().filter(it -> it.recipe(this.player) == recipe).findAny().orElse(null);
        if (craftable == null && (craftable = (RecipeWithStatus)this.recipesForSelection.stream().filter(it -> it.recipe(this.player) == recipe).findAny().orElse(null)) == null) {
            CookingForBlockheads.logger.error("Received invalid craft request, unknown recipe {}", (Object)recipeId);
            return;
        }
        CraftingContext context = new CraftingContext(this.kitchen, this.player);
        CraftingOperation operation = context.createOperation(recipe).withLockedInputs(lockedInputs);
        ItemStack resultItem = recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess());
        int repeats = craftFullStack ? resultItem.getMaxStackSize() / resultItem.getCount() : 1;
        for (int i = 0; i < repeats; ++i) {
            ItemStack itemStack;
            operation.prepare();
            if (!operation.canCraft()) break;
            ItemStack carried = this.getCarried();
            if (!(carried.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)resultItem) && carried.getCount() < carried.getMaxStackSize())) {
                if (!craftFullStack && !addToInventory) break;
                addToInventory = true;
            }
            if ((itemStack = operation.craft(this, this.player.level().registryAccess())).isEmpty()) break;
            if (addToInventory) {
                if (this.player.getInventory().add(itemStack)) continue;
                this.player.drop(itemStack, false);
                continue;
            }
            if (carried.isEmpty()) {
                this.setCarried(itemStack);
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)itemStack) && carried.getCount() < carried.getMaxStackSize()) {
                carried.grow(itemStack.getCount());
                continue;
            }
            if (this.player.getInventory().add(itemStack)) continue;
            this.player.drop(itemStack, false);
        }
        this.craftablesDirty = true;
        this.recipesDirty = true;
    }

    public void setCraftables(List<RecipeWithStatus> craftables) {
        int previousSelectionIndex = this.selectedCraftable != null ? this.filteredCraftables.indexOf(this.selectedCraftable) : -1;
        this.craftables = craftables;
        this.updateFilteredRecipes();
        if (previousSelectionIndex != -1) {
            Iterator<RecipeWithStatus> it = this.filteredCraftables.iterator();
            RecipeWithStatus found = null;
            while (it.hasNext()) {
                RecipeWithStatus recipe = it.next();
                if (!ItemStack.isSameItem((ItemStack)recipe.resultItem(), (ItemStack)this.selectedCraftable.resultItem())) continue;
                found = recipe;
                it.remove();
                break;
            }
            while (previousSelectionIndex > this.filteredCraftables.size()) {
                this.filteredCraftables.add(null);
            }
            this.filteredCraftables.add(previousSelectionIndex, found);
            this.selectedCraftable = found;
        }
        this.updateCraftableSlots();
        this.setScrollOffsetDirty(true);
    }

    public void updateCraftableSlots() {
        int i = this.scrollOffset * 5;
        for (CraftableListingFakeSlot slot : this.recipeListingSlots) {
            if (i < this.filteredCraftables.size()) {
                RecipeWithStatus craftable = this.filteredCraftables.get(i);
                if (craftable != null && this.selectedCraftable != null && ItemStack.isSameItemSameComponents((ItemStack)this.selectedCraftable.resultItem(), (ItemStack)craftable.resultItem())) {
                    RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
                    slot.setCraftable(selectedRecipe != null ? selectedRecipe : craftable);
                } else {
                    slot.setCraftable(craftable);
                }
                ++i;
                continue;
            }
            slot.setCraftable(null);
        }
    }

    private void updateMatrixSlots() {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null) {
            RecipeHolder<?> recipe = selectedRecipe.recipe(this.player);
            this.updateMatrixSlots(recipe.value(), selectedRecipe);
        } else {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
                matrixSlot.setIngredient(i, Ingredient.EMPTY, ItemStack.EMPTY);
                matrixSlot.setMissing(true);
            }
        }
    }

    private <C extends RecipeInput, T extends Recipe<C>> void updateMatrixSlots(T recipe, RecipeWithStatus status) {
        int i;
        NonNullList ingredients = recipe.getIngredients();
        NonNullList matrix = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        boolean[] missingMatrix = new boolean[9];
        int[] ingredientIndexMatrix = new int[9];
        Object recipeTypeHandler = CookingForBlockheadsRegistry.getRecipeWorkshopHandler(recipe);
        if (recipeTypeHandler != null) {
            i = 0;
            while (i < ingredients.size()) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                int matrixSlot = recipeTypeHandler.mapToMatrixSlot(recipe, i);
                matrix.set(matrixSlot, (Object)ingredient);
                missingMatrix[matrixSlot] = (status.missingIngredientsMask() & 1 << i) == 1 << i;
                ingredientIndexMatrix[matrixSlot] = i++;
            }
        }
        for (i = 0; i < this.matrixSlots.size(); ++i) {
            CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
            NonNullList<ItemStack> lockedInputs = status.lockedInputs();
            int ingredientIndex = ingredientIndexMatrix[i];
            ItemStack lockedInput = (ItemStack)lockedInputs.get(ingredientIndex);
            matrixSlot.setIngredient(ingredientIndex, (Ingredient)matrix.get(i), lockedInput);
            matrixSlot.setMissing(missingMatrix[i]);
        }
    }

    public void setSortComparator(Comparator<RecipeWithStatus> comparator) {
        this.currentSorting = comparator;
        this.filteredCraftables.removeIf(Objects::isNull);
        this.filteredCraftables.sort(comparator);
        this.updateCraftableSlots();
    }

    public int getItemListCount() {
        return this.filteredCraftables.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateCraftableSlots();
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredCraftables.clear();
        for (RecipeWithStatus craftable : this.craftables) {
            if (!this.searchMatches(craftable)) continue;
            this.filteredCraftables.add(craftable);
        }
        this.filteredCraftables.sort(this.currentSorting);
    }

    private boolean searchMatches(RecipeWithStatus craftable) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        ItemStack resultItem = craftable.resultItem();
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (resultItem.getDisplayName().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = resultItem.getTooltipLines(Item.TooltipContext.EMPTY, this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (Component tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RecipeWithStatus getSelectedRecipe() {
        return this.recipesForSelection != null ? this.recipesForSelection.get(this.recipesForSelectionIndex) : null;
    }

    public boolean isSelectedSlot(CraftableListingFakeSlot slot) {
        RecipeWithStatus selectedRecipe = this.getSelectedRecipe();
        RecipeWithStatus craftable = selectedRecipe != null ? selectedRecipe : this.selectedCraftable;
        return craftable != null && slot.getCraftable() != null && ItemStack.isSameItemSameComponents((ItemStack)slot.getCraftable().resultItem(), (ItemStack)craftable.resultItem());
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean dirty) {
        this.scrollOffsetDirty = dirty;
    }

    public void setRecipesForSelection(List<RecipeWithStatus> recipes) {
        this.recipesForSelection = recipes.size() > 0 ? recipes : null;
        this.recipesForSelectionIndex = this.recipesForSelection != null ? Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex)) : 0;
        this.updateMatrixSlots();
    }

    public void nextRecipe(int dir) {
        if (this.recipesForSelection != null) {
            this.recipesForSelectionIndex = Math.max(0, Math.min(this.recipesForSelection.size() - 1, this.recipesForSelectionIndex + dir));
            this.updateCraftableSlots();
        }
        this.updateMatrixSlots();
    }

    public boolean selectionHasRecipeVariants() {
        return this.recipesForSelection != null && this.recipesForSelection.size() > 1;
    }

    public boolean selectionHasPreviousRecipe() {
        return this.recipesForSelectionIndex > 0;
    }

    public boolean selectionHasNextRecipe() {
        return this.recipesForSelection != null && this.recipesForSelectionIndex < this.recipesForSelection.size() - 1;
    }

    public List<CraftMatrixFakeSlot> getMatrixSlots() {
        return this.matrixSlots;
    }

    @Nullable
    public RecipeWithStatus findRecipeForResultItem(ItemStack resultItem) {
        return this.craftables.stream().filter(it -> ItemStack.isSameItemSameComponents((ItemStack)it.resultItem(), (ItemStack)resultItem)).findAny().orElse(null);
    }

    public Kitchen getKitchen() {
        return this.kitchen;
    }

    public void setLockedInput(int i, ItemStack lockedInput) {
        this.lockedInputs.set(i, (Object)lockedInput);
        if (this.selectedCraftable != null) {
            this.requestSelectionRecipes(this.selectedCraftable);
        }
    }

    public int getRecipesForSelectionIndex() {
        return this.filteredCraftables.indexOf(this.selectedCraftable);
    }
}

