/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.network.message.SyncedEffectMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemPreservationChamber
extends Item {
    public ItemPreservationChamber() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof FridgeBlockEntity && !((FridgeBlockEntity)tileEntity).getBaseFridge().hasPreservationUpgrade()) {
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(context.getHand()).shrink(1);
            }
            ((FridgeBlockEntity)tileEntity).getBaseFridge().setHasPreservationUpgrade(true);
            if (!level.isClientSide) {
                Balm.getNetworking().sendToTracking((ServerLevel)level, pos, (CustomPacketPayload)new SyncedEffectMessage(pos, SyncedEffectMessage.Type.FRIDGE_UPGRADE));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.fridge_upgrade").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.preservation_chamber.description").withStyle(ChatFormatting.GRAY));
    }
}

