/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.treasuredistance.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/client/gui/MapRenderer$MapInstance"})
public class MapRendererMixin {
    @Shadow
    private MapItemSavedData data;

    @Inject(method={"draw"}, at={@At(value="TAIL")})
    public void drawInject(PoseStack p_93292_, MultiBufferSource p_93293_, boolean p_93294_, int p_93295_, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == Items.FILLED_MAP) {
            for (MapDecorations.Entry deco : ((MapDecorations)stack.getComponents().get(DataComponents.MAP_DECORATIONS)).decorations().values()) {
                if (!((MapDecorationType)deco.type().value()).showOnItemFrame()) continue;
                double x = deco.x();
                double z = deco.z();
                Vector2d goalVec = new Vector2d(x, z);
                Vector2d targetVec = new Vector2d(player.getX(), player.getZ());
                int dist = (int)goalVec.distance((Vector2dc)targetVec);
                Font font = Minecraft.getInstance().font;
                MutableComponent component = Component.literal((String)(dist + " Blocks"));
                float f6 = font.width((FormattedText)component);
                float f7 = Mth.clamp((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                p_93292_.pushPose();
                p_93292_.translate(64.0f - f6 * f7 / 2.0f, 68.0f, -0.025f);
                p_93292_.scale(f7, f7, 1.0f);
                p_93292_.translate(0.0f, 0.0f, -0.1f);
                font.drawInBatch((Component)component, 0.0f, 0.0f, -1, false, p_93292_.last().pose(), p_93293_, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, p_93295_);
                p_93292_.popPose();
                break;
            }
        }
    }
}

