/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.ApothEnchConfig;
import dev.shadowsoffire.apothic_enchanting.api.EnchantmentStatBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class TypedShelfBlock
extends Block
implements EnchantmentStatBlock {
    protected final Supplier<? extends ParticleOptions> particle;

    public TypedShelfBlock(BlockBehaviour.Properties props, Supplier<? extends ParticleOptions> particle) {
        super(props);
        this.particle = particle;
    }

    @Override
    public ParticleOptions getTableParticle(BlockState state) {
        return this.particle.get();
    }

    public static class SculkShelfBlock
    extends TypedShelfBlock {
        public SculkShelfBlock(BlockBehaviour.Properties props, Supplier<? extends ParticleOptions> particle) {
            super(props, particle);
        }

        public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
            if (ApothEnchConfig.sculkShelfNoiseChance > 0 && rand.nextInt(ApothEnchConfig.sculkShelfNoiseChance) == 0) {
                level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.BLOCKS, 2.0f, 0.6f + rand.nextFloat() * 0.4f, true);
            }
        }
    }
}

