/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentScreen;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class InfusionRecipeCategory
implements IRecipeCategory<InfusionRecipe> {
    public static final ResourceLocation UID = ApothicEnchanting.loc("enchanting");
    public static final RecipeType<InfusionRecipe> TYPE = RecipeType.create((String)"apothic_enchanting", (String)"enchanting", InfusionRecipe.class);
    public static final ResourceLocation TEXTURES = ApothicEnchanting.loc("textures/gui/enchanting_jei.png");
    private static final Map<Class<?>, Extension<?>> EXTENSIONS = new HashMap();
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, 0, 170, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE));
        this.localizedName = TooltipUtil.lang("recipes", "infusion", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public RecipeType<InfusionRecipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfusionRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 6, 6);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 37, 6);
        Extension<?> ext = EXTENSIONS.get(recipe.getClass());
        if (ext != null) {
            ext.setRecipe(builder, input, output, recipe, focuses);
        } else {
            input.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getInput().getItems()));
            output.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutput());
        }
    }

    public void draw(InfusionRecipe recipe, IRecipeSlotsView slots, GuiGraphics gfx, double mouseX, double mouseY) {
        boolean hover = false;
        if (mouseX > 57.0 && mouseX <= 165.0 && mouseY > 4.0 && mouseY <= 23.0) {
            gfx.blit(TEXTURES, 57, 4, 0, 0.0f, 71.0f, 108, 19, 256, 256);
            hover = true;
        }
        Font font = Minecraft.getInstance().font;
        EnchantingStatRegistry.Stats stats = recipe.getRequirements();
        EnchantingStatRegistry.Stats maxStats = recipe.getMaxRequirements();
        gfx.drawString(font, (Component)TooltipUtil.lang("gui", "enchant.eterna", new Object[0]), 16, 26, 4044093, false);
        gfx.drawString(font, (Component)TooltipUtil.lang("gui", "enchant.quanta", new Object[0]), 16, 36, 16536660, false);
        gfx.drawString(font, (Component)TooltipUtil.lang("gui", "enchant.arcana", new Object[0]), 16, 46, 0xA800A8, false);
        int level = (int)stats.eterna();
        String s = "" + level;
        int width = 86 - font.width(s);
        EnchantmentNames.getInstance().initSeed((long)recipe.hashCode());
        FormattedText itextproperties = EnchantmentNames.getInstance().getRandomName(font, width);
        int color = hover ? 0xFFFF80 : 6839882;
        InfusionRecipeCategory.drawWordWrap(font, itextproperties, 77, 6, width, color, gfx);
        color = 8453920;
        gfx.drawString(font, s, 77 + width, 13, color);
        int[] pos = new int[]{InfusionRecipeCategory.getBarLength(stats.eterna()), InfusionRecipeCategory.getBarLength(stats.quanta()), InfusionRecipeCategory.getBarLength(stats.arcana())};
        if (stats.eterna() > 0.0f) {
            gfx.blit(TEXTURES, 56, 27, 0.0f, 56.0f, pos[0], 5, 256, 256);
        }
        if (stats.quanta() > 0.0f) {
            gfx.blit(TEXTURES, 56, 37, 0.0f, 61.0f, pos[1], 5, 256, 256);
        }
        if (stats.arcana() > 0.0f) {
            gfx.blit(TEXTURES, 56, 47, 0.0f, 66.0f, pos[2], 5, 256, 256);
        }
        RenderSystem.enableBlend();
        if (maxStats.eterna() > 0.0f) {
            gfx.blit(TEXTURES, 56 + pos[0], 27, (float)pos[0], 90.0f, InfusionRecipeCategory.getBarLength(maxStats.eterna() - stats.eterna()), 5, 256, 256);
        }
        if (maxStats.quanta() > 0.0f) {
            gfx.blit(TEXTURES, 56 + pos[1], 37, (float)pos[1], 95.0f, InfusionRecipeCategory.getBarLength(maxStats.quanta() - stats.quanta()), 5, 256, 256);
        }
        if (maxStats.arcana() > 0.0f) {
            gfx.blit(TEXTURES, 56 + pos[2], 47, (float)pos[2], 100.0f, InfusionRecipeCategory.getBarLength(maxStats.arcana() - stats.arcana()), 5, 256, 256);
        }
        RenderSystem.disableBlend();
        gfx.pose().pushPose();
        gfx.pose().translate(0.0f, 0.0f, 100.0f);
        if (hover) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            Component infusionName = Enchantment.getFullname((Holder)Minecraft.getInstance().level.holderOrThrow(Ench.Enchantments.INFUSION), (int)1);
            list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{infusionName}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            gfx.renderComponentTooltip(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 26.0 && mouseY <= 32.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(TooltipUtil.lang("gui", "enchant.eterna", new Object[0]).withStyle(ChatFormatting.GREEN));
            if (maxStats.eterna() == stats.eterna()) {
                list.add(TooltipUtil.lang("info", "eterna_exact", Float.valueOf(stats.eterna()), 100).withStyle(ChatFormatting.GRAY));
            } else {
                list.add(TooltipUtil.lang("info", "eterna_at_least", Float.valueOf(stats.eterna()), 100).withStyle(ChatFormatting.GRAY));
                if (maxStats.eterna() > -1.0f) {
                    list.add(TooltipUtil.lang("info", "eterna_at_most", Float.valueOf(maxStats.eterna()), 100).withStyle(ChatFormatting.GRAY));
                }
            }
            gfx.renderComponentTooltip(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 36.0 && mouseY <= 42.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(TooltipUtil.lang("gui", "enchant.quanta", new Object[0]).withStyle(ChatFormatting.RED));
            if (maxStats.quanta() == stats.quanta()) {
                list.add(TooltipUtil.lang("info", "percent_exact", Float.valueOf(stats.quanta())).withStyle(ChatFormatting.GRAY));
            } else {
                list.add(TooltipUtil.lang("info", "percent_at_least", Float.valueOf(stats.quanta())).withStyle(ChatFormatting.GRAY));
                if (maxStats.quanta() > -1.0f) {
                    list.add(TooltipUtil.lang("info", "percent_at_most", Float.valueOf(maxStats.quanta())).withStyle(ChatFormatting.GRAY));
                }
            }
            gfx.renderComponentTooltip(font, list, (int)mouseX, (int)mouseY);
        } else if (mouseX > 56.0 && mouseX <= 166.0 && mouseY > 46.0 && mouseY <= 52.0) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(TooltipUtil.lang("gui", "enchant.arcana", new Object[0]).withStyle(ChatFormatting.DARK_PURPLE));
            if (maxStats.arcana() == stats.arcana()) {
                list.add(TooltipUtil.lang("info", "percent_exact", Float.valueOf(stats.arcana())).withStyle(ChatFormatting.GRAY));
            } else {
                list.add(TooltipUtil.lang("info", "percent_at_least", Float.valueOf(stats.arcana())).withStyle(ChatFormatting.GRAY));
                if (maxStats.arcana() > -1.0f) {
                    list.add(TooltipUtil.lang("info", "percent_at_most", Float.valueOf(maxStats.arcana())).withStyle(ChatFormatting.GRAY));
                }
            }
            gfx.renderComponentTooltip(font, list, (int)mouseX, (int)mouseY);
        }
        gfx.pose().popPose();
    }

    public static int getBarLength(float stat) {
        return ApothEnchantmentScreen.getBarLength(stat);
    }

    public static void drawWordWrap(Font font, FormattedText pText, int pX, int pY, int pMaxWidth, int pColor, GuiGraphics gfx) {
        for (FormattedCharSequence formattedcharsequence : font.split(pText, pMaxWidth)) {
            gfx.drawString(font, formattedcharsequence, pX, pY, pColor, false);
            pY += 9;
        }
    }

    public static <T extends InfusionRecipe> void registerExtension(Class<T> cls, Extension<T> ext) {
        EXTENSIONS.put(cls, ext);
    }

    public static interface Extension<T extends InfusionRecipe> {
        public void setRecipe(IRecipeLayoutBuilder var1, IRecipeSlotBuilder var2, IRecipeSlotBuilder var3, InfusionRecipe var4, IFocusGroup var5);
    }
}

