/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_enchanting.ApothEnchConfig;
import dev.shadowsoffire.apothic_enchanting.ApothEnchEvents;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.PowerFunction;
import dev.shadowsoffire.apothic_enchanting.asm.EnchHooks;
import dev.shadowsoffire.apothic_enchanting.data.ApothEnchantmentProvider;
import dev.shadowsoffire.apothic_enchanting.data.EnchRecipeProvider;
import dev.shadowsoffire.apothic_enchanting.data.EnchTagsProvider;
import dev.shadowsoffire.apothic_enchanting.data.LootProvider;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.apothic_enchanting.objects.TomeItem;
import dev.shadowsoffire.apothic_enchanting.payloads.CluePayload;
import dev.shadowsoffire.apothic_enchanting.payloads.EnchantmentInfoPayload;
import dev.shadowsoffire.apothic_enchanting.payloads.StatsPayload;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantingTableBlock;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import dev.shadowsoffire.apothic_enchanting.util.DataGenBuilder;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.events.ResourceReloadEvent;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="apothic_enchanting")
public class ApothicEnchanting {
    public static final String MODID = "apothic_enchanting";
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final Map<Holder<Enchantment>, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Holder<Enchantment>, EnchantmentInfo>();
    public static final Object2IntMap<ResourceKey<Enchantment>> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final String ENCH_HARD_CAP_IMC = "set_ench_hard_cap";
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();

    public ApothicEnchanting(IEventBus bus) {
        Ench.bootstrap(bus);
        bus.register((Object)this);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        NeoForge.EVENT_BUS.register((Object)new ApothEnchEvents());
        NeoForge.EVENT_BUS.addListener(this::reload);
        e.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new ShearsDispenseItemBehavior());
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Holder[])new Holder[]{Ench.Items.HELLSHELF, Ench.Items.INFUSED_HELLSHELF, Ench.Items.BLAZING_HELLSHELF, Ench.Items.GLOWING_HELLSHELF, Ench.Items.SEASHELF, Ench.Items.INFUSED_SEASHELF, Ench.Items.CRYSTAL_SEASHELF, Ench.Items.HEART_SEASHELF, Ench.Items.DORMANT_DEEPSHELF, Ench.Items.DEEPSHELF, Ench.Items.ECHOING_DEEPSHELF, Ench.Items.SOUL_TOUCHED_DEEPSHELF, Ench.Items.ECHOING_SCULKSHELF, Ench.Items.SOUL_TOUCHED_SCULKSHELF, Ench.Items.ENDSHELF, Ench.Items.PEARL_ENDSHELF, Ench.Items.DRACONIC_ENDSHELF, Ench.Items.BEESHELF, Ench.Items.MELONSHELF, Ench.Items.STONESHELF, Ench.Items.SIGHTSHELF, Ench.Items.SIGHTSHELF_T2, Ench.Items.FILTERING_SHELF, Ench.Items.TREASURE_SHELF, Ench.Items.GEODE_SHELF, Ench.Items.LIBRARY, Ench.Items.ENDER_LIBRARY});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Holder[])new Holder[]{Ench.Items.HELMET_TOME, Ench.Items.CHESTPLATE_TOME, Ench.Items.LEGGINGS_TOME, Ench.Items.BOOTS_TOME, Ench.Items.WEAPON_TOME, Ench.Items.BOW_TOME, Ench.Items.PICKAXE_TOME, Ench.Items.FISHING_TOME, Ench.Items.OTHER_TOME, Ench.Items.SCRAP_TOME, Ench.Items.IMPROVED_SCRAP_TOME, Ench.Items.EXTRACTION_TOME});
            TabFillingRegistry.register((ResourceKey)Ench.Tabs.ENCH.getKey(), (Holder[])new Holder[]{Ench.Items.PRISMATIC_WEB, Ench.Items.INERT_TRIDENT, Ench.Items.WARDEN_TENDRIL, Ench.Items.INFUSED_BREATH});
            ApothicEnchanting.fill((ResourceKey<CreativeModeTab>)Ench.Tabs.ENCH.getKey(), Ench.Enchantments.BERSERKERS_FURY, Ench.Enchantments.CHAINSAW, Ench.Enchantments.CHROMATIC, Ench.Enchantments.CRESCENDO_OF_BOLTS, Ench.Enchantments.BOON_OF_THE_EARTH, Ench.Enchantments.ENDLESS_QUIVER, Ench.Enchantments.WORKER_EXPLOITATION, Ench.Enchantments.GROWTH_SERUM, Ench.Enchantments.ICY_THORNS, Ench.Enchantments.KNOWLEDGE_OF_THE_AGES, Ench.Enchantments.LIFE_MENDING, Ench.Enchantments.MINERS_FERVOR, Ench.Enchantments.NATURES_BLESSING, Ench.Enchantments.REBOUNDING, Ench.Enchantments.REFLECTIVE_DEFENSES, Ench.Enchantments.SCAVENGER, Ench.Enchantments.SHIELD_BASH, Ench.Enchantments.STABLE_FOOTING, Ench.Enchantments.TEMPTING);
            PlaceboUtil.registerCustomColor((TextColor)Ench.Colors.LIGHT_BLUE_FLASH);
        });
        EnchantingStatRegistry.INSTANCE.registerToBus();
        PayloadHelper.registerPayload((PayloadProvider)new CluePayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new StatsPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new EnchantmentInfoPayload.Provider());
    }

    @SubscribeEvent
    public void handleIMC(InterModProcessEvent e) {
        e.getIMCStream(ENCH_HARD_CAP_IMC::equals).forEach(msg -> {
            try {
                Pair data = (Pair)msg.messageSupplier().get();
                if (data.getFirst() != null && (Integer)data.getSecond() > 0) {
                    ENCH_HARD_CAPS.put((Object)((ResourceKey)data.getFirst()), ((Integer)data.getSecond()).intValue());
                } else {
                    LOGGER.error("Failed to process IMC message with method {} from {} (invalid values passed).", (Object)msg.method(), (Object)msg.senderModId());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception thrown during IMC message with method {} from {}.", (Object)msg.method(), (Object)msg.senderModId());
                ex.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void caps(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Ench.Tiles.LIBRARY.get(), EnchLibraryTile::getItemHandler);
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Ench.Tiles.ENDER_LIBRARY.get(), EnchLibraryTile::getItemHandler);
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityType.ENCHANTING_TABLE, ApothEnchantingTableBlock::getItemHandler);
    }

    @SubscribeEvent
    public void data(GatherDataEvent event) {
        DataGenBuilder.create(MODID, "minecraft").registry(Registries.ENCHANTMENT, ApothEnchantmentProvider::bootstrap).provider(LootProvider::create).provider(EnchTagsProvider::new).provider(EnchRecipeProvider::new).build(event);
    }

    public void reload(ResourceReloadEvent e) {
        ApothEnchConfig.load(new Configuration(ApothicAttributes.getConfigFile((String)MODID)));
    }

    public static EnchantmentInfo getEnchInfo(Holder<Enchantment> ench) {
        if (ENCHANTMENT_INFO.isEmpty()) {
            throw new UnsupportedOperationException("Cannot access enchantment information before it has been loaded!");
        }
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        return info != null ? info : EnchantmentInfo.fallback(ench);
    }

    public static int getDefaultMaxLevel(Holder<Enchantment> ench) {
        int level = ((Enchantment)ench.value()).getMaxLevel();
        if (level == 1) {
            return 1;
        }
        PowerFunction.DefaultMinPowerFunction minFunc = new PowerFunction.DefaultMinPowerFunction(ench);
        int max = 200;
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    @SafeVarargs
    public static void fill(ResourceKey<CreativeModeTab> tab, ResourceKey<Enchantment> ... enchants) {
        Arrays.stream(enchants).map(ApothicEnchanting::enchFiller).forEach(filler -> TabFillingRegistry.register((ITabFiller)filler, (ResourceKey[])new ResourceKey[]{tab}));
    }

    public static ITabFiller enchFiller(ResourceKey<Enchantment> e) {
        return (tab, event) -> {
            Holder ench = event.getParameters().holders().lookupOrThrow(Registries.ENCHANTMENT).get(e).orElse(null);
            if (ench == null) {
                return;
            }
            int maxLevel = EnchHooks.getMaxLevel((Enchantment)ench.value());
            event.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(ench, maxLevel)), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            for (int level = 1; level <= maxLevel; ++level) {
                event.accept(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(ench, level)), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
            }
        };
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

