/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.EnchantmentInfo;
import dev.shadowsoffire.apothic_enchanting.enchantments.ChainsawTask;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BerserkingComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BoonComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.ReflectiveComponent;
import dev.shadowsoffire.apothic_enchanting.objects.ExtractionTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.ImprovedScrappingTomeItem;
import dev.shadowsoffire.apothic_enchanting.objects.ScrappingTomeItem;
import dev.shadowsoffire.apothic_enchanting.payloads.EnchantmentInfoPayload;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.util.RunnableReloader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;

public class ApothEnchEvents {
    private static final MethodHandle dropFromLootTable;

    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        ItemStack left = e.getLeft();
        if (left.isEnchanted() && e.getRight().getItem() == Ench.Items.PRISMATIC_WEB.value()) {
            ItemStack stack = left.copy();
            ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
            enchants.removeIf(h -> h.is(EnchantmentTags.CURSE));
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchants.toImmutable());
            e.setCost(30L);
            e.setMaterialCost(1);
            e.setOutput(stack);
            return;
        }
        if (left.getCount() == 1 && (left.getItem() == Items.CHIPPED_ANVIL || left.getItem() == Items.DAMAGED_ANVIL) && e.getRight().is(Tags.Items.STORAGE_BLOCKS_IRON)) {
            Item target = left.getItem() == Items.CHIPPED_ANVIL ? Items.DAMAGED_ANVIL : Items.ANVIL;
            ItemStack out = left.transmuteCopy((ItemLike)target);
            e.setOutput(out);
            e.setCost(5L);
            e.setMaterialCost(1);
            return;
        }
        if (ScrappingTomeItem.updateAnvil(e)) {
            return;
        }
        if (ImprovedScrappingTomeItem.updateAnvil(e)) {
            return;
        }
        if (ExtractionTomeItem.updateAnvil(e)) {
            return;
        }
    }

    @SubscribeEvent
    public void repairEvent(AnvilRepairEvent e) {
        if (ExtractionTomeItem.updateRepair(e)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Throwable {
        Player p;
        Entity entity = e.getSource().getEntity();
        if (entity instanceof Player && !(p = (Player)entity).level().isClientSide()) {
            try {
                MutableFloat dropChance = new MutableFloat();
                EnchantmentHelper.runIterationOnItem((ItemStack)p.getWeaponItem(), (ench, level) -> ((Enchantment)ench.value()).modifyDamageFilteredValue(Ench.EnchantEffects.EXTRA_LOOT_ROLL, (ServerLevel)p.level(), level, p.getWeaponItem(), (Entity)p, e.getSource(), dropChance));
                if (dropChance.floatValue() > 0.0f && p.level().random.nextFloat() <= dropChance.floatValue()) {
                    e.getEntity().captureDrops(new ArrayList());
                    dropFromLootTable.invoke(e.getEntity(), e.getSource(), true);
                    e.getDrops().addAll(e.getEntity().captureDrops(null));
                }
            }
            catch (Throwable t) {
                ApothicEnchanting.LOGGER.catching(t);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        Player p;
        Entity entity;
        if (!(e.getEntity() instanceof Player) && (entity = e.getSource().getEntity()) instanceof Player && !(p = (Player)entity).level().isClientSide()) {
            ItemStack stack = p.getWeaponItem();
            MutableFloat knowledge = new MutableFloat();
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (ench, level) -> ((Enchantment)ench.value()).modifyItemFilteredCount(Ench.EnchantEffects.DROPS_TO_XP, (ServerLevel)p.level(), level, stack, knowledge));
            if (knowledge.floatValue() > 0.0f) {
                int totalXp = 0;
                for (ItemEntity i : e.getDrops()) {
                    totalXp = (int)((float)totalXp + (float)i.getItem().getCount() * knowledge.floatValue());
                }
                e.getDrops().clear();
                LivingEntity ded = e.getEntity();
                while (totalXp > 0) {
                    int i = ExperienceOrb.getExperienceValue((int)totalXp);
                    totalXp -= i;
                    p.level().addFreshEntity((Entity)new ExperienceOrb(p.level(), ded.getX(), ded.getY(), ded.getZ(), i));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void healing(LivingHealEvent e) {
        if (e.getEntity().getType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (e.getEntity().level().isClientSide) {
            return;
        }
        if (e.getAmount() <= 0.0f) {
            return;
        }
        EnchantmentHelper.getRandomItemWith(Ench.EnchantEffects.REPAIR_WITH_HP, (LivingEntity)e.getEntity(), s -> s.isDamaged()).ifPresent(itemInUse -> {
            ItemStack stack = itemInUse.itemStack();
            MutableFloat duraPerHp = new MutableFloat();
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (ench, level) -> ((Enchantment)ench.value()).modifyItemFilteredCount(Ench.EnchantEffects.REPAIR_WITH_HP, (ServerLevel)e.getEntity().level(), level, stack, duraPerHp));
            if (duraPerHp.floatValue() > 0.0f) {
                float cost = 1.0f / duraPerHp.floatValue();
                int maxRestore = Math.min(Mth.floor((float)(e.getAmount() / cost)), stack.getDamageValue());
                e.setAmount(e.getAmount() - (float)maxRestore * cost);
                stack.setDamageValue(stack.getDamageValue() - maxRestore);
                if (itemInUse.inSlot() != null && itemInUse.owner() != null) {
                    itemInUse.owner().setItemSlot(itemInUse.inSlot(), stack);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void block(LivingShieldBlockEvent e) {
        LivingEntity user = e.getEntity();
        Entity attacker = e.getDamageSource().getDirectEntity();
        ItemStack shield = user.getUseItem();
        Pair reflect = EnchantmentHelper.getHighestLevel((ItemStack)shield, Ench.EnchantEffects.REFLECTIVE);
        if (reflect != null) {
            float chance = ((ReflectiveComponent)reflect.getFirst()).procChance().calculate(((Integer)reflect.getSecond()).intValue());
            if (user.level().random.nextFloat() <= chance) {
                DamageSource src = user.level().damageSources().indirectMagic((Entity)user, (Entity)user);
                if (attacker instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    float ratio = ((ReflectiveComponent)reflect.getFirst()).reflectRatio().calculate(((Integer)reflect.getSecond()).intValue());
                    livingAttacker.hurt(src, ratio * e.getBlockedDamage());
                    shield.hurtAndBreak(10, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                }
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        Player p = e.getEntity();
        if (!p.onGround() && e.getOriginalSpeed() < e.getNewSpeed() * 5.0f) {
            MutableBoolean flag = new MutableBoolean(false);
            EnchantmentHelper.runIterationOnEquipment((LivingEntity)p, (ench, level, item) -> {
                if (((Enchantment)ench.value()).effects().has(Ench.EnchantEffects.STABLE_FOOTING)) {
                    flag.setTrue();
                }
            });
            if (flag.getValue().booleanValue()) {
                e.setNewSpeed(e.getNewSpeed() * 5.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void breakSpeedLow(PlayerEvent.BreakSpeed e) {
        Player p = e.getEntity();
        ItemStack stack = p.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        Pair fervor = EnchantmentHelper.getHighestLevel((ItemStack)stack, Ench.EnchantEffects.MINERS_FERVOR);
        if (fervor != null && stack.getDestroySpeed(e.getState()) > 1.0f) {
            float hardness = e.getState().getDestroySpeed((BlockGetter)p.level(), e.getPosition().orElse(BlockPos.ZERO));
            e.setNewSpeed(Math.min(29.9999f, ((LevelBasedValue)fervor.getFirst()).calculate(((Integer)fervor.getSecond()).intValue())) * hardness);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void breakSpeed(BlockEvent.BreakEvent e) {
        ChainsawTask.attemptChainsaw(e);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockDrops(BlockDropsEvent e) {
        BoonComponent.provideBenefits(e);
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        Pair bonemealCost = EnchantmentHelper.getHighestLevel((ItemStack)s, Ench.EnchantEffects.BONEMEAL_CROPS);
        if (bonemealCost != null && !e.getEntity().isShiftKeyDown() && BoneMealItem.applyBonemeal((ItemStack)s.copy(), (Level)e.getLevel(), (BlockPos)e.getPos(), (Player)e.getEntity())) {
            int cost = (int)((LevelBasedValue)bonemealCost.getFirst()).calculate(((Integer)bonemealCost.getSecond()).intValue());
            if (cost > 0) {
                s.hurtAndBreak(cost, (LivingEntity)e.getEntity(), LivingEntity.getSlotForHand((InteractionHand)e.getHand()));
            }
            e.setCanceled(true);
            e.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingDamageEvent.Post e) {
        BerserkingComponent.attemptToGoBerserk(e);
    }

    @SubscribeEvent
    public void reload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)RunnableReloader.of(() -> {
            Configuration enchInfoConfig = new Configuration(ApothicAttributes.getConfigFile((String)"enchantments"));
            enchInfoConfig.setTitle("Apotheosis Enchantment Information");
            enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
            ApothicEnchanting.ENCHANTMENT_INFO.clear();
            e.getServerResources().getRegistryLookup().lookupOrThrow(Registries.ENCHANTMENT).listElements().forEach(ench -> {
                EnchantmentInfo info = EnchantmentInfo.load((Holder<Enchantment>)ench, enchInfoConfig);
                ApothicEnchanting.ENCHANTMENT_INFO.put((Holder<Enchantment>)ench, info);
                for (int i = 1; i <= info.getMaxLevel(); ++i) {
                    if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                    ApothicEnchanting.LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable except by combination.", (Object)ench.key().location(), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
                }
            });
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
        }));
    }

    @SubscribeEvent
    public void stopped(ServerStoppedEvent e) {
        ApothicEnchanting.ENCHANTMENT_INFO.clear();
    }

    @SubscribeEvent
    public void logout(ClientPlayerNetworkEvent.LoggingOut e) {
    }

    @SubscribeEvent
    public void sync(OnDatapackSyncEvent e) {
        e.getRelevantPlayers().forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new EnchantmentInfoPayload(ApothicEnchanting.ENCHANTMENT_INFO), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    static {
        Method m = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"dropFromLootTable", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
        try {
            m.setAccessible(true);
            dropFromLootTable = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LivingEntity#dropFromLootTable not located!");
        }
    }
}

