/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemTagsProvider
extends ItemTagsProvider {
    public ModItemTagsProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, blockTagsProvider, "pneumaticcraft", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.copy(PneumaticCraftTags.Blocks.SLABS, PneumaticCraftTags.Items.SLABS);
        this.copy(PneumaticCraftTags.Blocks.STAIRS, PneumaticCraftTags.Items.STAIRS);
        this.copy(PneumaticCraftTags.Blocks.WALLS, PneumaticCraftTags.Items.WALLS);
        this.copy(PneumaticCraftTags.Blocks.DOORS, PneumaticCraftTags.Items.DOORS);
        this.copy(PneumaticCraftTags.Blocks.STORAGE_BLOCKS_COMPRESSED_IRON, PneumaticCraftTags.Items.STORAGE_BLOCKS_COMPRESSED_IRON);
        this.copy(PneumaticCraftTags.Blocks.PLASTIC_BRICKS, PneumaticCraftTags.Items.PLASTIC_BRICKS);
        this.copy(PneumaticCraftTags.Blocks.SMOOTH_PLASTIC_BRICKS, PneumaticCraftTags.Items.SMOOTH_PLASTIC_BRICKS);
        this.copy(PneumaticCraftTags.Blocks.WALL_LAMPS, PneumaticCraftTags.Items.WALL_LAMPS);
        this.copy(PneumaticCraftTags.Blocks.WALL_LAMPS_INVERTED, PneumaticCraftTags.Items.WALL_LAMPS_INVERTED);
        this.copy(PneumaticCraftTags.Blocks.FLUID_TANKS, PneumaticCraftTags.Items.FLUID_TANKS);
        this.copy(PneumaticCraftTags.Blocks.CHESTS, PneumaticCraftTags.Items.CHESTS);
        this.copy(PneumaticCraftTags.Blocks.REINFORCED_STONE, PneumaticCraftTags.Items.REINFORCED_STONE);
        this.copy(PneumaticCraftTags.Blocks.REINFORCED_STONE_BRICKS, PneumaticCraftTags.Items.REINFORCED_STONE_BRICKS);
        this.copy(PneumaticCraftTags.Blocks.COMPRESSED_STONE, PneumaticCraftTags.Items.COMPRESSED_STONE);
        this.copy(PneumaticCraftTags.Blocks.COMPRESSED_STONE_BRICKS, PneumaticCraftTags.Items.COMPRESSED_STONE_BRICKS);
        this.appendToTag((TagKey<Item>)ItemTags.SLABS, PneumaticCraftTags.Items.SLABS);
        this.appendToTag((TagKey<Item>)ItemTags.STAIRS, PneumaticCraftTags.Items.STAIRS);
        this.appendToTag((TagKey<Item>)ItemTags.WALLS, PneumaticCraftTags.Items.WALLS);
        this.appendToTag((TagKey<Item>)ItemTags.DOORS, PneumaticCraftTags.Items.DOORS);
        this.appendToTag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS, PneumaticCraftTags.Items.STORAGE_BLOCKS_COMPRESSED_IRON);
        this.appendToTag((TagKey<Item>)Tags.Items.CHESTS, PneumaticCraftTags.Items.CHESTS);
        this.appendToTag((TagKey<Item>)Tags.Items.STONES, PneumaticCraftTags.Items.REINFORCED_STONE, PneumaticCraftTags.Items.COMPRESSED_STONE);
        this.appendToTag((TagKey<Item>)ItemTags.STONE_BRICKS, PneumaticCraftTags.Items.REINFORCED_STONE_BRICKS, PneumaticCraftTags.Items.COMPRESSED_STONE_BRICKS);
        this.addItemsToTag(PneumaticCraftTags.Items.PLASTIC_SHEETS, new Supplier[]{ModItems.PLASTIC});
        this.addItemsToTag(PneumaticCraftTags.Items.FLOUR, new Supplier[]{ModItems.WHEAT_FLOUR});
        this.addItemsToTag((TagKey<Item>)Tags.Items.NUGGETS, new Supplier[]{ModItems.COPPER_NUGGET});
        this.addItemsToTag(PneumaticCraftTags.Items.NUGGETS_COPPER, new Supplier[]{ModItems.COPPER_NUGGET});
        this.addItemsToTag((TagKey<Item>)ItemTags.DYEABLE, new Supplier[]{ModItems.PNEUMATIC_HELMET, ModItems.PNEUMATIC_CHESTPLATE, ModItems.PNEUMATIC_LEGGINGS, ModItems.PNEUMATIC_BOOTS});
        this.addItemsToTag(PneumaticCraftTags.Items.REINFORCED_CHEST_DISALLOWED, new Supplier[]{ModBlocks.REINFORCED_CHEST, ModBlocks.SMART_CHEST});
        this.appendToTag(PneumaticCraftTags.Items.REINFORCED_CHEST_DISALLOWED, Tags.Items.SHULKER_BOXES);
        this.addItemsToTag(PneumaticCraftTags.Items.LOGISTIC_FRAMES, new Supplier[]{ModItems.LOGISTICS_FRAME_STORAGE, ModItems.LOGISTICS_FRAME_DEFAULT_STORAGE, ModItems.LOGISTICS_FRAME_ACTIVE_PROVIDER, ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER, ModItems.LOGISTICS_FRAME_REQUESTER});
        this.addItemsToTag((TagKey<Item>)ItemTags.HEAD_ARMOR, new Supplier[]{ModItems.COMPRESSED_IRON_HELMET, ModItems.PNEUMATIC_HELMET});
        this.addItemsToTag((TagKey<Item>)ItemTags.CHEST_ARMOR, new Supplier[]{ModItems.COMPRESSED_IRON_CHESTPLATE, ModItems.PNEUMATIC_CHESTPLATE});
        this.addItemsToTag((TagKey<Item>)ItemTags.LEG_ARMOR, new Supplier[]{ModItems.COMPRESSED_IRON_LEGGINGS, ModItems.PNEUMATIC_LEGGINGS});
        this.addItemsToTag((TagKey<Item>)ItemTags.FOOT_ARMOR, new Supplier[]{ModItems.COMPRESSED_IRON_BOOTS, ModItems.PNEUMATIC_BOOTS});
        this.addItemsToTag(PneumaticCraftTags.Items.MINIGUN_AMMO, new Supplier[]{ModItems.GUN_AMMO, ModItems.GUN_AMMO_AP, ModItems.GUN_AMMO_EXPLOSIVE, ModItems.GUN_AMMO_FREEZING, ModItems.GUN_AMMO_INCENDIARY, ModItems.GUN_AMMO_WEIGHTED});
        this.appendToTag((TagKey<Item>)ItemTags.DURABILITY_ENCHANTABLE, PneumaticCraftTags.Items.MINIGUN_AMMO);
        this.appendToTag(PneumaticCraftTags.Items.WIRING, Tags.Items.NUGGETS_GOLD);
        this.appendToTag(PneumaticCraftTags.Items.WIRING, PneumaticCraftTags.Items.NUGGETS_COPPER);
        this.addItemsToTag(PneumaticCraftTags.Items.UPGRADE_COMPONENTS, new Supplier[]{ModItems.UPGRADE_MATRIX, () -> Items.LAPIS_LAZULI});
        this.addItemsToTag(PneumaticCraftTags.Items.BASIC_DRONES, new Supplier[]{ModItems.LOGISTICS_DRONE, ModItems.GUARD_DRONE, ModItems.HARVESTING_DRONE, ModItems.COLLECTOR_DRONE});
        this.addItemsToTag(PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON, new Supplier[]{ModItems.COMPRESSED_IRON_INGOT});
        this.appendToTag((TagKey<Item>)Tags.Items.INGOTS, PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON);
        this.addItemsToTag(PneumaticCraftTags.Items.CURIO, new Supplier[]{ModItems.MEMORY_STICK});
        this.addItemsToTag((TagKey<Item>)Tags.Items.FOODS_BREAD, new Supplier[]{ModItems.SOURDOUGH_BREAD});
        this.addItemsToTag(PneumaticCraftTags.Items.WRENCHES, new Supplier[]{ModItems.PNEUMATIC_WRENCH});
        this.addItemsToTag(PneumaticCraftTags.Items.GEARS, new Supplier[]{ModItems.COMPRESSED_IRON_GEAR});
        this.addItemsToTag(PneumaticCraftTags.Items.GEARS_COMPRESSED_IRON, new Supplier[]{ModItems.COMPRESSED_IRON_GEAR});
        this.addItemsToTag(PneumaticCraftTags.Items.COMPRESSED_IRON_ARMOR, new Supplier[]{ModItems.COMPRESSED_IRON_BOOTS, ModItems.COMPRESSED_IRON_LEGGINGS, ModItems.COMPRESSED_IRON_CHESTPLATE, ModItems.COMPRESSED_IRON_HELMET});
        this.addItemsToTag(PneumaticCraftTags.Items.PNEUMATIC_ARMOR, new Supplier[]{ModItems.PNEUMATIC_BOOTS, ModItems.PNEUMATIC_LEGGINGS, ModItems.PNEUMATIC_CHESTPLATE, ModItems.PNEUMATIC_HELMET});
        this.appendToTag((TagKey<Item>)ItemTags.FREEZE_IMMUNE_WEARABLES, PneumaticCraftTags.Items.COMPRESSED_IRON_ARMOR, PneumaticCraftTags.Items.PNEUMATIC_ARMOR);
        ModItems.ITEMS.getEntries().forEach(h -> {
            Object patt0$temp = h.get();
            if (patt0$temp instanceof UpgradeItem) {
                UpgradeItem u = (UpgradeItem)patt0$temp;
                this.addItemsToTag(PneumaticCraftTags.Items.UPGRADES, () -> u);
            }
        });
        this.tag(PneumaticCraftTags.Items.AMADRON_TABLET_UPGRADE_BLACKLIST);
        this.tag(PneumaticCraftTags.Items.ARMOR_UPGRADE_BLACKLIST);
        this.tag(PneumaticCraftTags.Items.DRONE_UPGRADE_BLACKLIST);
        this.tag(PneumaticCraftTags.Items.JACKHAMMER_UPGRADE_BLACKLIST);
        this.tag(PneumaticCraftTags.Items.MINIGUN_UPGRADE_BLACKLIST);
    }

    @SafeVarargs
    private void addItemsToTag(TagKey<Item> tag, Supplier<? extends ItemLike> ... items) {
        this.tag(tag).add((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::asItem).toArray(Item[]::new)));
    }

    @SafeVarargs
    private void appendToTag(TagKey<Item> tag, TagKey<Item> ... toAppend) {
        this.tag(tag).addTags(toAppend);
    }

    public String getName() {
        return "PneumaticCraft Item Tags";
    }
}

