/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.base.Splitter;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Vector3f;

public class PneumaticCraftUtils {
    private static final BlockPos INVALID_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    private static final int MAX_CHAR_PER_LINE = 45;
    public static final Vector3f VEC3F_ZERO = new Vector3f();

    public static List<? extends Component> splitStringComponent(String text) {
        return PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(text, 45));
    }

    public static List<String> splitString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("\n"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                for (String word : Splitter.fixedLength((int)maxCharPerLine).split((CharSequence)token)) {
                    int idx = word.lastIndexOf("\u00a7");
                    if (idx >= 0 && idx < word.length() - 1) {
                        format = word.substring(idx, idx + 2);
                        lineLen -= 2;
                    }
                    if (lineLen + word.length() > maxCharPerLine) {
                        result.add(builder.toString());
                        builder.delete(0, builder.length());
                        builder.append(format);
                        lineLen = 0;
                    } else if (lineLen > 0) {
                        builder.append(" ");
                        ++lineLen;
                    }
                    builder.append(word);
                    lineLen += word.length();
                }
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static List<String> splitString(String text) {
        return PneumaticCraftUtils.splitString(text, 45);
    }

    public static List<? extends Component> asStringComponent(List<String> l) {
        return l.stream().map(Component::literal).toList();
    }

    public static String convertTicksToMinutesAndSeconds(long ticks, boolean fraction) {
        Object part = String.valueOf(ticks % 20L * 5L);
        if (((String)part).length() < 2) {
            part = "0" + (String)part;
        }
        if ((ticks /= 20L) < 60L) {
            return ticks + (String)(fraction ? "." + (String)part : "") + "s";
        }
        return ticks / 60L + "m " + ticks % 60L + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 10000) {
            return NumberFormat.getNumberInstance(Locale.getDefault()).format(amount);
        }
        if (amount < 1000000) {
            return amount / 1000 + "K";
        }
        return amount / 1000000 + "M";
    }

    public static String roundNumberTo(double value, int decimals) {
        String fmtStr = "%." + decimals + "f";
        return String.format(fmtStr, PneumaticCraftUtils.roundNumberToDouble(value, decimals));
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, RoundingMode.HALF_DOWN).doubleValue();
    }

    public static boolean epsilonEquals(float f1, float f2) {
        return PneumaticCraftUtils.epsilonEquals(f1, f2, 1.0E-4f);
    }

    public static boolean epsilonEquals(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    public static boolean epsilonEquals(double d1, double d2) {
        return PneumaticCraftUtils.epsilonEquals(d1, d2, 1.0E-4);
    }

    public static boolean epsilonEquals(double d1, double d2, double maxDifference) {
        return Math.abs(d1 - d2) < maxDifference;
    }

    public static List<Component> summariseItemStacks(List<Component> textList, List<ItemStack> originalStacks) {
        return PneumaticCraftUtils.summariseItemStacks(textList, originalStacks, Symbols.bullet());
    }

    public static List<Component> summariseItemStacks(List<Component> textList, List<ItemStack> originalStacks, MutableComponent prefix) {
        List sortedStacks = originalStacks.stream().sorted((o1, o2) -> o1.getHoverName().getString().compareToIgnoreCase(o2.getHoverName().getString())).toList();
        int itemCount = 0;
        ItemStack prevItemStack = ItemStack.EMPTY;
        List<ItemStack> prevInventoryItems = null;
        for (ItemStack stack : sortedStacks) {
            if (stack.isEmpty()) continue;
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)prevItemStack) || prevInventoryItems != null && !prevInventoryItems.isEmpty()) {
                if (!prevItemStack.isEmpty()) {
                    textList.add((Component)prefix.copy().append(PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.getHoverName().getString()));
                }
                if (prevInventoryItems != null) {
                    PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems, prefix.copy().append("\u21b3 "));
                }
                prevItemStack = stack;
                itemCount = stack.getCount();
            } else {
                itemCount += stack.getCount();
            }
            prevInventoryItems = ItemRegistry.getInstance().getStacksInItem(stack);
        }
        if (itemCount > 0 && !prevItemStack.isEmpty()) {
            textList.add((Component)prefix.copy().append(PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.getHoverName().getString()));
            PneumaticCraftUtils.summariseItemStacks(textList, prevInventoryItems, prefix.copy().append("\u21b3 "));
        }
        return textList;
    }

    private static void addText(List<Component> l, String s) {
        l.add((Component)Component.literal((String)s));
    }

    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        URL myUrl = URI.create(urlString).toURL();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(myUrl.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.lineSeparator());
            }
        }
        return all.toString();
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, x, y, z);
    }

    public static double distBetween(Vec3i pos1, Vec3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5);
    }

    public static boolean doesItemMatchFilter(@Nonnull ItemStack filterStack, @Nonnull ItemStack stack, boolean checkDurability, boolean checkComponents, boolean checkModSimilarity) {
        if (filterStack.isEmpty() && stack.isEmpty()) {
            return true;
        }
        if (filterStack.isEmpty() || stack.isEmpty()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = PneumaticCraftUtils.getRegistryName(filterStack.getItem()).map(ResourceLocation::getNamespace).orElse("");
            String mod2 = PneumaticCraftUtils.getRegistryName(stack.getItem()).map(ResourceLocation::getNamespace).orElse("");
            return mod1.equals(mod2);
        }
        Item mod2 = filterStack.getItem();
        if (mod2 instanceof IFilteringItem) {
            IFilteringItem f = (IFilteringItem)mod2;
            return f.matchFilter(filterStack, stack);
        }
        IFilteringItem filterCap = (IFilteringItem)filterStack.getCapability(PNCCapabilities.ITEM_FILTERING);
        if (filterCap != null) {
            return filterCap.matchFilter(filterStack, stack);
        }
        if (filterStack.getItem() != stack.getItem()) {
            return false;
        }
        boolean durabilityOK = !checkDurability || filterStack.getMaxDamage() > 0 && filterStack.getDamageValue() == stack.getDamageValue();
        boolean compOK = !checkComponents || Objects.equals(filterStack.getComponents(), stack.getComponents());
        return durabilityOK && compOK;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof LiquidBlock;
    }

    public static void dropItemOnGround(ItemStack stack, Level world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, Level world, double x, double y, double z) {
        float dX = world.random.nextFloat() * 0.8f + 0.1f;
        float dY = world.random.nextFloat() * 0.8f + 0.1f;
        float dZ = world.random.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, x + (double)dX, y + (double)dY, z + (double)dZ, stack.copy());
        float factor = 0.05f;
        entityItem.setDeltaMovement(world.random.nextGaussian() * (double)factor, world.random.nextGaussian() * (double)factor + 0.2, world.random.nextGaussian() * (double)factor);
        world.addFreshEntity((Entity)entityItem);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, Level world, double x, double y, double z) {
        ItemEntity entityItem = new ItemEntity(world, x, y, z, stack.copy());
        entityItem.setDeltaMovement(0.0, 0.0, 0.0);
        world.addFreshEntity((Entity)entityItem);
    }

    public static ServerPlayer getPlayerFromId(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid);
    }

    public static ServerPlayer getPlayerFromName(String name) {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(name);
    }

    public static boolean isPlayerOp(Player player) {
        return player.hasPermissions(2);
    }

    public static boolean tryPlaceBlock(Level w, BlockPos pos, Player player, Direction face, BlockState newState) {
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)w.dimension(), (LevelAccessor)w, (BlockPos)pos);
        if (!EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)snapshot, (Direction)face)) {
            w.setBlockAndUpdate(pos, newState);
            return true;
        }
        return false;
    }

    public static Mob createDummyEntity(Player player) {
        Zombie dummy = new Zombie(player.level());
        dummy.setPos(player.getX(), player.getY(), player.getZ());
        return dummy;
    }

    public static boolean consumeInventoryItem(Inventory inv, Item item) {
        for (int i = 0; i < inv.items.size(); ++i) {
            if (((ItemStack)inv.items.get(i)).getItem() != item) continue;
            ((ItemStack)inv.items.get(i)).shrink(1);
            if (((ItemStack)inv.items.get(i)).getCount() <= 0) {
                inv.items.set(i, (Object)ItemStack.EMPTY);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeInventoryItem(Inventory inv, ItemStack stack) {
        int toConsume = stack.getCount();
        for (int i = 0; i < inv.items.size(); ++i) {
            ItemStack invStack = (ItemStack)inv.items.get(i);
            int consumed = 0;
            if (ItemStack.isSameItem((ItemStack)invStack, (ItemStack)stack)) {
                consumed = Math.min(invStack.getCount(), stack.getCount());
                invStack.shrink(consumed);
            } else {
                IItemHandler handler = (IItemHandler)invStack.getCapability(Capabilities.ItemHandler.ITEM);
                if (handler != null) {
                    for (int j = 0; j < handler.getSlots(); ++j) {
                        ItemStack invStack2 = handler.getStackInSlot(j);
                        if (!ItemStack.isSameItem((ItemStack)invStack2, (ItemStack)stack)) continue;
                        int extracted = Math.min(invStack2.getCount(), stack.getCount());
                        ItemStack s = handler.extractItem(j, extracted, false);
                        consumed = s.getCount();
                        break;
                    }
                }
            }
            if ((toConsume -= consumed) > 0) continue;
            return true;
        }
        return toConsume <= 0;
    }

    public static NonNullList<ItemStack> collectNonEmptyItems(IItemHandler handler, NonNullList<ItemStack> items) {
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).isEmpty()) continue;
                items.add((Object)handler.getStackInSlot(i));
            }
        }
        return items;
    }

    public static void forceDropContents(Level level, BlockPos pos, IItemHandler handler) {
        PneumaticCraftUtils.collectNonEmptyItems(handler, (NonNullList<ItemStack>)NonNullList.create()).forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, level, pos));
    }

    public static MutableComponent xlate(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static MutableComponent dyeColorDesc(int c) {
        return Component.translatable((String)("color.minecraft." + DyeColor.byId((int)c).getName())).withStyle(ChatFormatting.BOLD);
    }

    public static ItemStackHandler copyItemHandler(IItemHandler source, ItemStackHandler dest, int maxSlots) {
        int nSlots = Math.min(maxSlots, source.getSlots());
        dest.setSize(nSlots);
        for (int i = 0; i < nSlots; ++i) {
            dest.setStackInSlot(i, source.getStackInSlot(i).copy());
        }
        return dest;
    }

    public static ItemStackHandler copyItemHandler(IItemHandler source, ItemStackHandler dest) {
        return PneumaticCraftUtils.copyItemHandler(source, dest, source.getSlots());
    }

    public static String posToString(@Nullable BlockPos pos) {
        return PneumaticCraftUtils.isValidPos(pos) ? String.format("%d, %d, %d", pos.getX(), pos.getY(), pos.getZ()) : "-";
    }

    public static boolean isValidPos(@Nullable BlockPos pos) {
        return pos != null && pos != INVALID_POS;
    }

    public static BlockPos invalidPos() {
        return INVALID_POS;
    }

    public static <T extends BlockEntity> Optional<T> getBlockEntityAt(BlockGetter w, BlockPos pos, Class<T> cls) {
        BlockEntity te;
        if (w != null && pos != null && (te = w.getBlockEntity(pos)) != null && cls.isAssignableFrom(te.getClass())) {
            return Optional.of(te);
        }
        return Optional.empty();
    }

    public static boolean fillTankWithOrb(IFluidHandler handler, ExperienceOrb orb, IFluidHandler.FluidAction action) {
        int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
        int fluidAmount = orb.getValue() * ratio;
        FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
        int filled = handler.fill(toFill, action);
        if (filled > 0 && filled < fluidAmount && action.execute()) {
            orb.value -= Math.max(1, filled / ratio);
        }
        return filled == fluidAmount;
    }

    public static double getPlayerReachDistance(Player player) {
        AttributeInstance attr;
        if (player != null && (attr = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE)) != null) {
            return attr.getValue() + 1.0;
        }
        return 4.5;
    }

    public static boolean canPlayerReach(Player player, BlockPos pos) {
        if (player == null) {
            return false;
        }
        double dist = PneumaticCraftUtils.getPlayerReachDistance(player);
        return player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) <= dist * dist;
    }

    public static boolean isInteger(String str) {
        if (str.isEmpty() || str.equals("-")) {
            return true;
        }
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        return NumberUtils.isDigits((String)str);
    }

    public static boolean isNumber(String str) {
        if (((String)str).isEmpty() || ((String)str).equals("-")) {
            return true;
        }
        if (((String)str).startsWith("-")) {
            str = ((String)str).substring(1);
        }
        if (((String)str).endsWith(".")) {
            str = (String)str + "0";
        }
        return NumberUtils.isParsable((String)str);
    }

    public static ResourceLocation modDefaultedRL(String str) {
        return str.indexOf(58) > 0 ? ResourceLocation.parse((String)str) : PneumaticRegistry.RL(str);
    }

    public static String modDefaultedString(ResourceLocation rl) {
        return rl.getNamespace().equals("pneumaticcraft") ? rl.getPath() : rl.toString();
    }

    public static Component getBlockNameAt(Level level, BlockPos pos) {
        return level.isLoaded(pos) ? PneumaticCraftUtils.xlate(level.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]) : Component.empty().plainCopy();
    }

    public static Set<TagKey<Item>> itemTags(Item item) {
        return item.builtInRegistryHolder().tags().collect(Collectors.toSet());
    }

    public static Optional<ResourceLocation> getRegistryName(Item item) {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ITEM, item);
    }

    public static Optional<ResourceLocation> getRegistryName(Block block) {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.BLOCK, block);
    }

    public static Optional<ResourceLocation> getRegistryName(Fluid fluid) {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.FLUID, fluid);
    }

    public static Optional<ResourceLocation> getRegistryName(Entity entity) {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, entity.getType());
    }

    public static <T> Optional<ResourceLocation> getRegistryName(Registry<T> registry, T object) {
        return Optional.ofNullable(registry.getKey(object));
    }

    public static Component combineComponents(List<Component> components) {
        return (Component)components.stream().reduce((c1, c2) -> c1.copy().append("\n").append(c2)).orElse(Component.empty());
    }

    public static Optional<GameProfile> getProfileForName(MinecraftServer server, String playerName) {
        if (server == null || server.getProfileCache() == null) {
            return Optional.empty();
        }
        return server.getProfileCache().get(playerName);
    }

    public static <T> Optional<T> getOptionalComponent(ItemStack stack, DataComponentType<T> type) {
        return Optional.ofNullable(stack.get(type));
    }
}

