/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;

public class PressureEnchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_enchanting");

    public PressureEnchantingRecipe(CraftingBookCategory ignoredCategory) {
        super(Collections.emptyList(), 2.0f, List.of());
    }

    @Override
    public IntCollection findIngredients(@Nonnull IItemHandler chamberHandler) {
        ItemStack stack;
        int i;
        IntArrayList bookSlots = new IntArrayList();
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (stack.getItem() != Items.ENCHANTED_BOOK) continue;
            bookSlots.add(i);
        }
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (!stack.isEnchantable() && !stack.isEnchanted()) continue;
            IntListIterator intListIterator = bookSlots.iterator();
            while (intListIterator.hasNext()) {
                int bookSlot = (Integer)intListIterator.next();
                ItemStack enchantedBook = chamberHandler.getStackInSlot(bookSlot);
                if (!this.isApplicable(enchantedBook, stack)) continue;
                return IntList.of((int)bookSlot, (int)i);
            }
        }
        return IntList.of();
    }

    private boolean isApplicable(ItemStack enchantedBook, ItemStack enchantable) {
        ItemEnchantments bookMap = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantedBook);
        return bookMap.entrySet().stream().anyMatch(entry -> enchantable.isPrimaryItemFor((Holder)entry.getKey()) && enchantable.getEnchantmentLevel((Holder)entry.getKey()) < entry.getIntValue());
    }

    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        ItemStack newBook;
        ItemStack enchantedBook = chamberHandler.getStackInSlot(ingredientSlots.getInt(0));
        ItemStack enchantable = chamberHandler.getStackInSlot(ingredientSlots.getInt(1)).copyWithCount(1);
        ItemEnchantments.Mutable bookEnchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantedBook));
        Set itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantable).keySet();
        HashSet toTransfer = new HashSet();
        bookEnchantments.keySet().forEach(entry -> {
            if (enchantable.supportsEnchantment(entry) && itemEnchantments.stream().allMatch(e -> Enchantment.areCompatible((Holder)e, (Holder)entry))) {
                enchantable.enchant(entry, bookEnchantments.getLevel(entry));
                toTransfer.add(entry);
            }
        });
        if (toTransfer.isEmpty()) {
            return NonNullList.create();
        }
        bookEnchantments.keySet().removeAll(toTransfer);
        if (bookEnchantments.keySet().isEmpty()) {
            newBook = new ItemStack((ItemLike)Items.BOOK);
        } else {
            newBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)newBook, (ItemEnchantments)bookEnchantments.toImmutable());
        }
        chamberHandler.extractItem(ingredientSlots.getInt(0), 1, simulate);
        chamberHandler.extractItem(ingredientSlots.getInt(1), 1, simulate);
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{newBook, enchantable});
    }

    @Override
    public List<List<ItemStack>> getInputsForDisplay(HolderLookup.Provider provider) {
        Holder<Enchantment> fortune = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
        ItemStack enchBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchBook.enchant(fortune, 1);
        return List.of(List.of(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE)), List.of(enchBook));
    }

    @Override
    public List<ItemStack> getSingleResultsForDisplay(HolderLookup.Provider provider) {
        Holder<Enchantment> fortune = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
        ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        pick.enchant(fortune, 1);
        return List.of(pick, new ItemStack((ItemLike)Items.BOOK));
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.getItem() == Items.ENCHANTED_BOOK || stack.isEnchantable();
    }

    @Override
    public String getTooltipKey(boolean input, String slotName) {
        return switch (slotName) {
            case "in0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItem";
            case "in1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBook";
            case "out0" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantItemOut";
            case "out1" -> "pneumaticcraft.gui.nei.tooltip.pressureEnchantBookOut";
            default -> "";
        };
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER_ENCHANTING.get();
    }
}

