/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.WildcardedRLMatcher;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;

public class PressureDisenchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticRegistry.RL("pressure_chamber_disenchanting");
    private static final Lazy<WildcardedRLMatcher> BLACKLIST = WildcardedRLMatcher.lazyFromConfig(ConfigHelper.common().machines.disenchantingBlacklist);

    public PressureDisenchantingRecipe(CraftingBookCategory ignoredCategory) {
        super(Collections.emptyList(), -0.75f, List.of());
    }

    @Override
    public IntCollection findIngredients(@Nonnull IItemHandler chamberHandler) {
        int bookSlot = -1;
        int itemSlot = -1;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack stack = chamberHandler.getStackInSlot(i);
            if (stack.getItem() == Items.BOOK) {
                bookSlot = i;
            } else {
                int minEnchantments;
                int n = minEnchantments = stack.getItem() == Items.ENCHANTED_BOOK ? 2 : 1;
                if (!this.blacklisted(stack) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).size() >= minEnchantments) {
                    itemSlot = i;
                }
            }
            if (bookSlot < 0 || itemSlot < 0) continue;
            return IntList.of((int)bookSlot, (int)itemSlot);
        }
        return IntList.of();
    }

    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        ItemStack book = chamberHandler.extractItem(ingredientSlots.getInt(0), 1, simulate);
        ItemStack enchantedStack = chamberHandler.extractItem(ingredientSlots.getInt(1), 1, simulate);
        if (book.isEmpty() || enchantedStack.isEmpty()) {
            return NonNullList.create();
        }
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantedStack));
        ArrayList l = new ArrayList(enchantments.keySet());
        Holder strippedEnchantment = (Holder)l.get(ThreadLocalRandom.current().nextInt(l.size()));
        int level = enchantments.getLevel(strippedEnchantment);
        enchantments.removeIf(e -> e.value() == strippedEnchantment.value());
        if (enchantedStack.getItem() == Items.ENCHANTED_BOOK) {
            enchantedStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        EnchantmentHelper.setEnchantments((ItemStack)enchantedStack, (ItemEnchantments)enchantments.toImmutable());
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        ItemEnchantments.Mutable newEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        newEnchantments.set(strippedEnchantment, level);
        EnchantmentHelper.setEnchantments((ItemStack)enchantedBook, (ItemEnchantments)newEnchantments.toImmutable());
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{enchantedBook, enchantedStack});
    }

    @Override
    public List<List<ItemStack>> getInputsForDisplay(HolderLookup.Provider provider) {
        Holder<Enchantment> fortune = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
        Holder<Enchantment> efficiency = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        pick.enchant(fortune, 1);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchantedBook.enchant(fortune, 1);
        enchantedBook.enchant(efficiency, 1);
        return List.of(List.of(pick), List.of(new ItemStack((ItemLike)Items.BOOK)));
    }

    @Override
    public List<List<ItemStack>> getResultsForDisplay(HolderLookup.Provider provider) {
        Holder<Enchantment> fortune = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
        Holder<Enchantment> efficiency = EnchantmentUtils.getEnchantment(provider, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
        ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchantedBook.enchant(efficiency, 1);
        ItemStack resultBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        resultBook.enchant(fortune, 1);
        return List.of(List.of(pick, enchantedBook), List.of(resultBook));
    }

    @Override
    public List<Set<PressureChamberRecipe.RecipeSlot>> getSyncGroupsForDisplay() {
        return ImmutableList.of((Object)ImmutableSet.of((Object)new PressureChamberRecipe.RecipeSlot(true, 0), (Object)new PressureChamberRecipe.RecipeSlot(false, 0)));
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.getItem() == Items.BOOK || stack.getItem() != Items.ENCHANTED_BOOK && !EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty();
    }

    @Override
    public String getTooltipKey(boolean input, String slotName) {
        return switch (slotName) {
            case "in0" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItem";
            case "out0" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantItemOut";
            case "out1" -> "pneumaticcraft.gui.nei.tooltip.vacuumEnchantBookOut";
            default -> "";
        };
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER_DISENCHANTING.get();
    }

    private boolean blacklisted(ItemStack stack) {
        return PneumaticCraftUtils.getRegistryName(stack.getItem()).map(name -> ((WildcardedRLMatcher)BLACKLIST.get()).test((ResourceLocation)name)).orElse(false);
    }

    public static void clearCachedBlacklist() {
        BLACKLIST.invalidate();
    }
}

