/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.handler;

import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.SavedUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ChargeableItemHandler
extends BaseItemStackHandler {
    private boolean inInit = true;

    public ChargeableItemHandler(ChargingStationBlockEntity te) {
        super(te, 9);
        this.readFromChargingStack();
        this.inInit = false;
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.writeToChargingStack();
    }

    private ItemStack getChargingStack() {
        return ((ChargingStationBlockEntity)this.te).getChargingStack();
    }

    public void writeToChargingStack() {
        if (!this.inInit) {
            UpgradableItemUtils.setUpgrades(this.getChargingStack(), (IItemHandler)this);
        }
    }

    private void readFromChargingStack() {
        ((SavedUpgrades)this.getChargingStack().getOrDefault(ModDataComponents.ITEM_UPGRADES, (Object)SavedUpgrades.EMPTY)).fillItemHandler(this);
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return itemStack.isEmpty() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
    }

    private boolean isUnique(int slot, ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (i == slot || PNCUpgrade.from(stack) != PNCUpgrade.from(this.getStackInSlot(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isApplicable(ItemStack stack) {
        Item chargeableItem = this.getChargingStack().getItem();
        return !ChargeableItemHandler.isItemBlacklisted(chargeableItem, stack) && ApplicableUpgradesDB.getInstance().getMaxUpgrades(chargeableItem, PNCUpgrade.from(stack)) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isItemBlacklisted(Item item, ItemStack stack) {
        if (!(item instanceof IChargeableContainerProvider)) return false;
        IChargeableContainerProvider p = (IChargeableContainerProvider)item;
        if (p.getUpgradeBlacklistTag().map(arg_0 -> ((ItemStack)stack).is(arg_0)).orElse(false) == false) return false;
        return true;
    }
}

